	/**********************************************************
	* Copyright (C) Data General, A Division of EMC Corporation, 1984-1995, 2000	  *
	* All Rights Reserved.					  *
	* Licensed Material-Property of Data General, A Division of EMC Corporation. *
	* This software is made available solely pursuant to the  *
	* terms of a DG license agreement which governs its use. *
	**********************************************************/

/*  <@(#) pwd.h,v	6.30.1.3>  */

#ifndef _PWD_H /* Prevent multiple inclusions of this file */
#define _PWD_H 


/*.module */

	/*<---------------------------------------------------*/
	/*                      pwd.h                         */
	/*>---------------------------------------------------*/

/*.Contents[=-----------------------------------------------------------
**
**	%decl(" struct passwd                ")	external interface
**	%decl(" struct comment               ")	external interface
**	%decl(" getpwuid function prototype  ")	external interface
**	%decl(" getpwnam function prototype  ")	external interface
**	%decl(" getpwent function prototype  ")	external interface
**
**.Description
**
**	%par()
**	Types, constants and function prototypes relevant to the
**	getpwuid() and getpwnam() calls.
**
**.End]=--------------------------------------------------------------*/

/*.Begin_Interface_Dependencies=--------------------------------------*/

#ifndef ___int_features_h
#include <sys/_int_features.h>
#endif

#ifndef __types_h
#include <sys/types.h>
#endif

/*.End_Interface_Dependencies=----------------------------------------*/

#if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || _IX86_ANY_DG || \
     _IX86_UW || _IX86_ABI || _IX86_BCS)

#ifdef _USING_POSIX_OR_XPG3_OR_SYSV3_OR_BSD_OR_DGUX

/*.type */


	/*<------*/
struct	   passwd
	/*>------*/
	{
	char *		pw_name;
	char *		pw_passwd;
	uid_t		pw_uid;
	gid_t		pw_gid;
	char * 		pw_age;
	char *		pw_comment;
	char *		pw_gecos;
	char *		pw_dir;
	char *		pw_shell;
	};

/*.Description[=--------------------------------------------------------
**
**	%par()
**	An entry from the user database.
**
**.Members
**
**	%decl(" pw_name      ")	The login name of the user.
**	%decl(" pw_passwd    ")	The encrypted password (if any) for the
**				user.
**	%decl(" pw_uid       ")	The numerical user id.
**	%decl(" pw_gid       ")	The numerical group id.
**	%decl(" pw_age       ")	A string denoting the algorithm to be
**				used in deciding when the user's
**				password has expired and must be
**				changed.
**	%decl(" pw_comment   ")	A field of optional string data.
**	%decl(" pw_gecos     ")	A field of optional string data.
**	%decl(" pw_dir       ")	The user's initial working directory.
**	%decl(" pw_shell     ")	The user's initial login program.
**
**.End]=--------------------------------------------------------------*/

#endif  /* #ifdef _USING_POSIX_OR_XPG3_OR_SYSV3_OR_BSD_OR_DGUX */

#endif /* #if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || \
               _IX86_ANY_DG || _IX86_UW || _IX86_ABI || _IX86_BCS) */

#if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || _IX86_ANY_DG || \
     _IX86_UW || _IX86_ABI)

#ifdef _USING_SYSV3_OR_DGUX

/*.type */


	/*<-------*/
struct	   comment
	/*>-------*/
	{
	char *		c_dept;
	char *		c_name;
	char *		c_acct;
	char *		c_bin;
	};

/*.Description[=--------------------------------------------------------
**
**	%par()
**	A System V password comment structure.
**
**.Members
**
**	%decl(" c_dept       ")	Department?
**	%decl(" c_name       ")	Name?
**	%decl(" c_acct       ")	Account?
**	%decl(" c_bin        ")	Bin directory?
**
**.End]=--------------------------------------------------------------*/

#endif  /* #ifdef _USING_SYSV3_OR_DGUX */


/*.Function_Prototype_Section[=-----------------------------------------
**
**	%par()
**	Function prototypes.
**
**.Description
**
**	%par()
**	ANSI C function prototypes for the POSIX functions that are
**	required in section 9.2.2 to appear in this file.
**
**.End]=--------------------------------------------------------------*/


#ifdef _USING_POSIX_OR_XPG3_OR_SYSV3_OR_BSD_OR_DGUX

_EXTERN struct passwd	*getpwuid	_PROTO_ARGS((uid_t));
_EXTERN struct passwd	*getpwnam	_PROTO_ARGS((const char *));

#endif  /* #ifdef _USING_POSIX_OR_XPG3_OR_SYSV3_OR_BSD_OR_DGUX */



#ifdef _USING_SYSV3_OR_BSD_OR_DGUX

#ifndef _STDIO_H
#include <stdio.h>
#endif

_EXTERN struct passwd	*getpwent	_PROTO_ARGS((void));
_EXTERN void		setpwent	_PROTO_ARGS((void));
_EXTERN void		endpwent	_PROTO_ARGS((void));
_EXTERN struct passwd	*fgetpwent	_PROTO_ARGS((FILE *));
_EXTERN int		putpwent	_PROTO_ARGS((const struct passwd *,
						     FILE *));

#endif  /* #ifdef _USING_SYSV3_OR_BSD_OR_DGUX */


/*[**/
/*.End_Section Function Prototypes */
/**]*/

#endif  /* #if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || \
                _IX86_ANY_DG || _IX86_UW || _IX86_ABI || _IX86_BCS) */

#if (_M88K_DG || _IX86_ANY_DG)

#ifdef _USING_POSIX4A_DRAFT6

#ifndef _POSIX4A_IMPLEMENTATION_CODE

#define	getpwuid_r	__d6_getpwuid_r
#define	getpwnam_r	__d6_getpwnam_r

#endif	/* ifndef _POSIX4A_IMPLEMENTATION_CODE */

_EXTERN struct passwd	*__d6_getpwuid_r _PROTO_ARGS((uid_t, struct passwd *,
						     char *, int));
_EXTERN struct passwd	*__d6_getpwnam_r _PROTO_ARGS((const char *,
						     struct passwd *, char *,
						     int));

#endif	/* #ifdef _USING_POSIX4A_DRAFT6 */

#ifdef _USING_POSIX4A_DRAFT10

#define getpwuid_r	__d10_getpwuid_r

#  if _ASM_LABEL_ENABLED

_EXTERN int	getpwuid_r _PROTO_ARGS((uid_t		__uid,
					struct passwd	*__pwd,
					char		*__buffer,
					size_t		__bufsize,
					struct passwd	**__result))
		_ASM_LABEL ("__d10_getpwuid_r");

_EXTERN int	_getpwuid_r _PROTO_ARGS((uid_t		__uid,
					 struct passwd	*__pwd,
					 char		*__buffer,
					 size_t		__bufsize,
					 struct passwd	**__result))
		_ASM_LABEL ("__d10_getpwuid_r");

#  else

_EXTERN int	__d10_getpwuid_r _PROTO_ARGS((uid_t		__uid,
					      struct passwd	*__pwd,
					      char		*__buffer,
					      size_t		__bufsize,
					      struct passwd	**__result));





#   if _PROTO_ARGS_ENABLED
static _INLINE int	getpwuid_r (uid_t		__uid,
				    struct passwd	*__pwd,
				    char		*__buffer,
				    size_t		__bufsize,
				    struct passwd	**__result)
#   else
static _INLINE int	getpwuid_r (__uid,
				    __pwd,
				    __buffer,
				    __bufsize,
				    __result)
    uid_t		__uid;
    struct passwd	*__pwd;
    char		*__buffer;
    size_t		__bufsize;
    struct passwd	**__result;
#   endif
#   if ! _HEADER_DEBUG_INFO_ENABLED
#line 1
#   endif
{
  (void)getpwuid_r;	/* Ensure that function is "used". */
  return __d10_getpwuid_r(__uid,
			  __pwd,
			  __buffer,
			  __bufsize,
			  __result);
}



#   if _PROTO_ARGS_ENABLED
static _INLINE int	_getpwuid_r (uid_t		__uid,
				     struct passwd	*__pwd,
				     char		*__buffer,
				     size_t		__bufsize,
				     struct passwd	**__result)
#   else
static _INLINE int	_getpwuid_r (__uid,
				     __pwd,
				     __buffer,
				     __bufsize,
				     __result)
    uid_t		__uid;
    struct passwd	*__pwd;
    char		*__buffer;
    size_t		__bufsize;
    struct passwd	**__result;
#   endif
#   if ! _HEADER_DEBUG_INFO_ENABLED
#line 1
#   endif
{
  (void)_getpwuid_r;	/* Ensure that function is "used". */
  return __d10_getpwuid_r(__uid,
			  __pwd,
			  __buffer,
			  __bufsize,
			  __result);
}

#  endif /* _ASM_LABEL_ENABLED */


#  if _ASM_LABEL_ENABLED

_EXTERN int	getpwnam_r _PROTO_ARGS((const char	*__name,
					struct passwd	*__pwd,
					char		*__buffer,
					size_t		__bufsize,
					struct passwd	**__result))
		_ASM_LABEL ("__d10_getpwnam_r");

_EXTERN int	_getpwnam_r _PROTO_ARGS((const char	*__name,
					 struct passwd	*__pwd,
					 char		*__buffer,
					 size_t		__bufsize,
					 struct passwd	**__result))
		_ASM_LABEL ("__d10_getpwnam_r");

#  else

_EXTERN int	__d10_getpwnam_r _PROTO_ARGS((const char	*__name,
					      struct passwd	*__pwd,
					      char		*__buffer,
					      size_t		__bufsize,
					      struct passwd	**__result));



#   if _PROTO_ARGS_ENABLED
static _INLINE int	getpwnam_r (const char		*__name,
				    struct passwd	*__pwd,
				    char		*__buffer,
				    size_t		__bufsize,
				     struct passwd	**__result)
#   else
static _INLINE int	getpwnam_r (__name,
				    __pwd,
				    __buffer,
				    __bufsize,
				    __result)
    const char		*__name;
    struct passwd	*__pwd;
    char		*__buffer;
    size_t		__bufsize;
    struct passwd	**__result;
#   endif
#   if ! _HEADER_DEBUG_INFO_ENABLED
#line 1
#   endif
{
  (void)getpwnam_r;	/* Ensure that function is "used". */
  return __d10_getpwnam_r(__name,
			  __pwd,
			  __buffer,
			  __bufsize,
			  __result);
}


#   if _PROTO_ARGS_ENABLED
static _INLINE int	_getpwnam_r (const char	*__name,
				     uid_t		__uid,
				     struct passwd	*__pwd,
				     char		*__buffer,
				     size_t		__bufsize,
				     struct passwd	**__result)
#   else
static _INLINE int	_getpwnam_r (__name,
				     __uid,
				     __pwd,
				     __buffer,
				     __bufsize,
				     __result)
    const char		*__name;
    uid_t		__uid;
    struct passwd	*__pwd;
    char		*__buffer;
    size_t		__bufsize;
    struct passwd	**__result;
#   endif
#   if ! _HEADER_DEBUG_INFO_ENABLED
#line 1
#   endif
{
  (void)_getpwnam_r;	/* Ensure that function is "used". */
  return __d10_getpwnam_r(__name,
			  __pwd,
			  __buffer,
			  __bufsize,
			  __result);
}

#  endif /* _ASM_LABEL_ENABLED */
#endif	/* #ifdef _USING_POSIX4A_DRAFT10 */
#ifdef _DGUX_THREADS_EXTENSIONS

#define	fgetpwent_r	__dg_1_fgetpwent_r
#define	getpwent_r	__dg_1_getpwent_r

#ifndef _STDIO_H
#include <stdio.h>
#endif

_EXTERN struct passwd	*fgetpwent_r	_PROTO_ARGS((FILE *, struct passwd *,
						     char *, int));
_EXTERN struct passwd	*getpwent_r	_PROTO_ARGS((struct passwd *,
						     char *, int));

#endif	/* #ifdef _DGUX_THREADS_EXTENSIONS */

#endif	/* #if (_M88K_DG || _IX86_ANY_DG) */


/*[**/
/*.End_Module pwd.h */
/**]*/

#endif /* #ifndef _PWD_H */
