.\" $TOG: xrx.man /main/6 1998/02/10 18:30:01 kaleb $
.\" Copyright 1996, 1998  The Open Group
.\" 
.\" All Rights Reserved.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\" 
.TH XRX 1 "Release 6.4" "X Version 11"
.SH NAME
xrx - RX helper program
.SH SYNOPSIS
\fBxrx\fP [\-\fItoolkitoption\fP ...] \fIfilename\fP
.SH DESCRIPTION
The helper program may be used with any Web browser to interpret documents
in the RX MIME type format and start remote applications.
.PP
\fBxrx\fP reads in the RX document specified by its \fIfilename\fP, from
which it gets the list of services the application wants to use. Based on
this information, \fBxrx\fP sets the various requested services, including
creating authorization keys if your X server supports the SECURITY
extension. It then passes the relevant data, such as the X display name, to
the application through an HTTP GET request of the associated CGI
script. The Web server then executes the CGI script to start the
application. The client runs on the web server host connected to your X
server.
.PP
.SH INSTALLATION
You need to configure your web browser to use \fBxrx\fP for RX documents.
Generally the following line in your $HOME/.mailcap is enough:
      application/x-rx; xrx %s
.PP
However, you may need to refer to your web browser's documentation for exact
instructions on configuring helper applications.
.PP
Once correctly configured, your browser will activate the helper program
whenever you retrieve any document of the MIME type \fIapplication/x-rx\fP.
.PP
.SH OPTIONS
The \fIxrx\fP helper program accepts all of the standard X Toolkit command
line options such as:
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used. There may be several
instances of this option on the command line.
.PP
.SH RESOURCES
The application class name of the \fIxrx\fP program is Xrx and it
understands the following application resource names and classes:
.\".in +1in
.TP 8
.B "xrxHasFirewallProxy (\fPclass\fB XrxHasFirewallProxy)"
Specifies whether an X server firewall proxy (see xfwp) is running and
should be used. Default is ``False.''
.TP 8
.B "xrxInternalWebServers (\fPclass\fB XrxInternalWebServers)"
The web servers for which the X server firewall proxy should not be used
(only relevant when \fBxrxHasFirewallProxy\fP is ``True''). Its value is a
comma separated list of mask/value pairs to be used to filter internal
web servers, based on their address. The mask part specifies which segments
of the address are to be considered and the value part specifies what the
result should match. For instance the following list:

      255.255.255.0/198.112.45.0, 255.255.255.0/198.112.46.0

matches the address sets: 198.112.45.* and 198.112.46.*. More precisely,
the test is (address & mask) == value.
.TP 8
.B "xrxFastWebServers (\fPclass\fB XrxFastWebServers)"
The web servers for which LBX should not be used. The resource value is a
list of address mask/value pairs, as previously described.
.TP 8
.B "xrxTrustedWebServers (\fPclass\fB XrxTrustedWebServers)"
The web servers from which remote applications should be run as trusted
clients. The default is to run remote applications as untrusted
clients. The resource value is a list of address mask/value pairs, as
previously described.
.PP
.SH ENVIRONMENT

The \fIxrx\fP helper program uses the standard X environment variables
such as ``DISPLAY'' to get the default X server host and display
number. If the RX document requests X-UI-LBX service and the default X
server does not advertise the LBX extension, \fIxrx\fP will look for the
environment variable ``XREALDISPLAY'' to get a second address for your X
server and look for the LBX extension there. When running your browser
through \fIlbxproxy\fP you will need to set XREALDISPLAY to the actual
address of your server if you wish remote applications to be able to use
LBX across the Internet.
.PP
If the RX document requests XPRINT service, \fIxrx\fP looks for the
variable ``XPRINTER'' to get the printer name and X Print server address to
use. If the server address is not specified as part of XPRINTER, \fIxrx\fP
uses the first one specified through the variable ``XPSERVERLIST'' when it
is set. When it is not \fIxrx\fP then tries to use the video server as the
print server. If the printer name is not specified via XPRINTER, \fIxrx\fP
looks for it in the variables ``PDPRINTER'', then ``LPDEST'', and finally
``PRINTER'',
.PP
Finally, if you are using a firewall proxy, \fIxrx\fP will look for
``PROXY_MANAGER'' to get the address of your proxy manager (see
proxymngr). When not specified it will use ":6500" as the default.
.PP
.SH KNOWN BUG
When an authorization key is created for a remote application to use the X
Print service, the helper program has to create the key with an infinite
timeout since nobody knows when the application will actually connect to
the X Print server. Therefore, in this case, the helper program stays
around to revoke the key when the application goes away (that is when its
video key expires). However, if the helper program dies unexpectedly the
print authorization key will never get revoked.
.PP
.SH SEE ALSO
libxrx (1), xfwp (1), lbxproxy (1), proxymngr (1),
The RX Document specification
.SH AUTHOR
Arnaud Le Hors, X Consortium
