'\"! eqn | mmdoc
'\"macro stdmacro
.ds Vn Version 1.2
.ds Dt 6 March 1997
.ds Re Release 1.2.0
.ds Dp Feb 16 02:56
.ds Dm  Feb 10 17:2
.ds Xs 58040 5 xswapbuffers.gl
.TH GLXSWAPBUFFERS
.SH NAME
.B "glXSwapBuffers
\- exchange front and back buffers

.SH C SPECIFICATION
void \f3glXSwapBuffers\fP(
Display \fI*dpy\fP,
.nf
.ta \w'\f3void \fPglXSwapBuffers( 'u
	GLXDrawable \fIdrawable\fP )
.fi

.EQ
delim $$
.EN
.SH PARAMETERS
.TP \w'\fIdrawable\fP\ \ 'u 
\f2dpy\fP
Specifies the connection to the X server.
.TP
\f2drawable\fP
Specifies the drawable whose buffers are to be swapped.
.SH DESCRIPTION
\f3glXSwapBuffers\fP promotes the contents of the back buffer of \f2drawable\fP to become
the contents of the front buffer of \f2drawable\fP.
The contents of the back buffer then become undefined.
The update typically takes place during the vertical retrace of
the monitor,
rather than immediately after \f3glXSwapBuffers\fP is called.
.P
\f3glXSwapBuffers\fP performs an implicit \f3glFlush\fP before it returns.
Subsequent OpenGL commands may be issued immediately after calling \f3glXSwapBuffers\fP,
but are not executed until the buffer exchange is completed.
.P
If \f2drawable\fP was not created with respect to a double-buffered visual,
\f3glXSwapBuffers\fP has no effect,
and no error is generated.
.SH NOTES
The contents of the back buffer become undefined after
a swap. Note that this applies to pbuffers as well as windows.
.P
All GLX rendering contexts share the same notion of which are front buffers
and which are back buffers.
One consequence is that when multiple clients are rendering to the same
double-buffered window,
all of them should finish rendering before one of them issues the command
to swap buffers.
The clients are responsible for implementing this synchronization.
Typically this is accomplished by executing \f3glFinish\fP and then
using a semaphore in shared memory to rendezvous before swapping.
.SH ERRORS
\f3GLXBadDrawable\fP is generated if \f2drawable\fP is not a valid GLX drawable.
.P
\f3GLXBadCurrentWindow\fP is generated if \f2dpy\fP and \f2drawable\fP are
respectively the display and drawable associated with the current
context of the calling thread, and \f2drawable\fP identifies a window that
is no longer valid.
.SH SEE ALSO
\f3glFlush\fP,
\f3glXBindSwapBarrierSGIX\fP,
\f3glXJoinSwapGroupSGIX\fP,
\f3glXSwapIntervalSGI\fP

