'\"! eqn | mmdoc
'\"macro stdmacro
.ds Vn Version 1.2
.ds Dt 6 March 1997
.ds Re Release 1.2.0
.ds Dp Feb 16 02:56
.ds Dm  Feb 10 17:2
.ds Xs 28564 7 xmakecurrent.gl
.TH GLXMAKECURRENT
.SH NAME
.B "glXMakeCurrent
\- attach a GLX context to a window or a GLX pixmap

.SH C SPECIFICATION
Bool \f3glXMakeCurrent\fP(
Display \fI*dpy\fP,
.nf
.ta \w'\f3Bool \fPglXMakeCurrent( 'u
	GLXDrawable \fIdrawable\fP,
	GLXContext \fIctx\fP )
.fi

.EQ
delim $$
.EN
.SH PARAMETERS
.TP \w'\fIdrawable\fP\ \ 'u 
\f2dpy\fP
Specifies the connection to the X server.
.TP
\f2drawable\fP
Specifies a GLX drawable.
Must be either an X window ID or a GLX pixmap ID.
.TP
\f2ctx\fP
Specifies a GLX rendering context that is to be attached to \f2drawable\fP.
.SH DESCRIPTION
\f3glXMakeCurrent\fP does two things:
It makes \f2ctx\fP the current GLX rendering context of the calling thread,
replacing the previously current context if there was one,
and it attaches \f2ctx\fP to a GLX drawable,
either a window or a GLX pixmap.
As a result of these two actions,
subsequent GL rendering calls
use rendering context \f2ctx\fP to modify GLX drawable \f2drawable\fP.
Because \f3glXMakeCurrent\fP always replaces the current rendering context with \f2ctx\fP,
there can be only one current context per thread.
.P
Pending commands to the
previous context, if any, are flushed before it is released.
.P
The first time \f2ctx\fP is made current to any thread,
its viewport is set to the full size of \f2drawable\fP.
Subsequent calls by any thread to \f3glXMakeCurrent\fP with \f2ctx\fP
have no effect on its viewport.
.P
To release the current context without assigning a new one,
call \f3glXMakeCurrent\fP with \f2drawable\fP set \f3None\fP and \f2ctx\fP
set to \f3NULL\fP
.P
\f3glXMakeCurrent\fP returns \f3True\fP if it is successful,
\f3False\fP otherwise.
If \f3False\fP is returned, the previously current rendering context
and drawable (if any) remain unchanged.
.SH NOTES
A \f2process\fP is a single-execution environment,
implemented in a single address space,
consisting of one or more threads.
.P
A \f2thread\fP is one of a set of subprocesses that share
a single address space,
but maintain separate program counters,
stack spaces,
and other related global data.
A \f2thread\fP that is the only member of its subprocess group
is equivalent to a \f2process\fP.
.SH ERRORS
\f3BadMatch\fP is generated if \f2drawable\fP was not
created with the same X screen and visual as \f2ctx\fP.
It is also generated if \f2drawable\fP is \f3None\fP and \f2ctx\fP is not
\f3NULL\fP.
.P
\f3BadAccess\fP is generated if \f2ctx\fP was current to another thread
at the time \f3glXMakeCurrent\fP was called.
.P
\f3GLXBadDrawable\fP is generated if \f2drawable\fP is not a valid GLX drawable.
.P
\f3GLXBadContext\fP is generated if \f2ctx\fP is not a valid GLX context.
.P
\f3GLXBadContextState\fP is generated if \f3glXMakeCurrent\fP is executed between
the execution of \f3glBegin\fP and the corresponding execution of \f3glEnd\fP.
.P
\f3GLXBadContextState\fP is also generated if the rendering context current
to the calling thread has GL renderer state \f3GL_FEEDBACK\fP or
\f3GL_SELECT\fP.
.P
\f3GLXBadCurrentWindow\fP is generated if there are pending GL
commands for the previous context and the current drawable is
a window that is no longer valid.
.P
\f3BadAlloc\fP may be generated if the server has delayed allocation
of ancillary buffers until \f3glXMakeCurrent\fP is called, only to find that it has
insufficient resources to complete the allocation.
.SH SEE ALSO
\f3glXCreateContext\fP,
\f3glXCreateGLXPixmap\fP

