'\"! eqn | mmdoc
'\"macro stdmacro
.ds Vn Version 1.2
.ds Dt 6 March 1997
.ds Re Release 1.2.0
.ds Dp Feb 16 02:56
.ds Dm  Feb 10 17:2
.ds Xs 16965 8 xcreatecontext.gl
.TH GLXCREATECONTEXT
.SH NAME
.B "glXCreateContext
\- create a new GLX rendering context

.SH C SPECIFICATION
GLXContext \f3glXCreateContext\fP(
Display \fI*dpy\fP,
.nf
.ta \w'\f3GLXContext \fPglXCreateContext( 'u
	XVisualInfo \fI*vis\fP,
	GLXContext \fIshareList\fP,
	Bool \fIdirect\fP )
.fi

.EQ
delim $$
.EN
.SH PARAMETERS
.TP \w'\fIshareList\fP\ \ 'u 
\f2dpy\fP
Specifies the connection to the X server.
.TP
\f2vis\fP
Specifies the visual that defines the frame buffer resources available to
the rendering context.
It is a pointer to an \f3XVisualInfo\fP structure,
not a visual ID or a pointer to a \f3Visual\fP.
.TP
\f2shareList\fP
Specifies the context with which to share display lists.
\f3NULL\fP indicates that no sharing is to take place.
.TP
\f2direct\fP
Specifies whether rendering is to be done with a direct connection
to the graphics system if possible (\f3True\fP)
or through the X server (\f3False\fP).
.SH DESCRIPTION
\f3glXCreateContext\fP creates a GLX rendering context and returns its handle.
This context can be used to render into both windows and GLX pixmaps.
If \f3glXCreateContext\fP fails to create a rendering context,
\f3NULL\fP is returned.
.P
If \f2direct\fP is \f3True\fP,
then a direct rendering context is created if the
implementation supports direct rendering, if the connection is to an X
server that is local, and if a direct rendering context is available. (An implementation may return an indirect context when \f2direct\fP is \f3True\fP).
If \f2direct\fP is \f3False\fP,
then a rendering context that renders through the X server is always created.
Direct rendering provides a performance advantage in some implementations.
However, direct rendering contexts cannot be shared outside a single process,
and they may be unable to render to GLX pixmaps.
.P
If \f2shareList\fP is not \f3NULL\fP,
then all display-list indexes and definitions are shared by
context \f2shareList\fP and by the newly created context.
An arbitrary number of contexts can share a single display-list space.
However,
all rendering contexts that share a single display-list space must
themselves exist in the same address space.
Two rendering contexts share an address space if both are nondirect
using the same server,
or if both are direct and owned by a single process.
Note that in the nondirect case, it is not necessary for the calling
threads to share an address space,
only for their related rendering contexts to share an address space.
.P  
If the GL version is 1.1 or greater, 
then all texture objects except object 0,  
are shared by any contexts that share display lists.
.SH NOTES
\f3XVisualInfo\fP is defined in \f2Xutil.h.\fP
It is a structure that includes \f2visual\fP, \f2visualID\fP, \f2screen\fP, and
\f2depth\fP elements.
.P
A \f2process\fP is a single execution environment,
implemented in a single address space,
consisting of one or more threads.
.P
A \f2thread\fP is one of a set of subprocesses that share
a single address space,
but maintain separate program counters,
stack spaces,
and other related global data.
A \f2thread\fP that is the only member of its subprocess group
is equivalent to a \f2process\fP.
.P
It may not be possible to render to a GLX pixmap with a direct rendering 
context.
.SH ERRORS
\f3NULL\fP is returned if execution fails on the client side.
.P
\f3BadMatch\fP is generated if the context to be created would not
share the address space or the screen of the context specified by \f2shareList\fP.
.P
\f3BadValue\fP is generated if \f2vis\fP is not a valid visual (for
example, if a particular GLX implementation does not support it).
.P
\f3GLXBadContext\fP is generated if \f2shareList\fP is not a GLX context
and is not \f3NULL\fP.
.P
\f3BadAlloc\fP is generated if the server does not have enough
resources to allocate the new context.
.SH SEE ALSO
\f3glXDestroyContext\fP,
\f3glXGetConfig\fP,
\f3glXIsDirect\fP,
\f3glXMakeCurrent\fP

