'\"! eqn | mmdoc
'\"macro stdmacro
.ds Vn Version 1.2
.ds Dt 6 March 1997
.ds Re Release 1.2.0
.ds Dp Feb 16 02:57
.ds Dm  Feb 10 17:2
.ds Xs 20029 2 xwaitx.gl
.TH GLXWAITX
.SH NAME
.B "glXWaitX
\- complete X execution prior to subsequent GL calls

.SH C SPECIFICATION
void \f3glXWaitX\fP( void )
.nf
.fi

.EQ
delim $$
.EN
.SH DESCRIPTION
X rendering calls made prior to \f3glXWaitX\fP are guaranteed to be
executed before GL rendering calls made after \f3glXWaitX\fP.
Although the same result can be achieved using \f3XSync\fP,
\f3glXWaitX\fP does not require a round trip to the server,
and it is therefore more efficient in cases where client and server
are on separate machines.
.P
\f3glXWaitX\fP is ignored if there is no current GLX context.
.SH NOTES
\f3glXWaitX\fP may or may not flush the GL stream.
.SH ERRORS
\f3GLXBadCurrentWindow\fP is generated if the drawable associated
with the current context of the calling thread is a window, and that
window is no longer valid.
.SH SEE ALSO
\f3glFinish\fP,
\f3glFlush\fP,
\f3glXWaitGL\fP,
\f3XSync\fP

