# $Id: .fvwm2rc.m4,v 1.50 1996/06/13 21:28:09 gjb Exp $
# Resource file for version >=2.0.42 of FVWM,
# the F? Virtual Window Manager
#
# .fvwm2rc 
# (C)1996 By Greg J. Badros <gjb@cs.duke.edu>
# You may use this file as specified under the GNU
# public license (GPL).
# I am not responsible for this file's use, misuse, or anything.
# Use at your own risk.
#
# NOTE: This must be preprocessed w/m4
# use: fvwm95 -f "FvwmM4 -debug .fvwm2rc"
#
# You may choose to grab the post-processed file, and use it
# as your permanent .fvwm2rc file. If you give the -debug option
# to FvwmM4, /tmp/fvwmrc* will have the file-- just cp it to ~/.fvwm2rc
# and you're all set.  You'll of course lose the fvwm2rc's ability to
# dynamically change options based on the machine or its configurarion
#
# Generally, I'd just let FvwmM4 parse this each time-- it's not a
# huge hit on a personal machine, since you hopefully aren't starting
# and restarting X all that much... you may want to temporarily use
# the static /tmp/fvwmrc* file while playing with configurations
# or if you're having problems.  It's always a good place to look to
# figure out problems with the settings.
#
#
# This should be run with something like:
# exec fvwm2 -f "FvwmM4 -debug .fvwm2rc.m4" -display :0 > .FVWM2-errors 2>&1
# in your .xinitrc file
#
# It is very helpful to use "tail -f .FVWM2-errors" to see what's happening,
# and what errors occured

# Get the user options.  This is the only file the casual user needs
# to worry about.
# define(`FVWM_USER_MODULE_PATH',`.')
define(`readFile', `dnl
syscmd(`test -f $HOME'/$1)dnl
ifelse(sysval,0,`sinclude(esyscmd(`echo -n $HOME')/$1)',
`sinclude(/etc/X11/TheNextLevel/$1)')')dnl

# These are defined early for .defines and .defaults
define(`IfProgramExists',`syscmd(type $1 >/dev/null 2>&1)ifelse(sysval,0,`$2',`#$1 not found')')

readFile(`.fvwm2rc.defines')

# To keep .fvwm2rc.defines clean, we define default values as necessary 
# through a separate file
readFile(`.fvwm2rc.defaults')

#****************************************************************************#
#* Beware changing anything beyond here:                                    *#
#* M4 preprocessing can be tricky.  Read the info page, the man page, and   *#
#* look at examples if you have problems                                    *#
#****************************************************************************#


##############################################################################
#
# m4 utility macro constructs
#
# Some of these came from examples distributed with m4

# divert(-1)

define(`forloop',
	`pushdef(`$1',`$2')_forloop(`$1', `$2', `$3', `$4')popdef(`$1')')
define(`_forloop',
	`$4`'ifelse($1,`$3', ,
    `define(`$1',incr($1))_forloop(`$1',`$2',`$3',`$4')')')

#eg. forloop(i,1,8,`i ') -> 1 2 3 4 5 6 7 8 

define(`foreach', `pushdef(`$1', `')_foreach(`$1', `$2', `$3')popdef(`$1')')
define(`_arg1', `$1')
define(`_foreach', 
	`ifelse(`$2', `()', ,
		`define(`$1', _arg1$2)$3`'_foreach(`$1', (shift$2), `$3')')')

#eg. foreach(x,`(first,second,third)',`Values is x ')

define(`upcase', `translit(`$*', `a-z', `A-Z')')
define(`downcase', `translit(`$*', `A-Z', `a-z')')
define(`capitalize1', `regexp(`$1', `^\(\w\)\(\w*\)', `upcase(`\1')`'downcase(`\2')')')
define(`capitalize', `patsubst(`$1', `\w+', ``'capitalize1(`\&')')')
define(`spaceto_', `translit(`$*', ` ', `_')')
define(`m4_basename',`regexp($1,`.*/\([^/]+\)',`\1')')

define(`IfProgramExistsOrError',`syscmd(type $1 >/dev/null 2>&1)ifelse(sysval,0,`$2',`$1_in_an_xterm not found')')

# A ProgramName is just the first word (delimited by whitespace) in the argument
define(`ProgramName',`regexp($1,`[^ ]+',`\&')')

define(`TraceForErrors',`syscmd(echo $1 >&2)')
# ForcedErrorForTracePurposes_$1')

ifdef(`NO_TRACE_FVWM_PARSE',
`define(`TraceForErrors',`')')

# Macro AddAmpersand for auto-picking a menu shortcut key
define(`m4_first_character',`substr(`$1',0,1)')
define(`m4_after_first_character',`substr(`$1',1)')

define(`m4_first_character_in',`index($2,upcase(m4_first_character($1)))')

#AmpersandFirstCharNotIn <title-to-insert-ampersand> <chars-to-skip>
define(`AmpersandFirstCharNotIn',`dnl
ifelse(len($1),0,`',`dnl
ifelse(m4_first_character_in($1,$2),`-1',`&$1',`m4_first_character($1)`'AmpersandFirstCharNotIn(m4_after_first_character($1),$2)')')')

define(`m4_char_after_ampersand',`upcase(regexp(`$1',`\&\(\w\)',`\1'))')

# AddAmpersand (<string>,<menu>)
define(`AddAmpersand',`ifdef($2`'_SHORTCUT_KEYS,`',`define(`$2_SHORTCUT_KEYS',`')')dnl
define(`m4_new_string',AmpersandFirstCharNotIn($1,$2`'_SHORTCUT_KEYS))dnl
define(`$2_SHORTCUT_KEYS',$2_SHORTCUT_KEYS`'m4_char_after_ampersand(m4_new_string))dnl
m4_new_string')

# ShortcutKey (<string>,<menu>)
define(`ShortcutKey',`m4_char_after_ampersand(AddAmpersand($1,$2))')

###########################################################################
#
# m4 defines for FVWM options
#
# Be careful w/ these-- m4 is case-sensitive

# FvwmAlias macro will ease the trouble-- you can use all lower case, 
# all uppercase, or *proper* mixed capitalization
# eg. StickyOnTop, stickyontop, or STICKYONTOP all work
# but StickyonTop will *not* work

define(`FvwmAlias',`
define(`$1',`$2')
define(upcase(`$1'),`$2')
define(downcase(`$1'),`$2')
')

FvwmAlias(StickyOnTop,`StaysOnTop,Sticky')
FvwmAlias(WinCircSkip,`WindowListSkip,CirculateSkip')
FvwmAlias(MinimalDecoration,`NoTitle,NoHandles,BorderWidth 1')
FvwmAlias(NoDecoration,`NoTitle,NoHandles,BorderWidth 0')
FvwmAlias(`FullMaximize',`Maximize 100 100')
FvwmAlias(`TallMaximize',`Maximize 0 ifdef(`FVWMTASKBAR',`95',`100')')

FvwmAlias(`WideMaximize',`Maximize 100 0')
FvwmAlias(`WindowListIcons',`WindowList 1 -1')

# DefineButton(ButNum,BtnOrPixmap,ActionForMouse0AnyModifiers)
define(`DefineButton',`ButtonStyle $1 'dnl
`ifelse(index($2,`full'),-1,`define(`m4_FULL')',`define(`m4_FULL',`Full')')`'dnl
ifelse(index($2,`.xpm'),-1,`$2',`$2')
ifelse($3,,`',`Mouse 0 $1 A $3')')

define(`m4_LeftButtonNumber',`1')
define(`m4_RightButtonNumber',`2')

define(`DefineLeftButton',`DefineButton(m4_LeftButtonNumber,$1,$2)
define(`m4_LeftButtonNumber',eval(m4_LeftButtonNumber+2))')

define(`DefineRightButton',`DefineButton(m4_RightButtonNumber,$1,$2)
define(`m4_RightButtonNumber',eval(m4_RightButtonNumber+2))')

define(`PctOfScreenInPixelsX',`eval( ($1 * WIDTH) / 100)')
define(`PctOfScreenInPixelsY',`eval( ($1 * HEIGHT) / 100)')

define(`PctOfScreenInPixels',`PctOfScreenInPixelsX($1) PctOfScreenInPixelsY($2)')

define(`GeometryPctOfScreen',`PctOfScreenInPixelsX($1)xPctOfScreenInPixelsY($2)')

ifelse(	eval(WIDTH > 1024),`1',
		`define(`SCREEN_SIZE',`Huge')',
	eval(WIDTH > 800), `1',
		`define(`SCREEN_SIZE',`Large')',
	eval(WIDTH > 640), `1',
		`define(`SCREEN_SIZE',`Medium')',
	`define(`SCREEN_SIZE',`Small')')

# SCREEN_SIZE gets set to Huge, Large, Moderate, or Small (capitalization matters)
#       Pixels wide      >1024  >800   >640        otherwise
#   Generally for screen  1200  1024    800           640
#       dimensions        x800  x768   x600	    x480


###########################################################################
#
# Now set internal macros based on configured parameters
#

#check for rxvt-- we'll later use it as a lightweight xterm
IfProgramExists(`rxvt',`define(`HAS_RXVT')')

ifelse(SCREEN_SIZE,`Small',
`define(`FONT_SIZE',SMALL_SCREEN_BASIC_FONT_SIZE)',
`define(`FONT_SIZE',BASIC_FONT_SIZE)')

define(`FONT_SIZE_X_2',eval(FONT_SIZE * 2))
ifdef(`USE_CLOSE_FOR_DECORATIONS',`define(`DECORATIONS_CLOSE',`Close')',dnl
`define(`DECORATIONS_CLOSE',`Delete')')

# This makes the assumption that our binary name is the basename of the directory
# in which the modules are stored
ifdef(`FVWM_BIN_NAME',`',
`define(`FVWM_BIN_NAME',m4_basename(FVWMDIR))')

# Check if Fvwm95 is sourcing this file
ifelse(FVWM_BIN_NAME,fvwm95,`define(`FVWM95')',
 FVWM_BIN_NAME,fvwm95-2,`define(`FVWM95')')

ifdef(`FVWM95',`define(HAVE_TITLE_ICONS)')

define(`BOTTOM_EDGE',`1')

ifdef(`FVWMTASKBAR',`define(`BOTTOM_EDGE',eval(BOTTOM_EDGE+28))')
 
ifdef(`HAS_RXVT',`
define(`RXVT',`rxvt')
',`
define(`RXVT',`xterm -ut')
')

#color-xterm can be color_xterm, color-xterm or non-existent (use xterm)
IfProgramExists(`color_xterm',`
define(`HAS_COLOR_XTERM')define(`COLOR_XTERM',`color_xterm')
')

IfProgramExists(`color-xterm',`
define(`HAS_COLOR_XTERM')define(`COLOR_XTERM',`color-xterm')
')

# if no color xterm, just use xterm
ifdef(`HAS_COLOR_XTERM',`',`
define(`COLOR_XTERM',`xterm')
')

define(`ICONIFY_LABEL',`Hide')
ifdef(`USE_ICONS',`define(`ICONIFY_LABEL',`Iconify')')

#StartProgramIn{ColorXterm,Xterm,Rxvt}(<prg-name-and-options>,<title>,
#                    <x-class-for-resources>
define(`StartProgramInXterm',`IfProgramExistsOrError(ProgramName($1),`xterm -T $2 -n $2 ifelse($3,,,`-name $3') -e $1')')
define(`StartProgramInColorXterm',`IfProgramExistsOrError(ProgramName($1),COLOR_XTERM `-T $2 -n $2 ifelse($3,,,`-name $3') -e $1 ')')
define(`StartProgramInRxvt',`IfProgramExistsOrError(ProgramName($1),RXVT `-T $2 -n $2 ifelse($3,,,`-name $3') -e $1 ')')

define(`StartNonInteractiveProgramInRxvt',`IfProgramExistsOrError(ProgramName($1),RXVT `-T $2\ --\ Use\ Meta-PgUp/Dn\ to\ Scroll -n $2 ifelse($3,,,`-name $3') -e sh -c "$1 && read waitforreturn"')')

define(`BUTTON_BAR_ROWS_OR_COLS',`Rows')
ifdef(`USE_VERTICAL_BUTTON_BARS',`define(`BUTTON_BAR_ROWS_OR_COLS',`Columns')')

#divert

#Thing to watch: FVWM uses $0 for the first parameter,
# m4 uses $1 for the first parameter. ($0 is the macro name)

#XTermOtherHost <Host> <Title>
#Starts an xterm running a telnet/rlogin to another host (the xterm runs locally)
AddToFunc XTermOtherHost
+ "I" exec COLOR_XTERM -name remotexterm -T $0 -n $0 -e RLOGIN_OR_TELNET $1

##############################################################################
#
# Set our all-important paths.
# Note that your "executables" path (the one your shell uses to search for
# programs it tries to exec) is set *before* fvwm starts.  Usually it is
# set by .xinitrc or .xsession, which hopefully sources some environment
# settings files like /etc/env, /etc/profile, ~/.env, ~/.profile, etc.
#
ModulePath FVWMDIR
PixmapPath USER_PIXMAP_PATH:/usr/include/X11/pixmaps/
IconPath   USER_ICON_PATH:/usr/include/X11/bitmaps/


###########################################################################
# Look at /tmp/fvwm* output to see what fvwm is defining things
# to be on your platform
#

# Need to muddle with comment characters so these lines don't get ignored by m4,
# but this needs to get passed through fvwm w/o wreaking havoc
changecom(%%%)
#FVWM-M4-Defines
#`SERVERHOST'=SERVERHOST
#`CLIENTHOST'=CLIENTHOST
#`HOSTNAME'=HOSTNAME
#`OSTYPE'=OSTYPE
#`USER'=USER
#`VERSION'=VERSION
#`REVISION'=REVISION
#`VENDOR'=VENDOR
#`RELEASE'=RELEASE
#`WIDTH'=WIDTH
#`HEIGHT'=HEIGHT
#`X_RESOLUTION'=X_RESOLUTION
#`Y_RESOLUTION'=Y_RESOLUTION
#`PLANES'=PLANES
#`CLASS'=CLASS
#`COLOR'=COLOR
#`FVWM_VERSION'=FVWM_VERSION
#`OPTIONS'=OPTIONS
#`FVWMDIR'=FVWMDIR
#
#`XRELEASE'=RELEASE
changecom(#)

###########################################################################
#
# Fonts - one for window titles, another for icons, and another for the menus
#

WindowFont	BASIC_FONT*bold-r*FONT_SIZE*
IconFont	ICON_FONT
MenuStyle	MENUFORE_COLOR MENUBACK_COLOR MENUSHADE_COLOR BASIC_FONT*medium-r*FONT_SIZE* mwm

###########################################################################
#
# Set misc. interaction preferences
#

ClickTime CLICK_MS
ifdef(`FVWM95',`',
`TitleStyle TITLE_STYLE')
ColorMapFocus COLOR_MAP_FOCUS
ifdef(`FOCUS_FOLLOWS_POINTER',`
Style "*" MouseFocus
')
DeskTopSize DESKTOP_SIZE
OpaqueMoveSize OPAQUE_MOVE_SIZE
EdgeResistance EDGE_SCROLL_RESISTANCE EDGE_MOVE_RESISTANCE
EdgeScroll 100 100

###########################################################################
#
# Set up the basic colors
#

# Set the default window colors. The syntax is:
#  DefaultColors winforecolor winbackcolor titleforecolor titlebackcolor
# where:
#  winforecolor    is used for the menu text
#  winbackcolor    is the background (border) color of all windows,
#                  including the menu windows 
#  titleforecolor  is the color of the title text of non selected windows
#  titlebackcolor  is the background color used for title bars of 
#                  non selected windows
#

# Fvwm95 and Fvwm2 handle colors pretty differently....

ifdef(`FVWM95',`
DefaultColors   MENUFORE_COLOR MENUBACK_COLOR WINFORE_COLOR WINBACK_COLOR
',`
Style "*" ForeColor WINFORE_COLOR, BackColor WINBACK_COLOR
')

#
# Text and background color for the title bar of the active (selected) window
#
ifdef(`FVWM95',`
HilightColors   HILIGHTFORE_COLOR HILIGHTBACK_COLOR
')

###########################################################################
#
# Stuff to do at start-up
#
# User initialization is done in .fvwm2rc.init, included at bottom.

##########

AddToFunc "InitFunction"
+ "I" SetupFunction
+ "I" StartupFunction
+ "I" EndSetupFunction

AddToFunc "RestartFunction"
+ "I" SetupFunction
+ "I" EndSetupFunction

###########################################################################
#
# Set the global style
#

#SloppyFocus not needed with Unclutter, and it can be dangerous 
#--you might destroy a window that still has the focus when pointing
#--at a window that doesn't take keyboard focus
#Style "*" SloppyFocus

ifdef(`MOTIF_LIKE',`Style "*" MWMFunctions, MWMDecor')

ifdef(`INTERACTIVE_PLACEMENT',
	`Style "*" HintOverride',
	`Style "*" HintOverride, SmartPlacement, RandomPlacement')
# DecoratedTransient-s is helpful to me
#Style "*" NakedTransient
Style "*" BorderWidth BORDER_WIDTH

#Gives "iconify-to-current-screen" behaviour
Style "*" StickyIcon

ifdef(`HANDLES',`Style "*" Handles, HandleWidth HANDLE_WIDTH',
`Style "*" NoHandles')

Style "*" NoIcon

# NoPPosition instructs fvwm to ignore the PPosition field in window
Style "*" NoPPosition

# But for some apps, you might want it...
foreach(APP,(APPS_FOR_USE_PPOSITION),`Style "APP" UsePPosition')

###########################################################################
# Set the decoration styles and window options for specific apps
# Order does matter... if compatible styles are set for a single window
# in multiple Style commands, then the styles are ORed together. If
# conflicting styles are set, the last one specified is used.

# These commands should command before any menus or functions are defined,
# and before the internal pager is started.

#
# Default border and handle widths
#

#Remember, options are additive-- they get "OR"-ed together
# Also note that some of these are "FvwmAlias"-es... see m4 macro
# FvwmAlias and the following lines, above.
Style "Fvwm*"		MinimalDecoration
Style "*clock"		StickyOnTop, CirculateSkip, MinimalDecoration
Style "xosview"		StickyOnTop, CirculateSkip, MinimalDecoration
Style "xbiff"		StickyOnTop, CirculateSkip, MinimalDecoration
Style "xeyes"		MinimalDecoration, CirculateSkip
Style "xload"		StickyOnTop, MinimalDecoration, CirculateSkip
Style "*ppp"		StickyOnTop, MinimalDecoration, CirculateSkip
Style "Msgs"		CirculateSkip
Style "*onsole"		CirculateSkip
Style "xman"		MinimalDecoration, CirculateSkip

#
# Some mini-icons for the title bar, menus
#

# User might not want mini-icons

define(`MiniIcon',mini-$1.xpm)
define(`RegularIcon',$1.xpm)

ifdef(`MINI_ICONS',`define(`MiniTitleIcon',
`ifelse($1,`',`',`%MiniIcon($1)%')')',
`define(MiniTitleIcon)')

#HAVE_TITLE_ICONS gets set for Fvwm95
# Hopefully fvwm2 will integrate title icons sometime soon

ifdef(`HAVE_TITLE_ICONS',`define(`SetTitleIcon',`ifelse($2,`',`',`Style "$1" TitleIcon MiniIcon($2)
')')',
`define(`SetTitleIcon')')

ifdef(`HAVE_TITLEICONS',`
Style "*"         TitleIcon "mini-x2.xpm"
Style "*xterm*"   TitleIcon "mini-term.xpm"
Style "IDL*"      TitleIcon "mini-zoom.xpm"
')

define(`SetCurrentMenu',`define(`CURRENT_ADD_TO_MENU',$1)')
SetCurrentMenu(`UndefinedLM')

define(`AddNewMenuAndButtonBar',`
ifdef(`PROVIDE_TEAROFF_BUTTON_BAR',`
*$1`'Buttons`'BUTTON_BAR_ROWS_OR_COLS 1
*$1`'ButtonsFore WINFORE_COLOR
*$1`'ButtonsBack WINBACK_COLOR
AddToMenu $1 "$1 Button Bar`'MiniTitleIcon(modules)" Module FvwmButtons $1`'Buttons
')
ifdef(`PROVIDE_TEAROFF_BIG_BUTTON_BAR',`
*$1`'BigButtons`'BUTTON_BAR_ROWS_OR_COLS 2
*$1`'BigButtonsFore WINFORE_COLOR
*$1`'BigButtonsBack WINBACK_COLOR
*$1`'BigButtonsPadding 0 0
*$1`'BigButtonsFont ifdef(`BUTTON_BARS_FONT',`BUTTON_BARS_FONT',`None')
AddToMenu $1 "$1 Big Button Bar`'MiniTitleIcon(modules)" Module FvwmButtons $1`'BigButtons
')
#At least give it a title
ifdef(`PROVIDE_TEAROFF_BIG_BUTTON_BAR',`',ifdef(`PROVIDE_TEAROFF_BUTTON_BAR',`',`
AddToMenu $1 $1 Title'))
AddToMenu $1 "" Nop
SetCurrentMenu($1)
')

# DefineProgram <menu-app-type> <program-label> <miniicon> <bigicon> <command-name>
# (only gets added if <command-name> is an executable program on the
#  current system)
# Be cautious of using quotes in command-name, or elsewhere, as single
# quote can mess up m4, and double quotes can mess up the button bar
# as they interact with the quotes around FvwmButton's Action keyword parameter
# Consider, instead, backslash-escaping all spaces in an argument.
# (See StartNonInteractiveProgramInRxvt definition, below.

changequote([[,]])
define([[Quoted]],[['$1']])
changequote(`,')

# Since we don't want the button's labels to have &'s, we need a macro
# to remove them.
define(`NoAmpersands',`translit(`$*',`&',`')')

define(`DefineProgram',`IfProgramExists(ProgramName($5),`
#FIX: not quite right
#ifelse(eval($# != 5),`0',errprint(`Not 5 args to DefineProgram for $5
#'))dnl
SetTitleIcon(patsubst($5,[ ].*$,),$3)dnl
AddToMenu $1 "$2`'MiniTitleIcon($3)" Exec $5
ifdef(`PROVIDE_TEAROFF_BUTTON_BAR',`
ifelse($3,,,*$1`'Buttons(Icon MiniIcon($3), Action Quoted(`Exec "ProgramName($5)" $5')))
')
ifdef(`PROVIDE_TEAROFF_BIG_BUTTON_BAR',`
ifelse($4,,*$1`'BigButtons(Title "NoAmpersands($2)", Action Quoted(`Exec "ProgramName($5)" $5')),
`*$1`'BigButtons(Icon RegularIcon($4), Action Quoted(`Exec "ProgramName($5)" $5'))')
')
ifdef(`USE_ICONS',`
ifelse($4,,,`Style "ProgramName($5)" Icon RegularIcon($4)')')
')')

# MenuAndButtonEntry <menu>  <label> <miniicon> <bigicon> <command-name>
#                       1        2         3       4          5
# Be cautious of using quotes in command-name, or elsewhere, as single
# quote can mess up m4, and double quotes can mess up the button bar
# as they interact with the quotes around FvwmButton's Action keyword parameter
define(`MenuAndButtonEntry',`
AddToMenu $1 "$2`'MiniTitleIcon($3)" $5
ifdef(`PROVIDE_TEAROFF_BUTTON_BAR',`
ifelse($3,,,*$1`'Buttons(Icon MiniIcon($3), Action "$5"))
')
ifdef(`PROVIDE_TEAROFF_BIG_BUTTON_BAR',`
ifelse($4,,*$1`'BigButtons(Title "NoAmpersands($2)", Action "$5"),`
*$1`'BigButtons(Icon RegularIcon($4), Action "$5")')
')')

# MenuSeparator <menu>
define(`MenuSeparator',`AddToMenu $1 "" Nop')

define(`DefineProgramLM',`DefineProgram(CURRENT_ADD_TO_MENU,$@)')
define(`MenuAndButtonEntryLM',`MenuAndButtonEntry(CURRENT_ADD_TO_MENU,$@)')
define(`MenuSeparatorLM',`MenuSeparator(CURRENT_ADD_TO_MENU,$@)')

#Note: Use SetCurrentMenu(<menu name>) to make the *LM commands use <menu name>
# as the menu to add to

###########################################################################
#
# Include all the other support files
#

# Note: .fvwm2rc.buttons, .fvwm2rc.init and .fvwm2rc.defines
# are included in the main body of this file, above.

# Title button decorations and bindings
TraceForErrors(`Including_buttons...')
readFile(`.fvwm2rc.buttons')

# Various complex functions
TraceForErrors(`Including_complex functions...')
readFile(`.fvwm2rc.functions')

# Various mouse bindings
TraceForErrors(`Including_mouse bindings...')
readFile(`.fvwm2rc.mouse')

# Various key bindings
TraceForErrors(`Including_key bindings...')
readFile(`.fvwm2rc.keys')

# Creation of the menus
TraceForErrors(`Including_menus...')
readFile(`.fvwm2rc.menus')

# Module settings
TraceForErrors(`Including_modules...')
readFile(`.fvwm2rc.modules')

# User initialization
TraceForErrors(`Including_init...')
readFile(`.fvwm2rc.init')


#divert(-1)
#undivert

###########################################################################
# Local Variables:
# rm-trailing-spaces: t
# page-delimiter: "^#####"
# End:
TraceForErrors(`Done')
