
#include <stdlib.h>


/************************************************************
*
* Function:	ELEMENT
*
* Purpose:	To return a pointer the the element with the
*		specified index.
*
* Params:	indx = element index to return pointer to
* 		base = pointer to base of array of elements to sort
* 		width = size of one element
*
* Returns:	void * = pointer to element
*
* Assumes:	Parent scope variables "base" and "width" exist.
*
************************************************************/
static void *
ELEMENT(int indx, void *base, size_t width)
{
    char *new_base = (char *)base;
    new_base += (indx * width);

    return new_base;
} /* ELEMENT */


/**********************************************************************
*
* Function:	__dg_X11_shell_sort
*
* Purpose:	To provide a function that "safely" sorts an array
*		of elements.  This routine mimics the way the C library
*		qsort() function works, but the compare function does not
*		have to be symmetric or transitive.  While the result is
*		that the data will not be sorted properly, the sort
*		routine will no go outside of the array and access invalid
*		data.
*
* Params:	base = pointer to base of array of elements to sort
*		nel = number of elements to sort
*		width = size of one element
*		compar = pointer to comparison function
*
* Returns:	none
*
* Assumes:	nothing
*
**********************************************************************/
static void
__dg_X11_shell_sort(void *base, size_t nel, size_t width, int (*compar)
           (const void *, const void *))
{
    /* Shell sort variables */
    int gap, i, j;

    /* Allocate the element swap temporary area */
    char *tmp = (char *) malloc(width);

    /* Do the shell sort */
    for (gap = nel/2; gap > 0; gap /= 2)
    {
	for (i = gap; i < nel; i++)
	{
	    for (j = i - gap; j >= 0; j-=gap)
	    {
		if ((*compar)
		    (ELEMENT(j, base, width), ELEMENT(j+gap, base, width)) <= 0)
		    break;
		else
		{
		    /* Swap the elements */
		    memcpy(tmp, ELEMENT(j, base, width), width);
		    memcpy(ELEMENT(j, base, width),
			ELEMENT(j+gap, base, width), width);
		    memcpy(ELEMENT(j+gap, base, width), tmp, width);
		}
	    } /* for */
	} /* for */
    } /* for */

    /* Free the element swap temporary area */
    free(tmp);
} /* shell_sort */
