#include <stdlib.h>
#include <stdio.h>
#include <sys/shm.h>

int main(int argc, char *argv[])
{
  int shmid;
  char *shmptr;
  int i;

  if ((shmid = shmget(IPC_PRIVATE, 1000, SHM_R | SHM_W)) < 0)
    fprintf(stderr, "shmget() failed\n");

  if ((shmptr = shmat(shmid, 0, 0)) == NULL)
    fprintf(stderr, "shmat() failed\n");

  for (i=0;i<100;i++) {
    sprintf(shmptr, "process %d: shmid %d address %lx\n", getpid(), shmid, shmptr);
    printf("%s", shmptr);

    sleep(2);
  }

  shmdt(shmptr);
  if (shmctl(shmid, IPC_RMID, 0) < 0)
    fprintf(stderr, "shmctl() failed\n");

  return 0;
}
