/* Modul %M% Release %R% Level %L% Branch %B% Sequenz %S% Created %E% %U% */

/* Copyright 1994 University of Stuttgart
 * This Graph Widget layouts (hierarchical) directed Graphs
*/

/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE UNIVERSITY OF STUTTGART OR
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.

 * Except as contained in this notice, the name of the University of
 * Stuttgart or the names of the authors shall not be used in
 * advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from the
 * University of Stuttgart and the authors.
*/
/* Author: Roland Zink
           Universitaet Stuttgart
           IPVR
           Breitwiesenstrasse 20-22
           D 70565 Stuttgart (Germany)
           EMail Roland.Zink@informatik.uni-stuttgart.de
*/

#if defined(SCCSID)
static char sccs_id[] = "%A%";
#endif

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>	/* Get standard string definations. */

#if !defined(MOTIF)
#include <X11/Xaw/Box.h>	
#include <X11/Xaw/Command.h>	
#include <X11/Xaw/Label.h>	
#include <X11/Xaw/Viewport.h>	
#include <X11/Xaw/Cardinals.h>	
#include <X11/Xaw/Paned.h>
#else
#include <Xm/Command.h>
#include <Xm/Label.h>	
#include <Xm/ScrolledW.h>	
#include <Xm/MainW.h>	
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#endif
#include "Graph.h"

#define XtNColor1   "Color1"
#define XtNColor2   "Color2"
#define XtNColor3   "Color3"
#define XtNColor4   "Color4"
#define XtNColor5   "Color5"

#define XtNColor1m   "-Color1"
#define XtNColor2m   "-Color2"
#define XtNColor3m   "-Color3"
#define XtNColor4m   "-Color4"
#define XtNColor5m   "-Color5"

typedef struct _AppResources {
    Pixel Color1;
    Pixel Color2;
    Pixel Color3;
    Pixel Color4;
    Pixel Color5;
} AppResources;

AppResources app_resources;

/*
 * The resources specification contains:
 *
 * The name and class of the resource.
 * The representation type of the resource.
 * The location in the structure to keep the value of this resource.
 * The default value for this resource.
 *
 * This information is passed into XtGetApplicationResources().
 */

static XtResource resources[] = {
    { XtNColor1, XtCBackground, XtRPixel, sizeof(Pixel),
        XtOffsetOf(AppResources, Color1), XtRString,
        XtDefaultBackground},
    { XtNColor2, XtCBackground, XtRPixel, sizeof(Pixel),
        XtOffsetOf(AppResources, Color2), XtRString,
        XtDefaultBackground},
    { XtNColor3, XtCBackground, XtRPixel, sizeof(Pixel),
        XtOffsetOf(AppResources, Color3), XtRString,
        XtDefaultBackground},
    { XtNColor4, XtCBackground, XtRPixel, sizeof(Pixel),
        XtOffsetOf(AppResources, Color4), XtRString,
        XtDefaultBackground},
    { XtNColor5, XtCBackground, XtRPixel, sizeof(Pixel),
        XtOffsetOf(AppResources, Color5), XtRString,
        XtDefaultBackground},
};


#if NeedFunctionPrototypes
static void destroyNodeCallback(Widget w, XtPointer client_data,
                                          XtPointer call_data)
#else
static void destroyNodeCallback(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
#endif
{
   XtDestroyWidget( w );
}

#if NeedFunctionPrototypes
static Widget make_widget(Widget parent,char *id,char *label)
#else
static Widget make_widget(parent,id,label)
Widget parent;
char *id;
char *label;
#endif
{ Widget w;

#if !defined(MOTIF)
  w = XtVaCreateManagedWidget(id, labelWidgetClass, parent,
                              XtNlabel, label,
                              XtNbackground, app_resources.Color2, NULL);
#else
  w = XtVaCreateManagedWidget(id, xmPushButtonWidgetClass, parent, 
                              XmNbackground, app_resources.Color2,
			      NULL, 0 );
  XtAddCallback( w, XmNactivateCallback, destroyNodeCallback, NULL );
#endif

  return w;
}

String fallback_resources[] = { 
    "Sample.width:  800",
    "Sample.height: 800",
    "*Command.Label:    Click the left mouse button here to quit",
    "*Viewport*allowVert: True",
    "*Viewport*allowHoriz: True",
    "*Viewport*forceBars: True",
    "*Graph.gravity: North",
/*    "*Graph.gravity: East", */
    "*Graph.hSpace:  20",
    "*Graph.vSpace:  20",
    "*Graph.autoConfigure: TRUE",
/*  "*Graph.borderWidth: 0", */
#ifdef COLOR_DISPLAY
    "*Color1:    LimeGreen",
    "*Color2:    Green",
    "*Color3:    Red",
    "*Color4:    Blue",
    "*Color5:    Yellow",
#else
    "*Color1:    White",
    "*Color2:    White",
    "*Color3:    Black",
    "*Color4:    White",
    "*Color5:    White",
#endif
#if !defined(MOTIF)
    "*Paned.Viewport.Graph.translations: #override \
 <Btn1Down>: select-widget() switch-managed()",
#else
   "*Viewport.Graph.translations: #override \
 <Btn1Down>: select-widget() switch-managed()",
#endif
    "*toggle.translations: #override \
 <Btn3Down>,<Btn3Up>: toggle() notify()",
    NULL,
};


static XrmOptionDescRec options[] = {
    { XtNColor1m,XtNColor1, XrmoptionSepArg, NULL},
    { XtNColor2m,XtNColor2, XrmoptionSepArg, NULL},
    { XtNColor3m,XtNColor3, XrmoptionSepArg, NULL},
    { XtNColor4m,XtNColor4, XrmoptionSepArg, NULL},
    { XtNColor5m,XtNColor5, XrmoptionSepArg, NULL},
};



/*	Function Name: Quit
 *	Description: This function prints a message to stdout.
 *	Arguments: w - ** UNUSED **
 *                 call_data - ** UNUSED **
 *                 client_data - ** UNUSED **
 *	Returns: none
 */
/* ARGSUSED */
#if NeedFunctionPrototypes
static void Quit(Widget w, XtPointer client_data, XtPointer call_data)
#else
static void Quit(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
#endif
{
    XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
    exit(0);
}

/*	Function Name: Syntax
 *	Description: Prints a the calling syntax for this function to stdout.
 *	Arguments: app_con - the application context.
 *                 call - the name of the application.
 *	Returns: none - exits tho.
 */

#if NeedFunctionPrototypes
static void Syntax(XtAppContext app_con,char * call)
#else
static void Syntax(app_con, call)
XtAppContext app_con;
char *call;
#endif
{
    XtDestroyApplicationContext(app_con);
    fprintf( stderr, "Usage: %s\n", call);
    fprintf( stderr, "\n");
    exit(1);
}

#if NeedFunctionPrototypes
static void create_sample_graph(Widget graph)
#else
static void create_sample_graph(graph)
Widget graph;
#endif
{
  Widget title;
  Widget top;
  Widget middle1;
  Widget middle2;
  Widget down;
  Widget intermediate;

  Widget graph1;
  Widget title1;
  Widget top1;
  Widget middle11;
  Widget middle12;
  Widget down1;

  Widget graph2;
  Widget title2;
  Widget top2;
  Widget middle21;
  Widget middle22;
  Widget down2;

  Widget graph3;
  Widget title3;
  Widget top3;
  Widget middle31;
  Widget middle32;
  Widget down3;

  Widget graph4;
  Widget title4;
  Widget top4;
  Widget middle41;
  Widget middle42;
  Widget down4;

  GC gc;
  XtGCMask valuemask = GCForeground | GCLineWidth ;
  XGCValues values;

  values.foreground = app_resources.Color3;
  values.line_width = 1;
  gc = XtGetGC (graph, valuemask, &values);

  XtVaSetValues(graph,XtNbackground,app_resources.Color5,NULL);
#if !defined(MOTIF)
  title = XtVaCreateManagedWidget("title", labelWidgetClass, graph,
                                  XtNlabel, "Test",
                                  XtNbackground,app_resources.Color2, NULL);
#else
  title = XtVaCreateManagedWidget("title=test", xmLabelWidgetClass, 
				  graph,
                                  XmNbackground,app_resources.Color2, 
				  NULL);
#endif
  top = make_widget(graph,"top","top");
  middle1 = make_widget(graph,"middle1","middle1");
  middle2 = make_widget(graph,"middle2","middle2");
  intermediate = make_widget(graph,"intermediate","intermediate");
  down = make_widget(graph,"down","down");

  graph1=XtVaCreateManagedWidget("graph1", graphWidgetClass, graph,
                                  XtNbackground,app_resources.Color4, NULL);
#if !defined(MOTIF)
  title1 = XtVaCreateManagedWidget("title1", labelWidgetClass, graph1,
                                  XtNlabel, "title1",
                                  XtNbackground,app_resources.Color5,NULL);
#else
  title1 = XtVaCreateManagedWidget("title = title1",xmLabelWidgetClass,
                                    graph1,
                                    XmNbackground,app_resources.Color5,
				    NULL);
#endif
  top1 = make_widget(graph1,"top1","top1");
  middle11 = make_widget(graph1,"middle11","middle11");
  middle12 = make_widget(graph1,"middle12","middle12");
  down1 = make_widget(graph1,"down1","down1");

  graph2=XtVaCreateManagedWidget("graph2", graphWidgetClass, graph,
                                  XtNbackground,app_resources.Color4, NULL);
#if !defined(MOTIF)
  title2 = XtVaCreateManagedWidget("title2", labelWidgetClass, graph2,
                                  XtNlabel, "title2",
                                  XtNbackground,app_resources.Color5,NULL);
#else
  title2 = XtVaCreateManagedWidget("title = title2", xmLabelWidgetClass,
				   graph2,
                                  XmNbackground,app_resources.Color5,
				  NULL);
#endif
  top2 = make_widget(graph2,"top2","top2");
  middle21 = make_widget(graph2,"middle21","middle21");
  middle22 = make_widget(graph2,"middle22","middle22");
  down2 = make_widget(graph2,"down2","down2");


  graph3=XtVaCreateManagedWidget("graph3", graphWidgetClass, graph,
                                  XtNbackground,app_resources.Color4, NULL);
#if !defined(MOTIF)
  title3 = XtVaCreateManagedWidget("title3", labelWidgetClass, graph3,
                                  XtNlabel, "title3",
                                  XtNbackground,app_resources.Color5,NULL);
#else
  title3 = XtVaCreateManagedWidget("title=title3", xmLabelWidgetClass, 
				   graph3,
                                   XmNbackground,app_resources.Color5,
				   NULL);
#endif
  top3 = make_widget(graph3,"top3","top3");
  middle31 = make_widget(graph3,"middle31","middle31");
  middle32 = make_widget(graph3,"middle32","middle32");
  down3 = make_widget(graph3,"down3","down3");

  graph4=XtVaCreateManagedWidget("graph4", graphWidgetClass, graph2,
                                  XtNbackground,app_resources.Color4, NULL);
#if !defined(MOTIF)
  title4 = XtVaCreateManagedWidget("title4", labelWidgetClass, graph4,
                                  XtNlabel, "title4",
                                  XtNbackground,app_resources.Color5,NULL);
#else
  title4 = XtVaCreateManagedWidget("title4", xmLabelWidgetClass, 
				   graph4,
                                   XmNbackground,app_resources.Color5,
				   NULL);
#endif
  top4 = make_widget(graph4,"top4","top4");
  middle41 = make_widget(graph4,"middle41","middle41");
  middle42 = make_widget(graph4,"middle42","middle42");
  down4 = make_widget(graph4,"down4","down4");

  GraphForceLayout(graph);

  GraphInsertEdgeGC(graph1,middle12,gc);
  GraphInsertEdgeGC(title,top4,gc);
/*  GraphInsertEdgeGC(title,title4,gc); */

  GraphInsertEdgeGC(top1,middle11,gc);
  GraphInsertEdgeGC(top1,middle12,gc);
  GraphInsertEdgeGC(middle11,down1,gc);
  GraphInsertEdgeGC(middle12,down1,gc);

  GraphInsertEdgeGC(top2,middle21,gc);
  GraphInsertEdgeGC(top2,middle22,gc);
  GraphInsertEdgeGC(middle21,down2,gc);
  GraphInsertEdgeGC(middle22,down2,gc);
  GraphInsertEdgeGC(down2,top2,gc);

  GraphInsertEdgeGC(top3,middle31,gc);
  GraphInsertEdgeGC(top3,middle32,gc);
  GraphInsertEdgeGC(middle31,down3,gc);
  GraphInsertEdgeGC(middle32,down3,gc);

  GraphInsertEdgeGC(top4,middle41,gc);
  GraphInsertEdgeGC(top4,middle42,gc);
  GraphInsertEdgeGC(middle41,down4,gc);
  GraphInsertEdgeGC(middle42,down4,gc);
  GraphInsertEdgeGC(middle41,top4,gc);
  GraphInsertEdgeGC(middle42,graph4,gc);

  GraphInsertEdge(down1,top2);
  GraphInsertEdge(down1,top3);
  GraphInsertEdge(down4,down2);

  GraphInsertEdgeGC(top,graph1,gc);
  GraphInsertEdgeGC(top,down,gc);
  GraphInsertEdgeGC(graph2,middle1,gc);
  GraphInsertEdgeGC(graph3,middle2,gc);
  GraphInsertEdge(middle1,intermediate);
  GraphInsertEdge(middle2,down);
  GraphInsertEdge(intermediate,down);
  GraphInsertEdge(down,intermediate);

  GraphForceLayout(graph);
}

#if NeedFunctionPrototypes
int main(int argc, char *argv[])
#else
int main(argc, argv)
int argc;
char **argv;
#endif
{ XtAppContext app_con;
  Widget toplevel, paned, view, graph,  command;

  toplevel = XtAppInitialize(&app_con, "Sample",
                             options, XtNumber(options),
                             &argc, argv, fallback_resources,
			     NULL, 0);

  XtGetApplicationResources( toplevel, (XtPointer) &app_resources,
                             resources, XtNumber(resources), NULL, 0);

  if (argc != 1)
      Syntax(app_con, argv[0]);

  /*
   * Actually load the application resources, and store them in the
   * structure pointed to by &app_resources.
   */

#if !defined(MOTIF)
  paned=XtCreateManagedWidget("paned",panedWidgetClass,toplevel,NULL,ZERO);

  command=XtCreateManagedWidget("command",commandWidgetClass,paned,NULL,ZERO);
  XtAddCallback(command, XtNcallback, Quit, NULL);

  view=XtCreateManagedWidget("view",viewportWidgetClass,paned,NULL,ZERO);
#else
  view=XtVaCreateManagedWidget("Viewport", xmScrolledWindowWidgetClass, 
			     toplevel, 
			     XmNscrollingPolicy, XmAUTOMATIC,
			     NULL, 0 );
#endif
  graph=XtCreateManagedWidget("graph",graphWidgetClass,view,NULL,0);
/*
  XtRealizeWidget(toplevel);
*/
  create_sample_graph(graph);
/*  XtManageChild(graph); */

  XtRealizeWidget(toplevel);

  XtAppMainLoop(app_con);
  return 0;
}



