/* Modul %M% Release %R% Level %L% Branch %B% Sequenz %S% Created %E% %U% */

/* Copyright 1994 University of Stuttgart
 * This Graph Widget layouts (hierarchical) directed Graphs
*/

/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE UNIVERSITY OF STUTTGART OR
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.

 * Except as contained in this notice, the name of the University of
 * Stuttgart or the names of the authors shall not be used in
 * advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from the
 * University of Stuttgart and the authors.
*/
/* Author: Roland Zink
           Universitaet Stuttgart
           IPVR
           Breitwiesenstrasse 20-22
           D 70565 Stuttgart (Germany)
           EMail Roland.Zink@informatik.uni-stuttgart.de
*/

typedef struct sc_queue_t { void * entry;
                            struct sc_queue_t *next; } sc_queue_t;

#if defined(__STDC__)
typedef int (*sc_queue_fkt)(void *queuedata,void *data);
#else
typedef int (*sc_queue_fkt)();
#endif

/*-------------------------------------------------------------------------
      Push one element on to the stack
--------------------------------------------------------------------------*/
#if NeedFunctionPrototypes
sc_queue_t *sc_queue_push(sc_queue_t *q,sc_queue_t *new,void *entry);
#else
sc_queue_t *sc_queue_push();
#endif
/*-------------------------------------------------------------------------
      Pop one element from the stack
--------------------------------------------------------------------------*/
#if NeedFunctionPrototypes
sc_queue_t *sc_queue_pop(sc_queue_t *q);
#else
sc_queue_t *sc_queue_pop();
#endif
/*-------------------------------------------------------------------------
      Get the element on top of the stack
--------------------------------------------------------------------------*/
#if NeedFunctionPrototypes
void *sc_queue_peek(sc_queue_t *elem);
#else
void *sc_queue_peek();
#endif
/*-------------------------------------------------------------------------
      Get nth topmost element of the stack 0=topmost
--------------------------------------------------------------------------*/
#if NeedFunctionPrototypes
void *sc_queue_nthpeek(sc_queue_t *q,int n);
#else
void *sc_queue_nthpeek();
#endif
/*-------------------------------------------------------------------------
   Suchen eines Elements: testfkt muss im Trefferfall TRUE liefern sonst FALSE
   Es wird der Pointer auf das vorherige Listenelement zurueckgeliefer
--------------------------------------------------------------------------*/
#if NeedFunctionPrototypes
sc_queue_t *sc_queue_search(sc_queue_t *q,
                            int (*testfkt)(void *queuedata,void *data),
                            void *data);
#else
sc_queue_t *sc_queue_search();
#endif
