/* Modul %M% Release %R% Level %L% Branch %B% Sequenz %S% Created %E% %U% */

/* Copyright 1994 University of Stuttgart
 * This Graph Widget layouts (hierarchical) directed Graphs
 * This Work is based on the X11R5 tree widget
*/

/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE UNIVERSITY OF STUTTGART OR
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.

 * Except as contained in this notice, the name of the University of
 * Stuttgart or the names of the authors shall not be used in
 * advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from the
 * University of Stuttgart and the authors.
*/

/*
 * $XConsortium: Tree.c,v 1.42 91/02/20 20:06:07 converse Exp $
 *
 * Copyright 1990 Massachusetts Institute of Technology
 * Copyright 1989 Prentice Hall
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 * 
 * M.I.T., Prentice Hall and the authors disclaim all warranties with regard
 * to this software, including all implied warranties of merchantability and
 * fitness.  In no event shall M.I.T., Prentice Hall or the authors be liable
 * for any special, indirect or cosequential damages or any damages whatsoever
 * resulting from loss of use, data or profits, whether in an action of
 * contract, negligence or other tortious action, arising out of or in
 * connection with the use or performance of this software.
 * 
 * Authors:  Jim Fulton, MIT X Consortium,
 *           based on a version by Douglas Young, Prentice Hall
 * 
 * This widget is based on the Tree widget described on pages 397-419 of
 * Douglas Young's book "The X Window System, Programming and Applications 
 * with Xt OSF/Motif Edition."  The layout code has been rewritten to use
 * additional blank space to make the structure of the graph easier to see
 * as well as to support vertical trees.
 */

/* Author: Roland Zink
           Universitaet Stuttgart
           IPVR
           Breitwiesenstrasse 20-22
           D 70565 Stuttgart (Germany)
           EMail Roland.Zink@informatik.uni-stuttgart.de
*/

#if defined(SCCSID)
static char sccs_id[] = "%A%";
#endif

#include <math.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <X11/CompositeP.h>
#include <X11/ConstrainP.h>

#include "GraphP.h"
#include "Graph_layout.h"
#include "Graph_draw.h"


#define DownEdge 0
#define UpEdge   1

#define NoArrow   0
#define DownArrow 1
#define UpArrow   2



/*------------------------------------------------------------------------
            Find the Widget up in the tree which is managed 
            and all widgets from this to graph are also managed
--------------------------------------------------------------------------*/
#if NeedFunctionPrototypes
static Widget FindManagedWidgetUp(Widget w,Widget graph)
#else
static Widget FindManagedWidgetUp(w,graph)
Widget w;
Widget graph;
#endif
{ Widget unmanaged1;
  Widget unmanaged2;

  unmanaged2=w;
  unmanaged1=w;
  while( unmanaged1!=graph )
       { unmanaged2=unmanaged1;
         unmanaged1=XtParent(unmanaged1);
         while( XtIsManaged(unmanaged1) && (unmanaged1!=graph) )
              { unmanaged1=XtParent(unmanaged1); }
       }

  if( XtIsManaged(unmanaged2) || (unmanaged2==graph) )
    { return unmanaged2; }
  else
    { return XtParent(unmanaged2); }

/*
  if( !XtIsManaged(w) )
    { w=XtParent(w);
      while( !XtIsManaged(w) && (w!=graph) )
           { w=XtParent(w); }
    }
*/
}



#if NeedFunctionPrototypes
static XPoint get_coord(GraphWidget gw, Widget w)
#else
static XPoint get_coord(gw,w)
GraphWidget gw;
Widget w;
#endif
{ XPoint coord;

  coord.x = 0;
  coord.y = 0;

  for( ; w!=(Widget)gw; w=XtParent(w) )
    { coord.x += w->core.x;
      coord.y += w->core.y;
    }
  return coord;
}


#if NeedFunctionPrototypes
static XPoint get_center(Widget x,XPoint offset)
#else
static XPoint get_center(x,offset)
Widget x;
XPoint offset;
#endif
{ offset.x += x->core.border_width + x->core.width/2;
  offset.y += x->core.border_width + x->core.height/2;

  return offset;
}

#if NeedFunctionPrototypes
static XPoint get_boundary_offset(Widget x,XPoint cpx,XPoint cpy)
#else
static XPoint get_boundary_offset(x,cpx,cpy)
Widget x;
XPoint cpx;
XPoint cpy;
#endif
{ double angle;
  double rangle;
  XPoint bp;

  if( cpy.y == cpx.y )
    { bp.x = x->core.width/2 + x->core.border_width;
      bp.y = 0;
      return bp;
    }
  if( cpy.x == cpx.x )
    { bp.x = 0;
      bp.y = x->core.height/2 + x->core.border_width;
      return bp;
    }

  angle = ((double)(cpy.x - cpx.x))/((double)(cpy.y - cpx.y));
  if( x->core.height == 0 )
    { rangle = 1000000; }
  else
    { rangle = ((double)(x->core.width))/((double)(x->core.height)); }

  if( fabs(angle) < rangle )
    { bp.x = (short)(angle*(x->core.height/2 + x->core.border_width));
      bp.y = x->core.height/2 + x->core.border_width;
    }
  else
    { angle = ((double)(cpy.y - cpx.y))/((double)(cpy.x - cpx.x));
      bp.x = x->core.width/2 + x->core.border_width;
      bp.y = (short)(angle*(x->core.width/2 + x->core.border_width));
    }

  return bp;
}

#if NeedFunctionPrototypes
static XPoint get_boundary_point(Widget x,XPoint cpx,XPoint cpy)
#else
static XPoint get_boundary_point(x,cpx,cpy)
Widget x;
XPoint cpx;
XPoint cpy;
#endif
{ XPoint offset;
  XPoint temp;

  if( cpx.y > cpy.y )
    { if( cpx.x <= cpy.x )
        { temp.x = cpy.x;
          temp.y = cpx.x;
          cpx.x = cpy.x - cpx.x;
          cpy.x = 0;
          offset = get_boundary_offset(x,cpy,cpx);
          offset.y = -offset.y;
          cpy.x = temp.x;
          cpx.x = -cpx.x + cpy.x;
        }
      else
        { offset = get_boundary_offset(x,cpy,cpx);
          offset.y = -offset.y;
          offset.x = -offset.x;
        }
    }
  else
    { if( cpx.x > cpy.x )
        { temp.x = cpx.x;
          temp.y = cpy.x;
          cpy.x = cpx.x - cpy.x;
          cpx.x = 0;
          offset = get_boundary_offset(x,cpx,cpy);
          offset.x = -offset.x;
          cpx.x = temp.x;
          cpy.x = -cpy.x +cpx.x;
        }
      else
        { offset = get_boundary_offset(x,cpx,cpy);
        }
    }
  offset.x += cpx.x;
  offset.y += cpx.y;

  return offset;
}

#if NeedFunctionPrototypes
static XSegment get_line(GraphWidget gw, Widget x, Widget y)
#else
static XSegment get_line(gw,x,y)
GraphWidget gw;
Widget x;
Widget y;
#endif
{ XSegment s;
  XPoint   cpx;
  XPoint   cpy;
  XPoint   bpx;
  XPoint   bpy;

  /* get coordinates relative to graph gw */
  if( (Widget)gw == x )
    { switch( gw->graph.gravity )
           { case SouthGravity: cpx.x = x->core.width/2 + x->core.border_width;
                                cpx.y = x->core.border_width+x->core.height;
                                break;
             case NorthGravity: cpx.x = x->core.width/2 + x->core.border_width;
                                cpx.y = x->core.border_width;
                                break;
             case WestGravity:  cpx.x = x->core.border_width;
                                cpx.y = x->core.height/2+ x->core.border_width;
                                break;
             case EastGravity:  cpx.x = x->core.width + x->core.border_width;
                                cpx.y = x->core.height/2+ x->core.border_width;
                                break;
	   }
    }
  else
    { cpx = get_center(x,get_coord(gw,x)); }
  if( (Widget)gw == y )
    { switch( gw->graph.gravity )
           { case SouthGravity: cpy.x = cpx.x;
                                cpy.y = y->core.border_width;
                                break;
             case NorthGravity: cpy.x = cpx.x;
                                cpy.y = y->core.height + y->core.border_width;
                                break;
             case WestGravity:  cpy.x = y->core.width + y->core.border_width;
                                cpy.y = cpx.y;
                                break;
             case EastGravity:  cpy.x = y->core.border_width;
                                cpy.y = cpx.y;
                                break;
	   }
    }
  else
    { cpy = get_center(y,get_coord(gw,y)); }

  if( (Widget)gw == x )
    { bpx = cpx; }
  else
    { bpx = get_boundary_point(x,cpx,cpy); }
  if( (Widget)gw == y )
    { bpy = cpy; }
  else
    { bpy = get_boundary_point(y,cpy,cpx); }

  s.x1 = bpx.x;
  s.y1 = bpx.y;
  s.x2 = bpy.x;
  s.y2 = bpy.y;

  return s;
}


#if NeedFunctionPrototypes
static XSegment lineToLocal(Widget gw,Widget w,XSegment s)
#else
static XSegment lineToLocal(gw,w,s)
Widget gw;
Widget w;
XSegment s;
#endif
{ if( w==gw )
    { return s; }
  else
    { s = lineToLocal(gw,XtParent(w),s);
      s.x1 -= w->core.x + w->core.border_width;
      s.y1 -= w->core.y + w->core.border_width;
      s.x2 -= w->core.x + w->core.border_width;
      s.y2 -= w->core.y + w->core.border_width;
      return s;
    }
}

#if NeedFunctionPrototypes
static XSegment DrawEdgeSegment(Widget gw,Widget w,XSegment s,GC gc)
#else
static XSegment DrawEdgeSegment(gw,w,s,gc)
Widget gw;
Widget w;
XSegment s;
GC gc;
#endif
{ Window window;

  if( (w==gw) || (XtParent(w) == gw) )
    { window = XtWindow(gw);
      if( window )
        { XDrawLine(XtDisplay(gw), window,
                gc, s.x1, s.y1, s.x2, s.y2 );
        }
      s.x1 -= w->core.x + w->core.border_width;
      s.y1 -= w->core.y + w->core.border_width;
      s.x2 -= w->core.x + w->core.border_width;
      s.y2 -= w->core.y + w->core.border_width;
      return s;
    }
  else
    { s = DrawEdgeSegment(gw,XtParent(w),s,gc);
      window = XtWindow(XtParent(w));
      if( window )
        { XDrawLine(XtDisplay(XtParent(w)), window,
                    gc, s.x1, s.y1, s.x2, s.y2 );
        }
      s.x1 -= w->core.x + w->core.border_width;
      s.y1 -= w->core.y + w->core.border_width;
      s.x2 -= w->core.x + w->core.border_width;
      s.y2 -= w->core.y + w->core.border_width;
      return s;
    }
}

#if NeedFunctionPrototypes
static void DrawArrowToEdge(Widget graph,Widget w,XSegment line,GC gc)
#else
static void DrawArrowToEdge(graph,w,line,gc)
Widget graph;
Widget w;
XSegment line;
GC gc;
#endif
{ XPoint p3; XPoint points[3]; double diffx, diffy, length;
  Window window;

  if( w != graph )
    { w = XtParent(w); }

  window = XtWindow(w);
  line = lineToLocal(graph,w,line);

  if( !window ) return;


  diffx = line.x2 - line.x1;
  diffy = line.y2 - line.y1;
  length = sqrt(diffx*diffx + diffy*diffy);

  p3.x = line.x2 - diffx*10/length;
  p3.y = line.y2 - diffy*10/length;

  points[0].x = line.x2;
  points[0].y = line.y2;
  points[1].x = p3.x + (diffy*5)/length;
  points[1].y = p3.y - (diffx*5)/length;
  points[2].x = p3.x - (diffy*5)/length;
  points[2].y = p3.y + (diffx*5)/length;
  XFillPolygon(XtDisplay(w), window,
               gc, points, 3, Convex, CoordModeOrigin );
}

/*
static void DrawEdge(LayoutData_t *graph,Vertice_t *v1,Vertice_t *v2,int arrows,GC gc)
{ XPoint start;
  XPoint end;
  XPoint scoord;
  XPoint ecoord;
  Boolean upedge;
  XSegment s;
  Widget from;
  Widget to;

  if( !IsDummyNode(v1) )
    { from = FindManagedWidgetUp(v1->w,(Widget)graph->w); }
  else
    { from = v1->w; }
  if( !IsDummyNode(v2) )
    { to = FindManagedWidgetUp(v2->w,(Widget)graph->w); }
  else
    { to = v2->w; }

  upedge = False;

  if( ((Widget)graph->w != from) && !upedge )
    { start = get_start_point(graph->w,from);
      scoord = get_start_coord(graph->w,from);
    }
  else
    { start = get_end_point(graph->w,from);
      scoord = get_end_coord(graph->w,from);
    }

  if( ((Widget)graph->w != to) && !upedge )
    { end = get_end_point(graph->w,to);
      ecoord = get_end_coord(graph->w,to);
    }
   else
    { end = get_start_point(graph->w,to);
      ecoord = get_start_coord(graph->w,to);
    }

  if( (Widget)graph->w != from )
    { s.x1 = scoord.x;
      s.y1 = scoord.y;
      s.x2 = end.x;
      s.y2 = end.y;
      DrawEdgeSegment((Widget)graph->w,from,s,gc);
    }

  if( (Widget)graph->w != to )
    { s.x1 = ecoord.x;
      s.y1 = ecoord.y;
      s.x2 = start.x;
      s.y2 = start.y;
      DrawEdgeSegment((Widget)graph->w,to,s,gc);
    }

  if( arrows & DownArrow )
    { scoord.x = start.x - (end.x - ecoord.x);
      scoord.y = start.y - (end.y - ecoord.y);
      DrawArrowToEdge(to,scoord,ecoord,gc);
    }
  if( arrows & UpArrow )
    { ecoord.x = end.x - (start.x - scoord.x);
      ecoord.y = end.y - (start.y - scoord.y);
      DrawArrowToEdge(from,ecoord,scoord,gc);
    }
}
*/

#if NeedFunctionPrototypes
static void DrawEdge(LayoutData_t *graph,Vertice_t *v1,Vertice_t *v2,
                     int arrows,GC gc)
#else
static void DrawEdge(graph,v1,v2,arrows,gc)
LayoutData_t *graph;
Vertice_t *v1;
Vertice_t *v2;
int arrows;
GC gc;
#endif
{ XSegment s;
  Widget from;
  Widget to;
  XSegment reverseLine;

  if( !IsDummyNode(v1) )
    { from = FindManagedWidgetUp(v1->w,(Widget)graph->w); }
  else
    { from = v1->w; }
  if( !IsDummyNode(v2) )
    { to = FindManagedWidgetUp(v2->w,(Widget)graph->w); }
  else
    { to = v2->w; }

  s = get_line(graph->w,from,to);

  if( (Widget)graph->w != from )
    { DrawEdgeSegment((Widget)graph->w,from,s,gc); }

  if( (Widget)graph->w != to )
    { DrawEdgeSegment((Widget)graph->w,to,s,gc); }

  if( arrows & DownArrow )
    { DrawArrowToEdge((Widget)graph->w,to,s,gc); }
  if( arrows & UpArrow )
    { reverseLine.x1 = s.x2;
      reverseLine.y1 = s.y2;
      reverseLine.x2 = s.x1;
      reverseLine.y2 = s.y1;
      DrawArrowToEdge((Widget)graph->w,from,reverseLine,gc);
    }
}

#if NeedFunctionPrototypes
static void DrawLayoutEdge(LayoutData_t *graph,LayoutEdge_t *edge,GC gc)
#else
static void DrawLayoutEdge(graph,edge,gc)
LayoutData_t *graph;
LayoutEdge_t *edge;
GC gc;
#endif
{
/*
  XPoint start;
  XPoint end; 
*/
  XSegment s;
  Window window;

/*
  start = get_start_point(graph->w,edge->edge.from->w);
  end = get_end_point(graph->w,edge->edge.to->w);
*/
  s = get_line(graph->w,edge->edge.from->w,edge->edge.to->w);

  window = XtWindow(graph->w);
  if( window )
    { 
/*
      XDrawLine(XtDisplay(graph->w), XtWindow(graph->w),gc,
                start.x, start.y, end.x, end.y );
*/
      XDrawLine(XtDisplay(graph->w), XtWindow(graph->w),gc,
                s.x1, s.y1, s.x2, s.y2 );
    }
}

#if NeedFunctionPrototypes
static void DrawRealEdgesFrom(LayoutData_t *graph,VirtualEdge_t *edge,Vertice_t *to,Boolean upedge)
#else
static void DrawRealEdgesFrom(graph,edge,to,upedge)
LayoutData_t *graph;
VirtualEdge_t *edge;
Vertice_t *to;
Boolean upedge;
#endif
{ int i;
  GC gc;

  for( i=0; i<edge->reals.n_edges; i++ )
    { if( edge->reals.edges[i]->gc )
        { gc = edge->reals.edges[i]->gc; }
      else
        { gc = graph->w->graph.gc; }
      if( upedge ^ edge->reals.edges[i]->direction )
        { DrawEdge(graph,edge->reals.edges[i]->edge.to,to,UpArrow,gc); }
      else
        { DrawEdge(graph,edge->reals.edges[i]->edge.from,to,NoArrow,gc); }
    }
}

#if NeedFunctionPrototypes
static void DrawRealEdgesTo(LayoutData_t *graph,VirtualEdge_t *edge,
                            Vertice_t *to,Boolean upedge)
#else
static void DrawRealEdgesTo(graph,edge,to,upedge)
LayoutData_t *graph;
VirtualEdge_t *edge;
Vertice_t *to;
Boolean upedge;
#endif
{ int i;
  GC gc;

  for( i=0; i<edge->reals.n_edges; i++ )
    { if( edge->reals.edges[i]->gc )
        { gc = edge->reals.edges[i]->gc; }
      else
        { gc = graph->w->graph.gc; }
      if( upedge ^ edge->reals.edges[i]->direction)
        { DrawEdge(graph,to,edge->reals.edges[i]->edge.from,NoArrow,gc); }
      else
        { DrawEdge(graph,to,edge->reals.edges[i]->edge.to,DownArrow,gc); }
    }
}

#if NeedFunctionPrototypes
static void DrawRealEdges(LayoutData_t *graph,VirtualEdge_t *edge,
                          Boolean upedge)
#else
static void DrawRealEdges(graph,edge,upedge)
LayoutData_t *graph;
VirtualEdge_t *edge;
Boolean upedge;
#endif
{ int i;
  GC gc;

  for( i=0; i<edge->reals.n_edges; i++ )
    { if( edge->reals.edges[i]->gc )
        { gc = edge->reals.edges[i]->gc; }
      else
        { gc = graph->w->graph.gc; }
      if( upedge ^ edge->reals.edges[i]->direction )
        { DrawEdge(graph,edge->reals.edges[i]->edge.to,
                   edge->reals.edges[i]->edge.from,UpArrow,gc);
        }
      else
        { DrawEdge(graph,edge->reals.edges[i]->edge.from,edge->reals.
                   edges[i]->edge.to,DownArrow,gc);
        }
    }
}


#if NeedFunctionPrototypes
void DrawVirtualEdge(LayoutData_t *graph,VirtualEdge_t *edge)
#else
void DrawVirtualEdge(graph,edge)
LayoutData_t *graph;
VirtualEdge_t *edge;
#endif
{ int i;
  Boolean direction;
  GC gc;

  if( edge->layouts.n_edges > 1 )
    { if( edge->layouts.n_edges>2 )
        { if( edge->reals.edges[0]->gc )
            { gc = edge->reals.edges[0]->gc; }
          else
            { gc = gc = graph->w->graph.gc; }
          for( i=1; i<edge->layouts.n_edges-1; i++ )
             { DrawLayoutEdge(graph,edge->layouts.edges[i],gc); }
        }

      if( edge->layouts.edges[0]->edge.from == edge->edge.from )
        { direction = DownEdge; }
      else
        { direction = UpEdge; }

      DrawRealEdgesFrom(graph,edge,edge->layouts.edges[0]->edge.to,direction);
      DrawRealEdgesTo(graph,edge,
                      edge->layouts.edges[edge->layouts.n_edges-1]->edge.from,
                      direction);
    }
  else if( edge->layouts.n_edges > 0 )
    { if( edge->layouts.edges[0]->edge.from == edge->edge.from )
        { DrawRealEdges(graph,edge,DownEdge); }
      else
        { DrawRealEdges(graph,edge,UpEdge); }
    }
}
