.\" Copyright 1994 University of Stuttgart
.\" This Graph Widget layouts (hierarchical) directed Graphs
.\"
.\" Permission is hereby granted, free of charge, to any person
.\" obtaining a copy of this software and associated documentation
.\" files (the "Software"), to deal in the Software without
.\" restriction, including without limitation the rights to use, copy,
.\" modify, merge, publish, distribute, sublicense, and/or sell copies
.\" of the Software, and to permit persons to whom the Software is
.\" furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NONINFRINGEMENT.  IN NO EVENT SHALL THE UNIVERSITY OF STUTTGART OR
.\" THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
.\" OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the University of
.\" Stuttgart or the names of the authors shall not be used in
.\" advertising or otherwise to promote the sale, use or other dealings
.\" in this Software without prior written authorization from the
.\" University of Stuttgart and the authors.
.\"
.\" Author: Roland Zink
.\"           Universitaet Stuttgart
.\"           IPVR
.\"           Breitwiesenstrasse 20-22
.\"           D 70565 Stuttgart (Germany)
.\"           EMail Roland.Zink@informatik.uni-stuttgart.de
.\" 
.\" 
.\" Copyright (c) 1993, 1994  X Consortium
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"), 
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense, 
.\" and/or sell copies of the Software, and to permit persons to whom the 
.\" Software furnished to do so, subject to the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
.\" SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the X Consortium shall not 
.\" be used in advertising or otherwise to promote the sale, use or other 
.\" dealing in this Software without prior written authorization from the 
.\" X Consortium.
.ds tk X Toolkit
.ds aw Athena Widgets
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtApp-Create-Shell XtVa-App-Create-Shell wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH xhdg 3 "Release 6" "X Version 11" "Graph Widget"
.SH NAME
xhdg \- a widget for layout of hierarchical directed graphs
.SH SYNTAX
void GraphInsertEdge(Widget \fIfrom\fP, Widget \fIto\fP);
.LP
void GraphDeleteEdge(Widget \fIfrom\fP, Widget \fIto\fP);
.LP
void GraphSetEdgeGC(Widget \fIfrom\fP, Widget \fIto\fP, GC \fIgc\fP);
.LP
void GraphInsertEdgeGC(Widget \fIfrom\fP, Widget \fIto\fP, GC \fIgc\fP);
.LP
void GraphExplode(Widget \fIgraph\fP);
.LP
void GraphImplode(Widget \fIgraph\fP);
.LP
Widget GraphActiveWidget(Widget \fIgraph\fP);
.LP
.SH ARGUMENTS
.IP \fIfrom\fP 1i
Specifies the widget from which a edge departs
.IP \fIto\fP 1i
Specifies the widget to which a edge arrives
.IP \fIgc\fP 1i
Specifies the graphics context which is used for drawing the edge
.IP \fIgraph\fP 1i
Specifies the graph for which the action is to be executed
.SH DESCRIPTION
The xhdg graph widget layouts automatically all it's child
widgets. The first widget is treated as a title for the graph. This
widget is centered in the top line of the graph widget. Any other
widget is positioned according to the edges of the graph.
.LP
The layout algorithm works as follows. First the graph is partitioned
in levels. Widgets without incoming edges are positioned on the first
level. Widgets with only incoming edges from the first level on the
second and so on for the other levels. If there are cycles in the
graph which make this level ordering impossible, one edge in the cycle
is chosen and temporary inverted, thus breaking the cycle. If there
are edges from different levels to a widget, then for each edge
crossing levels dummy widgets will be inserted. This has the effect,
that no edge is crossing levels. Then the widgets on a level are
permutated in order to minimize the number of edge crossings. Because
this problem is NP-hard the algorithm uses a heuristic solution. Then
the widgets in a level are positioned evenly distributed through the
full width of the graph widget. Finally the layout of the widgets are
fine tuned by moving widgets with only one predecessor and one
successor between the two.  This algorithm is a modified version of
the algorithm of Sugiyama et al [Sug81].
.LP
You can build supernodes by inserting a graph widget into another
graph widget. Such supernodes, like all graph widgets, can be closed
and reopened. Close mean hide all subnodes and reopen mean display the
subnodes again. Edges can cross supernode boundaries. The layout
algorithm uses virtual edges corresponding to these edges, but
restricted to a graph widget, to layout the supernodes in the
graph. If a supernode is closed, all edges to or from it's subnodes
are redirected to the supernode. In this case the supernode represents
all it's subnodes.
.LP
The xhdg graph widget is a subclass from the \fI\*(tk\fP
\fIconstrained widget class\fP. Therefore it should work not only with
the \fI\*(aw\fP but also with all toolkits which uses the \fI\*(tk\fP
for example \fIMotif\fP. The graph widget knows nothing about additional
\fIMotif\fP functionality like tab groups and so on.
.SH FUNCTIONS
The
.ZN GraphInsertEdge
function inserts a directed edge between the widget from and the
widget to. It's possible to insert additional the reverse edge with
another call to this function. In this case the edge is displayed with
two arrows.

The
.ZN GraphDeleteEdge
function deletes a previous inserted directed edge between the widgets
from and to.

The
.ZN GraphSetEdgeGC
function sets the graphics context of the specified edge. The edge
will be redrawn with this new graphics context.

The
.ZN GraphInsertEdgeGC
functions inserts a directed edge between the widget from and the
widget to. The edge will be displayed with the graphics context gc. If
the reverse edge is also inserted then these two edge should have the
same graphics context. Otherwise the result will be surprising.

The
.ZN GraphExplode
function opens a graph widget. This means all subwidgets are
displayed. For all subwidgets XtManageChild will be called in order to
do this.

The
.ZN GraphImplode
function close a graph widget. This means only the title widget is
displayed. For all subwidgets with exception of the first
XtUnmanageChild will be called in order to do this.

The
.ZN GraphActiveWidget
function returns the most recently selected subwidget of the graph widget.

.SH ACTIONS

The
.ZN select-widget
action marks the widget currently under the mouse cursor as active.

The
.ZN switch-managed
action switch between the closed and opened state of the active graph
widget.

.SH RESOURCES

The
.ZN hSpace
resource determines the minimum horizontal place between two widgets.

The
.ZN vSpace
resource determines the minimum vertical place between two widgets.

The
.ZN gravity
resource determines the direction of the graph drawing. If the gravity
is \fINorth\fP then the graph is drawn from top to bottom. A gravity
of \fISouth\fP indicates the reverse direction. A gravity of
\fIWest\fP is for left to right drawing and a gravity of \fIEast\fP
for the reverse drawing.

.SH KNOWN BUGS
The GraphDeleteEdge function isn't tested yet. There should support
for undirected graphs and for more layout algoritms. For example the
force directed placement of Fruchterman and Reingold [FR91].

.SH EXAMPLE

The Graph_test program in the test directory builds and displays an
example graph. You can open and close the supernodes with the left
mouse button. The Motif version allows to delete nodes.

.SH SEE ALSO
.br
\fI\*(xW\fP
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP

.SH REFERENCES

[Sug81] Kozo Sugiyama, Shojiro Tagawa and Mitsuhiko Toda, "Methods for
Visual Understanding of Hierarchical System Structures", IEEE
Transactions on Systems, Man, and Cybernetics, Vol. SMC-11, No. 2,
February 1981, pp 109 - 125.

[FR91] Thomas M. J. Fruchterman and Edward M. Reingold, "Graph drawing
by Force-directed Placement", Software - Practice and Experience, Vol
21, Nr. 11, November 91, pp 1129 - 1164.
