/************************************************************************/
/* 									*/
/* FileSelect.h:   Definition of the FileSelect class			*/
/*		   This is the file handling of this application	*/
/*		   Roland Krause 1998					*/
/*									*/
/************************************************************************/

#ifndef FILESELECT_H
#define FILESELECT_H

// --- Include ----------------------------------------------------------

#include "HandleTar.h"		// Used to work with tar
#include "FileFunc.h"		// The class FileSelect is derived from


// --- Class definition -------------------------------------------------

class FileSelect : public FileFunc
{
  protected:

	// Some widgets of the window

	Widget	dialogueShell,		// The shell for this dialogue window
		tarListWidget,		// List widget of the root window
		selectFile,		// A text widget with the file name in it
		fileList,		// An icon list widget for the file list
		archNameWidget,		// Label widget for the archive name
		ok, cancel;		// The buttons

  public:

	HandleTar *tar;			// My object to work with tar

	// Methods of this class

	FileSelect(Widget shell);	// The constructor
					// Do some initializations when the widget
					// tree is realized
	void PostInit(Widget shell,Widget FList, Widget FNameLabel);
					// Set the given filename in the text widget
	~FileSelect(void);		// The destructor of this class

	// Handling of the file selector

	inline void SetFileName(char *FName);
	char *GetCurrFileName(void);	// Read the current file name
					// Change the file list
	inline void ChangeList(XawIconList *FileList);
	inline void PopDown(void);	// To popdown the file selection dialogue
	void PopUp(int xPos, int yPos);	// To pop up the file selection dialogue
	inline void Warning(void);	// Gives a warning signal

	// Handling of the tar object
					// Change the tar list in the main window
	void ChangeTarList(char *list, HandleTar *tarObj);
	inline void UpdateTarList(char *list);		// Update the tar list
	inline void FinishTarList(void);		// Finish the tar list
	char *GetFileFromArchive(char *listEntry);	// Get a file from the tar archive
};

#endif

