
/******************************************************************************************
 *
 * XawConvertStringToPixmap(), XawConvertStringToClipMask():
 *
 * Creates a depth-n Pixmap and its clip mask suitable for icons.
 * "string" represents a pixmap filename which may be absolute,
 * or relative to the global resource pixmapFilePath, class
 * PixmapFilePath.  If the resource is not defined, the default
 * value is the build symbol PIXMAPDIR.
 *
 * To use, include the following in your ClassInitialize procedure:
 *
 * static XtConvertArgRec screenConvertArg[] = {
 *  {XtWidgetBaseOffset, (XtPointer)XtOffsetOf(Widget, core.screen), sizeof(Screen *)},
 *  {XtWidgetBaseOffset, (XtPointer)XtOffsetOf(Widget, core.colormap), sizeof(Colormap)},
 * };
 *
 * XtAddConverter(XtRString, XtRPixmap, XawCvtStringToPixmap,
 *      screenConvertArg, XtNumber(screenConvertArg));
 *
 * Please don't use the new style installer XtSetTypeConverter()!
 * I used the old converter interface to avoid problems with editres.
 * Editres seems not to work correctly with new style converters.
 *
 *
 * Author: Roland Krause
 * EMail:  rokrause@aol.com
 *
 ******************************************************************************************/

#ifndef _StrToPmap_h
#define _StrToPmap_h

void XawCvtStringToPixmap(
#if NeedFunctionPrototypes
	XrmValuePtr,		/* Argument list for the converter	*/
	Cardinal *,		/* Number of arguments in the list	*/
	XrmValuePtr,		/* Resource to convert			*/
	XrmValuePtr		/* Conversion result			*/
#endif
);

void XawCvtStringToClipMask(
#if NeedFunctionPrototypes
	XrmValuePtr,		/* Argument list for the converter	*/
	Cardinal *,		/* Number of arguments in the list	*/
	XrmValuePtr,		/* Resource to convert			*/
	XrmValuePtr		/* Conversion result			*/
#endif
);

#endif

