/************************************************************************/
/* 									*/
/* ExtrDialog.h: Definition of the extract dialog class			*/
/*		 This is a dialog to start the file extraction		*/
/*		 Roland Krause 1998, 1999				*/
/*									*/
/************************************************************************/

#ifndef EXTRDIALOG_H
#define EXTRDIALOG_H

// --- Include ----------------------------------------------------------

#include <X11/Intrinsic.h>		// Header of Xt

#include "HandleTar.h"			// Handles the interface to tar


// --- Class definition -------------------------------------------------

class ExtrDialog
{
  private:
	// Some Callbacks of this dialog

	friend void CloseWin(Widget w, XtPointer clientData, XtPointer callData);
	friend void ExtrFile(Widget w, XtPointer clientData, XtPointer callData);

  protected:

	Widget		 dialogShell,	// The shell for this window
			 pathName;	// For the path to extract to
	char		 *FileList;	// List of files to extract
	class HandleTar  *tarObj;	// Interface to tar

  public:

	ExtrDialog(Widget rootShell);	// The constructor
	void PopUp(int x, int y, char *path, char *flist, class HandleTar *tar);
	Boolean Extract(void);		// Extract files from archive
};

#endif
