.\"  ghostview.man -- Man page for ghostview application
.\"  Copyright (C) 1992  Timothy O. Theisen
.\" 
.\"  This program is free software; you can redistribute it and/or modify
.\"  it under the terms of the GNU General Public License as published by
.\"  the Free Software Foundation; either version 2 of the License, or
.\"  (at your option) any later version.
.\" 
.\"  This program is distributed in the hope that it will be useful,
.\"  but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"  GNU General Public License for more details.
.\" 
.\"  You should have received a copy of the GNU General Public License
.\"  along with this program; if not, write to the Free Software
.\"  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\"    Author: Tim Theisen           Systems Programmer
.\"  Internet: tim@cs.wisc.edu       Department of Computer Sciences
.\"      UUCP: uwvax!tim             University of Wisconsin-Madison
.\"     Phone: (608)262-0438         1210 West Dayton Street
.\"       FAX: (608)262-9777         Madison, WI   53706
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH GHOSTVIEW 1 "XawPlus 2.1" "X Version 11"
.SH NAME
\fIghostview\fR \- View PostScript documents using ghostscript
.SH SYNOPSIS
.B ghostview
[filename]
.br
or
.br
.B ghostview
[\-monochrome] [\-grayscale] [\-color]
[\-[no]title] [\-[no]date] [\-[no]locator] [\-[no]labels]
[\-resolution\ \fIdpi\fP] [\-dpi\ \fIdpi\fP]
[\-xdpi\ \fIdpi\fP] [\-ydpi\ \fIdpi\fP] [\-magstep\ \fIn\fP]
[\-[no]safer] [\-[no]quiet] [\-arguments\ \fIarguments\fP]
[\-[no]center]
[\-portrait] [\-landscape] [\-upsidedown] [\-seascape] [\-[no]swap]
[\-letter] [\-tabloid] [\-ledger] [\-legal] [\-statement]
[\-executive] [\-a3] [\-a4] [\-a5] [\-b4] [\-b5]
[\-folio] [\-quarto] [\-10x14]
[\-force] [\-forceorientation] [\-forcemedia]
[\-[no]openwindows] [\-[no]ncdwm]
[\-page \fIlabel\fP] [\-\fItoolkitoption\fR\ ...]
[filename]
.SH DESCRIPTION
The \fIghostview\fP program provides an X11 user interface for
the \fIghostscript\fP interpreter.
\fIGhostview\fP and \fIghostscript\fP function as two cooperating programs.
\fIGhostview\fP creates the viewing window and \fIghostscript\fP draws in it.
.PP
Don't be alarmed by the number of options.
Generally, one invokes \fIghostview\fP with just one parameter, the name of
the file to be previewed.  If the filename is ``-'', \fIghostview\fP will read
from ``stdin''.
The options provide a way to set X resources from
the command line for a single invocation of \fIghostview\fP.  For that reason,
discussion of the options is delayed until after the X resources are discussed.
.SH MAIN WINDOW
The main viewport is on the right side of the main window.
If the page is larger than the viewport, there will be scroll bars along the
bottom and right edges of the viewport.
To the left of the viewport is the table of contents.
If the PostScript file has document structuring convention (DSC) comments,
the table of context will display the page labels (i.e. usually page numbers).
To the left of the table of contents is the menu box.
Each push button brings up a popup menu.
Over the menu box and table of contents there are three optional labels
that contain the title, date, and locator.
The title label contains the document title found in the DSC comments.
If no title can be found, the filename is used in its place.
The date label contains the document date found in the DSC comments.
If no date can be found, the last modified date of the file is
used in its place.
Since the title and date labels may be clipped by the main viewport,
the date and title labels are push buttons that bring up a popup window
with the title or date.
These popup windows also show the ``document'' icon when the displayed string
comes from the DSC comments.
The locator shows the location of the cursor in the viewport.
The location is expressed in the default user coordinate system.
The locator is useful for measuring bounding boxes.
.PP
Within the main viewport the mouse cursor is a ``target'' when
\fIghostscript\fP is doing work.
The cursor is a ``cross hair'' when \fIghostscript\fP is idle.
When moving to another page in a document, it is generally best to wait
for \fIghostscript\fP to become idle.  Otherwise, the current \fIghostscript\fP process
must be killed and the overhead of reading the prologue is incurred again.
.PP
\fIGhostview\fP will check to see if the file has been modified just before
it displays a page or when the application is deiconified.
If the file has changed, it will reopen the file.
.PP
Clicking anywhere within the viewport will popup a zoom window.
The window is centered about the location that was clicked.
Clicking with the first mouse button pops up a low resolution zoom window.
Clicking with the second mouse button pops up a medium resolution zoom window.
Clicking with the third mouse button pops up a high resolution zoom window.
The cursor in the zoom window will display a ``target'' or ``cross hair''
depending on the state of \fIghostscript\fP.
The locator reports the position of the cursor in the zoom windows
as well as the main viewport.
.PP
In the table of contents, the first and third mouse button function exactly
as they do in a Text widget.
That is the first mouse button selects text and the third mouse button
extends selections.
However, clicking on a page label with the second mouse button will cause
that page to be shown.
The page being displayed is marked with a '<' in the right margin of
the table of contents.
.SH POPUP WINDOWS
There are several additional windows that may appear.
The \fIcopyright\fP window will appear whenever copyright information is
requested.
The \fIinformation\fP window appears whenever the \fIghostscript\fP process
writes to ``stdout'' or ``stderr''.
Whenever there is an error in the PostScript program, the stack trace will
appear in this window.
When \fIghostscript\fP is invoked without the quiet option, informational message
regarding the state of \fIghostscript\fP will appear in the \fIinformation\fP window.
The \fIcopyright\fP and \fIinformation\fP windows can be dismissed by pushing
the ``Dismiss'' button.
.PP
The \fISelect File\fP dialog widget will appear when you wish to open or save
a file.
The
.I Select File
dialog widget
allows an X11 user to select a file by typing the path or by browsing in
directory listings and selecting entries with the mouse.
.PP
The space bar can be pressed to complete filenames, and tilde is used for home
directories.
All the usual key bindings can be used in the text widget, except for Return
and Control\-M, which are equivalent to pressing the OK button.
The path can be scrolled using the large horizontal scroll bar, or by moving
the insertion cursor in the text widget.
The directory entries can be scrolled using the vertical scroll bars, or by
holding a mouse button down and moving out of the listing.
The scrolling speed varies with the distance from the listing.
.PP
The directory entries are terminated with special characters that show the
type of entry, similar to the
.I \-F
option of
.IR ls (1).
.PP
The
.I Select File
dialog widget is in total control until is pops down.
No other controls in \fIghostview\fP will be active during this time.
.SH MENUS
There are five buttons in the menu box.  They are the
\fBFile\fP, \fBPage\fP, \fBMagstep\fP, \fBOrientation\fP, and \fBMedia\fP
buttons.
There are keyboard accelerators for most of the popup menus.  Be sure
to read the keyboard accelerator section.
.IP \fBFile\fB 1i
This popup menu controls file access:
.RS 1i
.IP "\fBOpen...\fP" 1i
Pops up the Select File window in preparation to open a file.
The Select File widget is in total control until it pops down.
Opens the file for viewing.
.IP "\fBReopen\fP" 1i
Reopens the current file.
.IP "\fBPrint...\fP" 1i
Pops up a dialog widget to ask for the printer name.
Sends the whole document to the printer.
.IP "\fBPrint marked pages...\fP" 1i
Pops up a dialog widget to ask for the printer name.
Sends the marked pages to the printer.
If no pages have been marked, the mark procedure is called before
printing and then the unmark procedure is called after printing.
.IP "\fBSave marked pages...\fP" 1i
Pops up the Select File window in preparation to save a file.
The Select File widget is in total control until it pops down.
Saves the marked pages in the selected file.
If no pages have been marked, the mark procedure is called before
saving and then the unmark procedure is called after saving.
.IP "\fBCopyright...\fP" 1i
Pops up the \fIcopyright\fP window.
.IP "\fBQuit\fP" 1i
Causes \fIghostview\fP to exit.
.RS -1i
.IP \fBPage\fP 1i
This popup menu controls page access:
.RS 1i
.IP "\fBNext\fP" 1i
Display the next page.
.IP "\fBRedisplay\fP" 1i
Display the current page.
.IP "\fBPrevious\fP" 1i
Display the previous page.
.IP "\fBCenter\fP" 1i
Center the page in the viewport.
.IP "\fBMark\fP" 1i
Mark the pages that have been selected in the table of contents.
If no pages have been selected, mark the current page.
.IP "\fBUnmark\fP" 1i
Unmark the pages that have been selected in the table of contents.
If no pages have been selected, unmark the current page.
.RS -1i
.IP \fBMagstep\fP 1i
The Magstep menu controls the magnification at which the document is
viewed.
The default magstep of 0 implies no magnification (i.e. the size on
the screen should match the size on paper).
\fIGhostview\fP borrows the notion of magstep from \*(Te\&.  The magnification
is defined to be 1.2**magstep.  At magstep 1, the document is magnified
by 1.2.  At magstep -1, the document is reduced by 1.2.
The Magstep menu lists values from -5 to 5.
.IP \fBOrientation\fP 1i
The Orientation menu controls the display orientation.
A ``dot'' appears in front of the current orientation.
The first mouse button sets the default orientation.
The DSC comments may specify an orientation of Portrait or Landscape that
overrides the default.
In this case, a "document" appears in front of the current orientation.
The second mouse button can be used to ``force'' the orientation on
a document to override the DSC comments.
If an orientation is being forced, then a ``tie fighter'' will appear in
front of the current orientation.
.RS 1i
.IP "\fBPortrait\fP" 1i
Set the orientation to Portrait. This implies no rotation.
A portrait orientation indicates that the longest edge of the paper
is parallel to the vertical (y) axis.
.IP "\fBLandscape\fP" 1i
Set the orientation to Landscape.  This implies a clockwise rotation of the
paper by 90 degrees.
A landscape orientation indicates that the longest edge of the paper
is parallel to the horizontal (x) axis.
.IP "\fBUpside\-down\fP" 1i
Set the orientation to Upside\-Down.
.IP "\fBSeascape\fP" 1i
Set the orientation to Seascape.  This implies a counterclockwise rotation
of the paper by 90 degrees.
.IP "\fBSwap Landscape\fP" 1i
Swap the meaning of Landscape and Seascape.  Most of the Landscape documents
that I have encountered require a 90 clockwise rotation of the paper to
view.   However, there is no standard and some documents need to be rotated
the other way.  The swap landscape button allows \fIghostview\fP to automatically
rotate the document the right way in response to the \fB%%Orientation\fP comment
in the PostScript file.
.RS -1i
.IP \fBMedia\fP 1i
The entries on the Media menu set the page media.
Media defined in the document appear at the beginning of the menu
separated by a line from the standard media.
A ``dot'' appears in front of the current media.
The first mouse button sets the default media.
The DSC comments may specify the page media that overrides the default.
In this case, a "document" appears in front of the current media.
The second mouse button can be used to ``force'' the media on
a document to override the DSC comments.
Forcing the media on an EPSF figure will override the Bounding Box.
This makes is easy to view a figure with an incorrect \fB%%BoundingBox\fP comment.
If a media is being forced, then a ``tie fighter'' will appear in
front of the current media.
.sp
Here are the standard media names and their sizes.
The size is given as the width and height in PostScript points.
.ta 1.5i 3.0i
.RS 1i
.nf
\fBLetter\fP	 612 x  792	(8.5 x 11  in.)
\fBTabloid\fP	 792 x 1224	(11  x 17  in.)
\fBLedger\fP	1224 x  792	(17  x 11  in.)
\fBLegal\fP	 612 x 1008	(8.5 x 14  in.)
\fBStatement\fP	 396 x  612	(5.5 x 8.5 in.)
\fBExecutive\fP	 540 x  720	(7.5 x 10  in.)
\fBA3\fP	 842 x 1190
\fBA4\fP	 595 x  842
\fBA5\fP	 420 x  595
\fBB4\fP	 729 x 1032
\fBB5\fP	 516 x  729
\fBFolio\fP	 612 x  936	(8.5 x 13  in.)
\fBQuarto\fP	 610 x  780
\fB10x14\fP	 720 x 1008	(10  x 14  in.)
.fi
.SH KEYBOARD ACCELERATORS
Most of the popup menu commands have an equivalent action that can be
invoked from the keyboard.  The popup menu entry must be sensitive (i.e. not grayed
out) for the action to have effect.  Here is the default keyboard binding:
.IP \fBQ\fP 1i
Bound to \fBGhostviewQuit()\fP which is
equivalent to pushing the \fBQuit\fP menu button on the \fBGhostview\fP menu.
.IP \fBO\fP 1i
Bound to \fBGhostviewOpen()\fP which is
equivalent to pushing the \fBOpen...\fP menu button on the \fBFile\fP menu.
.IP \fBR\fP 1i
Bound to \fBGhostviewReopen()\fP which is
equivalent to pushing the \fBReopen\fP menu button on the \fBFile\fP menu.
.IP \fBS\fP 1i
Bound to \fBGhostviewSave()\fP which is
equivalent to pushing the \fBSave marked pages...\fP menu button on the \fBFile\fP menu.
.IP \fBP\fP 1i
Bound to \fBGhostviewPrintMarked()\fP which is
equivalent to pushing the \fBPrint marked pages...\fP menu button on the \fBFile\fP menu.
.IP \fBShift\-P\fP 1i
Bound to \fBGhostviewPrintWhole()\fP which is
equivalent to pushing the \fBPrint...\fP menu button on the \fBFile\fP menu.
.IP "\fBBackSpace\fP, \fBDelete\fP, \fBPrior\fP, \fBB\fP" 1i
Bound to \fBGhostviewPrevious()\fP which is
equivalent to pushing the \fBPrevious\fP menu button on the \fBPage\fP menu.
.IP "\fBspace\fP, \fBReturn\fP, \fBNext\fP, \fBF\fP" 1i
Bound to \fBGhostviewNext()\fP which is
equivalent to pushing the \fBNext\fP menu button on the \fBPage\fP menu.
.IP "\fBperiod\fP, \fBCtrl\-L\fP" 1i
Bound to \fBGhostviewShow()\fP which is
equivalent to pushing the \fBRedisplay\fP menu button on the \fBPage\fP menu.
.IP \fBM\fP 1i
Bound to \fBGhostviewMark()\fP which is
equivalent to pushing the \fBMark\fP menu button on the \fBPage\fP menu.
.IP \fBN\fP 1i
Bound to \fBGhostviewUnMark()\fP which is
equivalent to pushing the \fBUnmark\fP menu button on the \fBPage\fP menu.
.IP \fB0\fP 1i
Bound to \fBGhostviewMagstep(0)\fP which is
equivalent to pushing the \fB0\fP menu button on the \fBMagstep\fP menu.
.IP \fB1\fP 1i
Bound to \fBGhostviewMagstep(1)\fP which is
equivalent to pushing the \fB1\fP menu button on the \fBMagstep\fP menu.
.IP \fB2\fP 1i
Bound to \fBGhostviewMagstep(2)\fP which is
equivalent to pushing the \fB2\fP menu button on the \fBMagstep\fP menu.
.IP \fB3\fP 1i
Bound to \fBGhostviewMagstep(3)\fP which is
equivalent to pushing the \fB3\fP menu button on the \fBMagstep\fP menu.
.IP \fB4\fP 1i
Bound to \fBGhostviewMagstep(4)\fP which is
equivalent to pushing the \fB4\fP menu button on the \fBMagstep\fP menu.
.IP \fB5\fP 1i
Bound to \fBGhostviewMagstep(5)\fP which is
equivalent to pushing the \fB5\fP menu button on the \fBMagstep\fP menu.
.IP \fB+\fP 1i
Bound to \fBGhostviewIncreaseMagstep()\fP which increases the magstep by 1.
.IP \fB-\fP 1i
Bound to \fBGhostviewDecreaseMagstep()\fP which decreases the magstep by 1.
.IP \fBU\fP 1i
Bound to \fBGhostviewUp()\fP which scrolls the main viewport up.
.IP \fBD\fP 1i
Bound to \fBGhostviewDown()\fP which scrolls the main viewport down.
.IP \fBH\fP 1i
Bound to \fBGhostviewLeft()\fP which scrolls the main viewport left.
.IP \fBJ\fP 1i
Bound to \fBGhostviewDown()\fP which scrolls the main viewport down.
.IP \fBK\fP 1i
Bound to \fBGhostviewUp()\fP which scrolls the main viewport up.
.IP \fBL\fP 1i
Bound to \fBGhostviewRight()\fP which scrolls the main viewport right.
.IP "\fBUp\fP (arrow)" 1i
Bound to \fBGhostviewDefault() GhostviewSetOrientation(portrait)\fP which is
equivalent to pushing \fBPortrait\fP with the first mouse button on the
\fBOrientation\fP menu.
.IP "\fBRight\fP (arrow)" 1i
Bound to \fBGhostviewDefault() GhostviewSetOrientation(landscape)\fP which is
equivalent to pushing \fBLandscape\fP with the first mouse button on the
\fBOrientation\fP menu.
.IP "\fBDown\fP (arrow)" 1i
Bound to \fBGhostviewDefault() GhostviewSetOrientation(upside\-down)\fP which is
equivalent to pushing \fBUpside\-down\fP with the first mouse button on the
\fBOrientation\fP menu.
.IP "\fBLeft\fP (arrow)" 1i
Bound to \fBGhostviewDefault() GhostviewSetOrientation(seascape)\fP which is
equivalent to pushing \fBSeascape\fP with the first mouse button on the
\fBOrientation\fP menu.
.IP "\fBShift\-Up\fP (arrow)" 1i
Bound to \fBGhostviewForce() GhostviewSetOrientation(portrait)\fP which is
equivalent to pushing \fBPortrait\fP with the second mouse button on the
\fBOrientation\fP menu.
.IP "\fBShift\-Right\fP (arrow)" 1i
Bound to \fBGhostviewForce() GhostviewSetOrientation(landscape)\fP which is
equivalent to pushing \fBLandscape\fP with the second mouse button on the
\fBOrientation\fP menu.
.IP "\fBShift\-Down\fP (arrow)" 1i
Bound to \fBGhostviewForce() GhostviewSetOrientation(upside\-down)\fP which is
equivalent to pushing \fBUpside\-down\fP with the second mouse button on the
\fBOrientation\fP menu.
.IP "\fBShift\-Left\fP (arrow)" 1i
Bound to \fBGhostviewForce() GhostviewSetOrientation(seascape)\fP which is
equivalent to pushing \fBSeascape\fP with the second mouse button on the
\fBOrientation\fP menu.
.SH ACTIONS
Most of the popup menu commands have an equivalent action that can be
used in a translation.  The popup menu entry must be sensitive (i.e. not grayed
out) for the action to have effect.  Here is the list of actions:
.IP \fBGhostviewCopyright()\fP 1i
Equivalent to pushing the \fBCopyright...\fP menu button on the \fBGhostview\fP menu.
.IP \fBGhostviewQuit()\fP 1i
Equivalent to pushing the \fBQuit\fP menu button on the \fBGhostview\fP menu.
.IP \fBGhostviewOpen()\fP 1i
Equivalent to pushing the \fBOpen...\fP menu button on the \fBFile\fP menu.
.IP \fBGhostviewReopen()\fP 1i
Equivalent to pushing the \fBReopen\fP menu button on the \fBFile\fP menu.
.IP \fBGhostviewSave()\fP 1i
Equivalent to pushing the \fBSave marked pages...\fP menu button on the \fBFile\fP menu.
.IP \fBGhostviewPrintWhole()\fP 1i
Equivalent to pushing the \fBPrint...\fP menu button on the \fBFile\fP menu.
.IP \fBGhostviewPrintMarked()\fP 1i
Equivalent to pushing the \fBPrint marked pages...\fP menu button on the \fBFile\fP menu.
.IP \fBGhostviewPrevious()\fP 1i
Equivalent to pushing the \fBPrevious\fP menu button on the \fBPage\fP menu.
.IP \fBGhostviewShow()\fP 1i
Equivalent to pushing the \fBRedisplay\fP menu button on the \fBPage\fP menu.
.IP \fBGhostviewNext()\fP 1i
Equivalent to pushing the \fBNext\fP menu button on the \fBPage\fP menu.
.IP \fBGhostviewCenter()\fP 1i
Equivalent to pushing the \fBCenter\fP menu button on the \fBPage\fP menu.
.IP \fBGhostviewMark()\fP 1i
Equivalent to pushing the \fBMark\fP menu button on the \fBPage\fP menu.
.IP \fBGhostviewUnmark()\fP 1i
Equivalent to pushing the \fBUnmark\fP menu button on the \fBPage\fP menu.
.IP \fBGhostviewSetMagstep(magstep)\fP 1i
Sets the magstep.  The parameter must be an integer.
.IP \fBGhostviewIncreaseMagstep()\fP 1i
Increases magstep by one.
.IP \fBGhostviewDecreaseMagstep()\fP 1i
Decreases magstep by one.
.IP \fBGhostviewSetOrientation(orientation)\fP 1i
Set the orientation to the passed parameter.  The parameter must be
\fBportrait\fP, \fBlandscape\fP, \fBupside\-down\fP, or \fBseascape\fP.
.IP \fBGhostviewSwapLandscape()\fP 1i
Equivalent to pushing the \fBSwap Landscape\fP menu button on the \fBOrientation\fP menu.
.IP \fBGhostviewSetPageMedia(media\-name)\fP 1i
Sets the media.  The parameter should be either a media defined in the
document or a standard media.
.IP \fBGhostviewDefault()\fP 1i
The orientation or media being set is not forced on the document.
This action is called before the action that sets the orientation
or media.
.IP \fBGhostviewForce()\fP 1i
The orientation or media being set is forced on the document.
This action is called before the action that sets the orientation
or media.
.IP \fBGhostviewDeleteWindow()\fP 1i
Destroy the current window.  This provides a way to implement the Delete Window
protocol for window managers.
.IP \fBGhostviewDismiss()\fP 1i
Pop down the current window.  This provides a way to implement the Delete Window
protocol for window managers.
.IP \fBGhostviewScrollUp()\fP 1i
Scroll the main viewport up.
.IP \fBGhostviewScrollDown()\fP 1i
Scroll the main viewport down.
.IP \fBGhostviewScrollLeft()\fP 1i
Scroll the main viewport left.
.IP \fBGhostviewScrollRight()\fP 1i
Scroll the main viewport right.
.IP \fBGhostviewEraseLocator()\fP 1i
Used to erase the locator when leaving a Ghostview widget.
.IP \fBGhostviewCheckFile()\fP 1i
Checks to see if the file changed and refreshes the screen if necessary.
.SH APPLICATION RESOURCES
The following application resources may be set to
control the default behavior of \fIghostview\fP.
.IP "\fBshowTitle (\fPclass\fB Labels)\fP" 1i
Tells whether to display the \fB%%Title\fP comment.
The default is ``true''.
.IP "\fBshowDate (\fPclass\fB Labels)\fP" 1i
Tells whether to display the \fB%%Data\fP comment.
The default is ``true''.
.IP "\fBshowLocator (\fPclass\fB Labels)\fP" 1i
Tells whether to display the locator.
The default is ``true''.
.IP "\fBautoCenter (\fPclass\fB AutoCenter)\fP" 1i
Tells whether to center the page within the viewport whenever the page size
changes.
The default is ``true''.
.IP "\fBhorizonalMargin (\fPclass\fB Margin)\fP" 1i
Tells how many pixels ghostview should reserve for window decorations
in the horizontal direction.
The default value is ``20''.
.IP "\fBverticalMargin (\fPclass\fB Margin)\fP" 1i
Tells how many pixels ghostview should reserve for window decorations
in the vertical direction.
The default value is ``44''.
.IP "\fBminimumMagstep (\fPclass\fB Magstep)\fP" 1i
Tells the smallest magstep to display.
The default is ``-5''.
.IP "\fBmaximumMagstep (\fPclass\fB Magstep)\fP" 1i
Tells the largest magstep to display.
The default is ``5''.
.IP "\fBmagstep (\fPclass\fB Magstep)\fP" 1i
Sets the default magstep.
The default is ``0''.
.IP "\fBorientation (\fPclass\fB Orientation)\fP" 1i
Sets the default orientation.
The default is ``Portrait''.
.IP "\fBpage (\fPclass\fB Page)\fP" 1i
Gives the initial page to display.  This resource only affects the display
of the file listed on the command line.
The default is NULL.
.IP "\fBpageMedia (\fPclass\fB PageMedia)\fP" 1i
Sets the default page media.
The default is ``Letter''.
.IP "\fBforceOrientation (\fPclass\fB Force)\fP" 1i
Tells whether to force the orientation on the document.
The default is ``false''.
.IP "\fBforcePageMedia (\fPclass\fB Force)\fP" 1i
Tells whether to force the page media on the document.
The default is ``false''.
.IP "\fBswapLandscape (\fPclass\fB SwapLandscape)\fP" 1i
Tells whether to swap the meaning of Landscape and Seascape.
The default is ``false''.
.IP "\fBprintCommand (\fPclass\fB PrintCommand)\fP" 1i
Sets the command used for printing.
The printer environment variable is set to the desired printer
and then this command is executed using popen.  This command should
read from ``stdin'' and send the file to the appropriate printer.
The default value is ``lpr'' for BSD and ``lp'' for System V.
.IP "\fBprinterVariable (\fPclass\fB PrinterVariable)\fP" 1i
Gives the name of the printer environment variable.
The default value is ``PRINTER'' for BSD and ``LPDEST'' for System V.
.IP "\fBdefaultPrinter (\fPclass\fB DefaultPrinter)\fP" 1i
Gives the printer name to use when the printer environment variable is not set.
The default value is NULL.
.IP "\fBprintPrompt (\fPclass\fB PrintPrompt)\fP" 1i
Sets the prompt used to ask for the printer name.
The default value is ``Printer\ Name:\ ''.
.IP "\fBprintFail (\fPclass\fB printFail)\fP" 1i
Sets the string used to inform the user that the printer command failed.
The default is ``"lpr"\ command\ failed.''.
.IP "\fBopenPrompt (\fPclass\fB OpenPrompt)\fP" 1i
Sets the prompt used to ask for a file name to open.
The default value is ``Open\ File:\ ''.
.IP "\fBopenFail (\fPclass\fB OpenFail)\fP" 1i
Sets the string used to inform the user that the open failed.
The default value is ``Cannot\ open\ file:\ ''.
.IP "\fBsavePrompt (\fPclass\fB SavePrompt)\fP" 1i
Sets the prompt used to ask for a file name to save.
The default value is ``Save\ File:\ ''.
.IP "\fBsaveFail (\fPclass\fB SaveFail)\fP" 1i
Sets the string used to inform the user that the save failed.
The default value is ``Cannot\ save\ file:\ ''.
.IP "\fBopenWindows (\fPclass\fB OpenWindows)\fP" 1i
OpenWindows servers sometimes cause error messages about bitmaps not being
1 bit deep.  Turning on this resource avoids the problem by not using any
bitmaps.  You lose the functionality of having the current magstep,
orientation and media marked on the popup menus.
The default value is ``false''.
.IP "\fBncdwm (\fPclass\fB Ncdwm)\fP" 1i
The Xt Intrinsics has a bug that causes bogus information in
the window manager size hints.  \fINcdwm\fP and possibly other window managers
get confused by the bogus information and make the window extremely small.
\fITwm\fP and \fImwm\fP ignore the bogus information.  Turning on the resource avoids
the problem with \fIncdwm\fP by doing things slightly differently.  However, this
can confuse other window managers such as \fImwm\fP.  This bug is fixed in X11R5
fix-10.
You should only set this resource if you have the problem.
The default value is ``false''.
.SH GHOSTVIEW WIDGET RESOURCES
Certain resources in the Ghostview widget may be set by the user.
These selected resources are presented below.
.IP "\fBarguments (\fPclass\fB Arguments)\fP" 1i
Additional arguments passed to the interpreter.
It is convenient to name files that preload fonts here for PostScript programs
that continually reload fonts while rendering a page.
The default is no additional arguments.
.IP "\fBbusyCursor (\fPclass\fB Cursor)\fP" 1i
The cursor shown when \fIghostscript\fP is rendering to the window.
The busy cursor is set to the ``target'' by the application defaults.
.IP "\fBcursor (\fPclass\fB Cursor)\fP" 1i
The cursor shown when \fIghostscript\fP is idle.
The default cursor is the ``crosshair''.
.IP "\fBinterpreter (\fPclass\fB Interpreter)\fP" 1i
The name of the executable to call to render the PostScript.
It is convenient to set this resource to the path of an alternate
version of ghostscript for testing.
The default value is ``gs''.
.IP "\fBpalette (\fPclass\fB Palette)\fP" 1i
Tells \fIghostscript\fP how to restrict the palette used when rendering.
The possible values are ``color'', ``grayscale'', and ``monochrome''.
The default value is ``color''.
.IP "\fBquiet (\fPclass\fB Quiet)\fP" 1i
Tells \fIghostscript\fP whether to supress informational messages.
The default value is ``true''.
.IP "\fBsafer (\fPclass\fB Safer)\fP" 1i
Tells \fIghostscript\fP whether to run in ``safer'' mode.
The default value is ``true''.
.IP "\fBuseBackingPixmap (\fPclass\fB UseBackingPixmap)\fP" 1i
Tells whether to use a backing pixmap.  If this resource
is false, backing store is requested on the Ghostview window.
Some X servers have limited resources for large pixmaps.
Also, some X servers' backing store is much faster
than using a backing pixmap.  You should reset this resource if your
X server is one of the server types mentioned.
The default value is ``true''.
.IP "\fBxdpi (\fPclass\fB Resolution)\fP" 1i
Sets the X resolution of the window in dots per inch.
You can use this resource to affect the main window.
Zoom windows have their X dpi set explicitly in the program.
The default value is calculated from the screen metrics.
.IP "\fBydpi (\fPclass\fB Resolution)\fP" 1i
Sets the Y resolution of the window in dots per inch.
You can use this resource to affect the main window.
Zoom windows have their Y dpi set explicitly in the program.
The default value is calculated from the screen metrics.
.SH GHOSTVIEW WIDGET ACTIONS
.IP "\fBnotify(width height xdpi ydpi)\fP" 1i
The notify event is used by the ghostview application for the locator
and popup zoom windows.
If the width and height are 0, the event is user for the locator.
Otherwise, it triggers a popup zoom window.
The default width and height are 72.
The default xdpi and ydpi are 300.
The height will default to the width if the height is omitted.
The xdpi will default to the xdpi if the ydpi is omitted.
.SH OPTIONS
.IP \fB\-monochrome\fP 1i
Equivalent to setting ``*Ghostview.palette: Monochrome''.
.IP \fB\-grayscale\fP 1i
Equivalent to setting ``*Ghostview.palette: GrayScale''.
.IP \fB\-color\fP 1i
Equivalent to setting ``*Ghostview.palette: Color''.
.IP \fB\-title\fP 1i
Equivalent to setting ``Ghostview.showTitle: True''.
.IP \fB\-notitle\fP 1i
Equivalent to setting ``Ghostview.showTitle: False''.
.IP \fB\-date\fP 1i
Equivalent to setting ``Ghostview.showDate: True''.
.IP \fB\-nodate\fP 1i
Equivalent to setting ``Ghostview.showDate: False''.
.IP \fB\-locator\fP 1i
Equivalent to setting ``Ghostview.showLocator: True''.
.IP \fB\-nolocator\fP 1i
Equivalent to setting ``Ghostview.showLocator: False''.
.IP \fB\-labels\fP 1i
Equivalent to setting ``Ghostview.Labels: True''.
.IP \fB\-nolabels\fP 1i
Equivalent to setting ``Ghostview.Labels: False''.
.IP "\fB\-resolution\fP \fIdpi\fP" 1i
Equivalent to setting ``*Ghostview.Resolution: \fIdpi\fP''.
.IP "\fB\-dpi\fP \fIdpi\fP" 1i
Equivalent to setting ``*Ghostview.Resolution: \fIdpi\fP''.
.IP "\fB\-xdpi\fP \fIdpi\fP" 1i
Equivalent to setting ``*Ghostview.xdpi: \fIdpi\fP''.
.IP "\fB\-ydpi\fP \fIdpi\fP" 1i
Equivalent to setting ``*Ghostview.ydpi: \fIdpi\fP''.
.IP "\fB\-magstep\fP \fImagstep\fP" 1i
Equivalent to setting ``Ghostview.magstep: \fImagstep\fP''.
.IP \fB\-safer\fP 1i
Equivalent to setting ``*Ghostview.safer: True''.
.IP \fB\-nosafer\fP 1i
Equivalent to setting ``*Ghostview.safer: False''.
.IP \fB\-quiet\fP 1i
Equivalent to setting ``*Ghostview.quiet: True''.
.IP \fB\-noquiet\fP 1i
Equivalent to setting ``*Ghostview.quiet: False''.
.IP "\fB\-arguments\fP \fIarguments\fP" 1i
Equivalent to setting ``*Ghostview.arguments: \fIarguments\fP''.
.IP \fB\-center\fP 1i
Equivalent to setting ``Ghostview.autoCenter: True''.
.IP \fB\-nocenter\fP 1i
Equivalent to setting ``Ghostview.autoCenter: False''.
.IP \fB\-portrait\fP 1i
Equivalent to setting ``Ghostview.orientation: Portrait''.
.IP \fB\-landscape\fP 1i
Equivalent to setting ``Ghostview.orientation: Landscape''.
.IP \fB\-upsidedown\fP 1i
Equivalent to setting ``Ghostview.orientation: Upside\-down''.
.IP \fB\-seascape\fP 1i
Equivalent to setting ``Ghostview.orientation: Seascape''.
.IP \fB\-swap\fP 1i
Equivalent to setting ``Ghostview.swapLandscape: True''.
.IP \fB\-noswap\fP 1i
Equivalent to setting ``Ghostview.swapLandscape: False''.
.IP \fB\-letter\fP 1i
Equivalent to setting ``Ghostview.pageMedia: Letter''.
.IP \fB\-tabloid\fP 1i
Equivalent to setting ``Ghostview.pageMedia: Tabloid''.
.IP \fB\-ledger\fP 1i
Equivalent to setting ``Ghostview.pageMedia: Ledger''.
.IP \fB\-legal\fP 1i
Equivalent to setting ``Ghostview.pageMedia: Legal''.
.IP \fB\-statement\fP 1i
Equivalent to setting ``Ghostview.pageMedia: Statement''.
.IP \fB\-executive\fP 1i
Equivalent to setting ``Ghostview.pageMedia: Executive''.
.IP \fB\-a3\fP 1i
Equivalent to setting ``Ghostview.pageMedia: A3''.
.IP \fB\-a4\fP 1i
Equivalent to setting ``Ghostview.pageMedia: A4''.
.IP \fB\-a5\fP 1i
Equivalent to setting ``Ghostview.pageMedia: A5''.
.IP \fB\-b4\fP 1i
Equivalent to setting ``Ghostview.pageMedia: B4''.
.IP \fB\-b5\fP 1i
Equivalent to setting ``Ghostview.pageMedia: B5''.
.IP \fB\-folio\fP 1i
Equivalent to setting ``Ghostview.pageMedia: Folio''.
.IP \fB\-quarto\fP 1i
Equivalent to setting ``Ghostview.pageMedia: Quarto''.
.IP \fB\-10x14\fP 1i
Equivalent to setting ``Ghostview.pageMedia: 10x14''.
.IP \fB\-force\fP 1i
Equivalent to setting ``Ghostview.Force: True''.
.IP \fB\-forceorientation\fP 1i
Equivalent to setting ``Ghostview.forceOrientation: True''.
.IP \fB\-forcemedia\fP 1i
Equivalent to setting ``Ghostview.forcePageMedia: True''.
.IP \fB\-openwindows\fP 1i
Equivalent to setting ``Ghostview.openWindows: True''.
.IP \fB\-noopenwindows\fP 1i
Equivalent to setting ``Ghostview.openWindows: False''.
.IP \fB\-ncdwm\fP 1i
Equivalent to setting ``Ghostview.ncdwm: True''.
.IP \fB\-noncdwm\fP 1i
Equivalent to setting ``Ghostview.ncdwm: False''.
.IP "\fB\-page\fP \fIlabel\fP" 1i
Equivalent to setting ``Ghostview.page: \fIlabel\fP''.

.SH ENVIRONMENT
.IP \fBLPDEST\fP 1i
The LPDEST environment variable gives the default printer destination
on System V.
.IP \fBPRINTER\fP 1i
The PRINTER environment variable gives the default printer destination
on BSD.
.SH LIMITATIONS
If the document does not begin with ``%!PS\-Adobe\-'', it does not
claim conformance to the document structuring convention.
When these documents are encountered, the functionality of \fIghostview\fP
is limited to giving you scroll bars and a next page capability.
Because there is no table of contents,
skipping around the document and marking pages is impossible.
.PP
If there is no table of contents for the document, the popup zoom
window will always show the first page.
.SH BUGS
If you find a bug, please send a bug report to ghostview@cs.wisc.edu.
.SH AUTHOR
Copyright (C) 1992  Timothy O. Theisen
.PP
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.sp
.ta 1.0i 3.0i
.nf
Author:	Tim Theisen	Systems Programmer
Internet:	tim@cs.wisc.edu	Department of Computer Sciences
UUCP:	uwvax!tim	University of Wisconsin\-Madison
Phone:	(608)262\-0438	1210 West Dayton Street
FAX:	(608)262\-9777	Madison, WI   53706
.fi

