/*************************************************************************
 * File: $Source: /usr/usrs/xsource/mpeg/widget/test1.c,v $
 * Author: Jan Newmarch
 * Last modified: $Date: 1993/02/09 06:23:48 $
 * Version: $Revision: 1.1 $
 * Purpose: This file shows one movie, and adds buttons to control it.
 *
 ************************************************************************/ 


/*************************************************************************
 * System includes
 ************************************************************************/ 
#include <stdio.h> 
#include <string.h> 
#include <stdlib.h>
#include "mpeg.h" 
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>

/*************************************************************************
 * Local includes
 ************************************************************************/ 

/*************************************************************************
 * Functions exported
 ************************************************************************/ 

/*************************************************************************
 * Variables exported
 ************************************************************************/ 

/*************************************************************************
 * Extern variables
 ************************************************************************/ 

/*************************************************************************
 * Extern functions
 ************************************************************************/ 

/*************************************************************************
 * Forward functions
 ************************************************************************/ 

/*************************************************************************
 * Local variables
 ************************************************************************/ 
 
#define Class_name "Test" 
 
Widget	app_shell;	/*  ApplicationShell	*/ 
Widget	mpegW;



void
MovieStopped
	(Widget w, XtPointer client_data, XtPointer call_data)
{
}


void
startCB
	(Widget w, XtPointer client_data, XtPointer call_data)
{
	switch (XmpegMovieStatus (mpegW))
	{
	case  XmpegMOVIE_RUNNING:
		break;

	case XmpegMOVIE_PAUSED:
	case XmpegMOVIE_NOT_STARTED:
		XmpegPlayMovie (mpegW, -1);
		break;

	case XmpegMOVIE_FINISHED:
		XmpegRewindMovie (mpegW);
		XmpegPlayMovie (mpegW, -1);
		break;
	}
}

void
stopCB
	(Widget w, XtPointer client_data, XtPointer call_data)
{
	XmpegStopMovie (mpegW);
}

void
continueCB
	(Widget w, XtPointer client_data, XtPointer call_data)
{
	if (XmpegMovieStatus (mpegW) == XmpegMOVIE_PAUSED)
		XmpegPlayMovie (mpegW, -1);
	
}

void
rewindCB
	(Widget w, XtPointer client_data, XtPointer call_data)
{
	XmpegRewindMovie (mpegW);
}

void
stepCB
	(Widget w, XtPointer client_data, XtPointer call_data)
{
	if (XmpegMovieStatus (mpegW) == XmpegMOVIE_PAUSED ||
	    XmpegMovieStatus (mpegW) == XmpegMOVIE_NOT_STARTED)
		XmpegPlayMovie (mpegW, 1);
}

void
goodbyeCB
	(Widget w, XtPointer client_data, XtPointer call_data)
{
	exit (0);
}


/*************************************************************************
 * Function: main.c
 * Purpose: run the application
 * In parameters: argc, argv
 * Out parameters:
 * Precondition: true
 * Postcondition: application has completed
 ************************************************************************/ 
int
main 
#ifdef UseFunctionPrototypes
	(int argc, char **argv)
#else
	(argc, argv)  
	int		argc; 
	char 		**argv; 

#endif
{ 	
	Widget		applic_widget;
	Widget 		rc1, rc2;
	Widget		startW, stopW, continueW,
			rewindW, stepW, goodbye;
	XtAppContext	app_context;

	/*	Initialize toolkit and open the display. 
	*/ 
	 app_shell = XtVaAppInitialize(
			 &app_context,
	 	 	 Class_name,
			 NULL,
			 0,
	 	 	 &argc, argv,
			 NULL, NULL);


	rc1 = XmCreateRowColumn (app_shell, "rc1", NULL, 0);
	XtManageChild (rc1);

	mpegW = XmCreateMpeg (rc1, "mpegW", NULL, 0);
	XtManageChild (mpegW);
	XtAddCallback (mpegW, XmNmovieStoppedCallback,
			MovieStopped, NULL);
 
	rc2 = XmCreateRowColumn (rc1, "rc2", NULL, 0);
	XtManageChild (rc2);

	startW = XmCreatePushButton (rc2, "start", NULL, 0);
	XtManageChild (startW);
	XtAddCallback (startW, XmNactivateCallback, startCB, NULL);

	stopW = XmCreatePushButton (rc2, "stop", NULL, 0);
	XtManageChild (stopW);
	XtAddCallback (stopW, XmNactivateCallback, stopCB, NULL);

	continueW = XmCreatePushButton (rc2, "continue", NULL, 0);
	XtManageChild (continueW);
	XtAddCallback (continueW, XmNactivateCallback, continueCB, NULL);

	rewindW = XmCreatePushButton (rc2, "rewind", NULL, 0);
	XtManageChild (rewindW);
	XtAddCallback (rewindW, XmNactivateCallback, rewindCB, NULL);

	stepW = XmCreatePushButton (rc2, "step", NULL, 0);
	XtManageChild (stepW);
	XtAddCallback (stepW, XmNactivateCallback, stepCB, NULL);

	goodbye = XmCreatePushButton (rc2, "goodbye", NULL, 0);
	XtManageChild (goodbye);
	XtAddCallback (goodbye, XmNactivateCallback, goodbyeCB, NULL);

	/*	Create and realize main application window. 
	*/ 
	XtRealizeWidget (app_shell); 

	/*	Get and dispatch events. 
	*/ 
	XtAppMainLoop (app_context);

} 
 
