#ifndef _X_MPEGP_H
#define _X_MPEGP_H

#include "mpeg.h"

#ifdef MPEG_IS_MOTIF_WIDGET
#include <Xm/PrimitiveP.h>
#else
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* these came from LabelP.h */
#define XmInheritRealize  ((XtRealizeProc) _XtInherit)
#define XmInheritResize  ((XtWidgetProc) _XtInherit)

/* Mpeg class structure */

typedef struct _XmpegClassPart
{
   int foo;
} XmpegClassPart;


/* Full class record declaration for Mpeg class */

typedef struct _XmpegClassRec {
    CoreClassPart	  core_class;

#ifdef MPEG_IS_MOTIF_WIDGET
    XmPrimitiveClassPart  primitive_class;
#endif

    XmpegClassPart 	  mpeg_class;
} XmpegClassRec;


externalref XmpegClassRec xmpegClassRec;

/* Mpeg instance record */

typedef struct _XmpegPart
{
   int		    ditherType;
   XImage	    *ximage;
   GC		    gc;
   Colormap	    cmap;
   String	    source;
   int		    window_width;
   int		    window_height;
   VidStream	    *theStream;
   int		    showCount;
   short	    movieStatus;
   XtIntervalId     timerID;
   FILE		    *input;
   int		    EOF_flag;

   XtCallbackList   movie_stopped_callback;
} XmpegPart;


/* Full instance record declaration */

typedef struct _XmpegRec {
    CorePart	     core;

#ifdef MPEG_IS_MOTIF_WIDGET
    XmPrimitivePart  primitive;
#endif

    XmpegPart        mpeg;
} XmpegRec;


#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /* _X_MPEGP_H */
/* DON'T ADD ANYTHING AFTER THIS #endif */
