/*+****************************************************************************/
/*+                                                                           */
/*+ Copyright (c) 1992-1997 Bruce M. Corwin                                   */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Module Name: attributes.h                                                 */
/*+                                                                           */
/*+ Program ID:  vtwidget                                                     */
/*+                                                                           */
/*+ Functions:  None                                                          */
/*+                                                                           */
/*+****************************************************************************/

/* List of attribute codes for screen emulation */
/* Turning on normal VT attributes */
#define  ATT_NORMAL         ( 0 )
#define  ATT_BOLD           ( 1 )
#define  ATT_DIM            ( 2 )
#define  ATT_UNDERSCORE     ( 4 )
#define  ATT_BLINK          ( 5 )
#define  ATT_INVERSE        ( 7 )
/* Turning off normal VT attributes */
#define  ATT_NOBOLD         ( 22 )
#define  ATT_NODIM          ( 23 )
#define  ATT_NOUNDERSCORE   ( 24 )
#define  ATT_NOBLINK        ( 25 )
#define  ATT_NOINVERSE      ( 27 )
/* ANSI color escape attributes */
#define  ATT_ANSI_30        ( 30 )
#define  ATT_ANSI_31        ( 31 )
#define  ATT_ANSI_32        ( 32 )
#define  ATT_ANSI_33        ( 33 )
#define  ATT_ANSI_34        ( 34 )
#define  ATT_ANSI_35        ( 35 )
#define  ATT_ANSI_36        ( 36 )
#define  ATT_ANSI_37        ( 37 )
#define  ATT_ANSI_38        ( 38 )
#define  ATT_ANSI_39        ( 39 )
#define  ATT_ANSI_40        ( 40 )
#define  ATT_ANSI_41        ( 41 )
#define  ATT_ANSI_42        ( 42 )
#define  ATT_ANSI_43        ( 43 )
#define  ATT_ANSI_44        ( 44 )
#define  ATT_ANSI_45        ( 45 )
#define  ATT_ANSI_46        ( 46 )
#define  ATT_ANSI_47        ( 47 )
/* Special VT widget attributes */
#define  ATT_CURSOR         ( 50 )
#define  ATT_SELECT         ( 51 )
#define  ATT_SPECIAL        ( 52 )
#define  ATT_ARMED          ( 53 )
#define  ATT_GRAPHICS       ( 54 )
#define  ATT_WIDGET         ( 55 )
#define  ATT_CURSOR2        ( 56 )
/* Turning off Special VT widget attributes */
#define  ATT_NOCURSOR       ( 57 )
#define  ATT_NOSELECT       ( 58 )
#define  ATT_NOSPECIAL      ( 59 )
#define  ATT_NOARMED        ( 60 )
#define  ATT_NOGRAPHICS     ( 61 )
#define  ATT_NOWIDGET       ( 62 )
#define  ATT_NOCURSOR2      ( 63 )
/* End of attribute codes */

#define BLANK_ATTR          {0,0}
struct atr
{
    unsigned char attrib0;
    unsigned char attrib1;
    unsigned char attrib2;
    unsigned char attrib3;
    unsigned char attrib4;
    unsigned char attrib5;
    unsigned char attrib6;
    unsigned char attrib7;
};
typedef struct atr attribute;

void set (attribute * attr, int flag);
void clr (attribute * attr, int flag);
int isset (attribute attr, int flag);
void reset_attr (attribute * attr);
int isany (attribute attr);
int isnone (attribute attr);
int hasmatching (attribute attr1, attribute attr2);
int isequal (attribute attr1, attribute attr2);
