
/*******************************************************************************
	login_dialog.c

       Associated Header file: login_dialog.h
*******************************************************************************/

#include <stdio.h>

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/MwmUtil.h>
#include <Xm/DialogS.h>
#include <Xm/MenuShell.h>
#endif /* MOTIF */

#include "UxXt.h"
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/Form.h>

/*******************************************************************************
       Includes, Defines, and Global variables from the Declarations Editor:
*******************************************************************************/

#include <pwd.h>
#include <unistd.h>


void getuser();
void dynamic_popup();
int MyUxPutText();
void popup_login();

char user_id[BUFSIZ];
char password[BUFSIZ];
char node[BUFSIZ];
extern char combuff[BUFSIZ];
extern int dispoff;
extern int special_argc;
extern char **special_argv;
extern Widget vt1;


static	int _UxIfClassId;
/*******************************************************************************
       The following header file defines the context structure.
*******************************************************************************/

#ifndef XKLOADDS
#define XKLOADDS
#endif /* XKLOADDS */

#define CONTEXT_MACRO_ACCESS 1
#include "login_dialog.h"
#undef CONTEXT_MACRO_ACCESS

Widget	login_dialog;

/*******************************************************************************
       The following are translation tables.
*******************************************************************************/

static char	*transTable2 = "#override\n\
<Key>Return:next-tab-group()\n\
<Key>:getpass()\n";

static char	*transTable3 = "#override\n\
<Key>Return:next-tab-group()\n";

static char	*transTable4 = "#override\n\
<Key>Return:next-tab-group()\n\
<Btn3Down>:load_nodes()\n";

/*******************************************************************************
Auxiliary code from the Declarations Editor:
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* Function name: getuser                                                     */
/*                                                                            */
/* Program ID:    iftp                                                        */
/*                                                                            */
/* Description: This function returns the current username as determined      */
/*              from the real UID.                                            */
/*                                                                            */
/* Parameters:  user          - char *     - Username found                   */
/*                                                                            */
/* Input:      None                                                           */
/*                                                                            */
/* Output:     user                                                           */
/*                                                                            */
/* Special Logic Notes: None                                                  */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/*                            MODIFICATION LOG                                */
/*                                                                            */
/*    DATE        AUTHOR         DESCRIPTION                                  */
/*  --------    --------------   -------------------------------------------- */
/*  08-10-93    Bruce M. Corwin  Initial Release                              */
/*                                                                            */
/******************************************************************************/
void getuser( user )
char *user;
{
    int uid = 0;
    struct passwd *here;
    uid = getuid();
    here = ( struct passwd * )getpwuid( uid );
    strcpy( user, here->pw_name );
}
int MyUxPutText( tswid, buffer )
swidget tswid;
char *buffer;
{
    Widget tw = NULL;
    XmTextPosition tp = 0;
    tw = UxGetWidget( tswid );
    XmTextSetString (tw, buffer);

}

void popup_login()
{
    UxPopupInterface( login_dialog, no_grab );
}

/*******************************************************************************
       The following are Action functions.
*******************************************************************************/

static void  action_load_nodes(
			Widget wgt, 
			XEvent *ev, 
			String *parm, 
			Cardinal *p_UxNumParams)
{
	Cardinal		UxNumParams = *p_UxNumParams;
	_UxClogin_dialog        *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XEvent                  *UxEvent = ev;
	String                  *UxParams = parm;

	UxSaveCtx = UxLogin_dialogContext;
	UxLogin_dialogContext = UxContext =
			(_UxClogin_dialog *) UxGetContext( UxWidget );
	{
	    /*  This will be used to load nodes */
	}
	UxLogin_dialogContext = UxSaveCtx;
}

static void  action_getpass(
			Widget wgt, 
			XEvent *ev, 
			String *parm, 
			Cardinal *p_UxNumParams)
{
	Cardinal		UxNumParams = *p_UxNumParams;
	_UxClogin_dialog        *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XEvent                  *UxEvent = ev;
	String                  *UxParams = parm;

	UxSaveCtx = UxLogin_dialogContext;
	UxLogin_dialogContext = UxContext =
			(_UxClogin_dialog *) UxGetContext( UxWidget );
	{
	    Modifiers out;
	    KeySym symbol = 0;
	    XKeyEvent *current_event = ( XKeyEvent * )UxEvent;
	    char keybuffer[BUFSIZ];
	    XComposeStatus  status_in_out;
	    keybuffer[0] = 0;
	    keybuffer[1] = 0;
	    keybuffer[2] = 0;
	    keybuffer[3] = 0;
	    keybuffer[4] = 0;
	    XLookupString( current_event, keybuffer, BUFSIZ, &symbol, &status_in_out );
	    if( keybuffer[0] != 0 && keybuffer[0] != 8 )
	    {
	        strcat( password, keybuffer ); 
	    }
	    if( keybuffer[0] == 8 && password[0] != 0 )
	    {
	        password[strlen(password)-1] = 0;
	    }  
	}
	UxLogin_dialogContext = UxSaveCtx;
}

/*******************************************************************************
       The following are callback functions.
*******************************************************************************/

static void  activateCB_pushButton1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxClogin_dialog        *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxLogin_dialogContext;
	UxLogin_dialogContext = UxContext =
			(_UxClogin_dialog *) UxGetContext( UxWidget );
	{
	char command[BUFSIZ];
	
#ifdef VT
	dispoff = True;
	if( password[0] == 0 ) strcpy( password, "junk" );
	strcpy( user_id, XmTextFieldGetString( UxGetWidget( textField1 ) ) );
	strcpy( node,    XmTextFieldGetString( UxGetWidget( textField3 ) ) );
	sprintf( command, "open %s\n", node );
	XmVtSend( vt1, command );
	sprintf( command, "user %s %s\n", user_id, password );
	XmVtSend( vt1, command );
#endif
	
	}
	UxLogin_dialogContext = UxSaveCtx;
}

static void  activateCB_pushButton3(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxClogin_dialog        *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxLogin_dialogContext;
	UxLogin_dialogContext = UxContext =
			(_UxClogin_dialog *) UxGetContext( UxWidget );
	{
	char command[BUFSIZ];
	char shorthostname[BUFSIZ];
	char hostname[BUFSIZ];
	char loc_user[BUFSIZ];
	char shortdomainname[BUFSIZ];
	char *env = NULL;
	char firewall[BUFSIZ];
	
	
#ifdef VT
	env = getenv ("FIREWALL");
	if (env != NULL)
	    strcpy (firewall, env);
	else
	    strcpy (firewall, "xxxxxxx.com");
	dispoff = True;
	getuser( loc_user );
	gethostname (shorthostname, BUFSIZ);
	getdomainname( shortdomainname, BUFSIZ );
	sprintf( hostname, "%s.%s", shorthostname , shortdomainname);
	
	if( password[0] == 0 ) strcpy( password, "junk" );
	strcpy( user_id, XmTextFieldGetString( UxGetWidget( textField1 ) ) );
	strcpy( node,    XmTextFieldGetString( UxGetWidget( textField3 ) ) );
	sprintf( command, "open %s\n", firewall);
	XmVtSend( vt1, command );
	sprintf( command, "user %s %s\n", user_id, password );
	XmVtSend( vt1, command );
	sprintf( command, "user anonymous\\@%s %s\\@%s\n", node, loc_user, hostname );
	XmVtSend( vt1, command );
#endif
	}
	UxLogin_dialogContext = UxSaveCtx;
}

static void  activateCB_pushButton5(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxClogin_dialog        *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxLogin_dialogContext;
	UxLogin_dialogContext = UxContext =
			(_UxClogin_dialog *) UxGetContext( UxWidget );
	{
	char command[BUFSIZ];
	char shorthostname[BUFSIZ];
	char hostname[BUFSIZ];
	char loc_user[BUFSIZ];
	
#ifdef VT
	dispoff = True;
	getuser( loc_user );
	gethostname( shorthostname, BUFSIZ );
	sprintf( hostname, "%s.delcoelect.com", shorthostname );
	
	strcpy( node,    XmTextFieldGetString( UxGetWidget( textField3 ) ) );
	sprintf( command, "open 130.174.1.146\n" );
	XmVtSend( vt1, command );
	sprintf( command, "user anonymous\\@%s %s\\@%s\n", node, loc_user, hostname );
	XmVtSend( vt1, command );
#endif
	}
	UxLogin_dialogContext = UxSaveCtx;
}

/*******************************************************************************
       The 'build_' function creates all the widgets
       using the resource values specified in the Property Editor.
*******************************************************************************/

static Widget	_Uxbuild_login_dialog()
{
	Widget		_UxParent;


	/* Creation of login_dialog */
	_UxParent = XtVaCreatePopupShell( "login_dialog_shell",
			xmDialogShellWidgetClass, UxTopLevel,
			XmNx, 423,
			XmNy, 378,
			XmNwidth, 433,
			XmNheight, 233,
			XmNshellUnitType, XmPIXELS,
			XmNtitle, "login_dialog",
			NULL );

	login_dialog = XtVaCreateWidget( "login_dialog",
			xmFormWidgetClass,
			_UxParent,
			XmNunitType, XmPIXELS,
			XmNwidth, 433,
			XmNheight, 233,
			RES_CONVERT( XmNdialogTitle, "FTP Session Profile" ),
			XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
			XmNallowOverlap, FALSE,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( login_dialog, (char *) UxLogin_dialogContext );
	UxPutClassCode( login_dialog, _UxIfClassId );


	/* Creation of textField1 */
	textField1 = XtVaCreateManagedWidget( "textField1",
			xmTextFieldWidgetClass,
			login_dialog,
			XmNx, 20,
			XmNy, 50,
			XmNwidth, 210,
			XmNheight, 40,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftOffset, 0,
			XmNrightAttachment, XmATTACH_FORM,
			XmNrightOffset, 20,
			XmNtopAttachment, XmATTACH_FORM,
			XmNtopOffset, 10,
			XmNleftPosition, 25,
			RES_CONVERT( XmNtranslations, transTable3 ),
			XmNbottomAttachment, XmATTACH_NONE,
			XmNbottomPosition, 25,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( textField1, (char *) UxLogin_dialogContext );


	/* Creation of label1 */
	label1 = XtVaCreateManagedWidget( "label1",
			xmLabelWidgetClass,
			login_dialog,
			XmNx, 10,
			XmNy, 50,
			XmNwidth, 50,
			XmNheight, 40,
			RES_CONVERT( XmNlabelString, "Login:" ),
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 10,
			XmNtopAttachment, XmATTACH_FORM,
			XmNtopOffset, 10,
			XmNrightAttachment, XmATTACH_POSITION,
			XmNrightOffset, 0,
			XmNrightPosition, 25,
			XmNbottomAttachment, XmATTACH_NONE,
			XmNbottomPosition, 25,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( label1, (char *) UxLogin_dialogContext );


	/* Creation of textField2 */
	textField2 = XtVaCreateManagedWidget( "textField2",
			xmTextFieldWidgetClass,
			login_dialog,
			XmNx, 60,
			XmNy, 100,
			XmNwidth, 160,
			XmNheight, 40,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftPosition, 25,
			XmNrightAttachment, XmATTACH_FORM,
			XmNrightOffset, 20,
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopOffset, 0,
			XmNtopWidget, NULL,
			RES_CONVERT( XmNtranslations, transTable2 ),
			XmNbottomAttachment, XmATTACH_NONE,
			XmNbottomPosition, 50,
			XmNtopPosition, 30,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( textField2, (char *) UxLogin_dialogContext );


	/* Creation of label2 */
	label2 = XtVaCreateManagedWidget( "label2",
			xmLabelWidgetClass,
			login_dialog,
			XmNx, 10,
			XmNy, 100,
			XmNwidth, 50,
			XmNheight, 40,
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopOffset, 0,
			XmNtopWidget, NULL,
			XmNrightAttachment, XmATTACH_POSITION,
			XmNrightPosition, 25,
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 10,
			RES_CONVERT( XmNlabelString, "Password:" ),
			XmNbottomAttachment, XmATTACH_NONE,
			XmNbottomPosition, 50,
			XmNtopPosition, 30,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( label2, (char *) UxLogin_dialogContext );


	/* Creation of label3 */
	label3 = XtVaCreateManagedWidget( "label3",
			xmLabelWidgetClass,
			login_dialog,
			XmNx, 10,
			XmNy, 150,
			XmNwidth, 50,
			XmNheight, 40,
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopOffset, 0,
			XmNtopWidget, NULL,
			XmNrightAttachment, XmATTACH_POSITION,
			XmNrightPosition, 25,
			RES_CONVERT( XmNlabelString, "Node:" ),
			XmNtopPosition, 55,
			XmNbottomAttachment, XmATTACH_NONE,
			XmNbottomPosition, 75,
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 10,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( label3, (char *) UxLogin_dialogContext );


	/* Creation of pushButton1 */
	pushButton1 = XtVaCreateManagedWidget( "pushButton1",
			xmPushButtonWidgetClass,
			login_dialog,
			XmNx, 20,
			XmNy, 162,
			XmNwidth, 52,
			XmNheight, 30,
			RES_CONVERT( XmNlabelString, "Normal" ),
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 20,
			XmNrightAttachment, XmATTACH_NONE,
			XmNrightPosition, 35,
			XmNtopAttachment, XmATTACH_NONE,
			XmNtopOffset, 0,
			XmNtopWidget, NULL,
			XmNnavigationType, XmTAB_GROUP,
			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomPosition, 0,
			XmNtopPosition, 80,
			XmNbottomOffset, 10,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	XtAddCallback( pushButton1, XmNactivateCallback,
		(XtCallbackProc) activateCB_pushButton1,
		(XtPointer) UxLogin_dialogContext );

	UxPutContext( pushButton1, (char *) UxLogin_dialogContext );


	/* Creation of pushButton2 */
	pushButton2 = XtVaCreateManagedWidget( "pushButton2",
			xmPushButtonWidgetClass,
			login_dialog,
			XmNx, 355,
			XmNy, 162,
			XmNwidth, 52,
			XmNheight, 30,
			RES_CONVERT( XmNlabelString, "Cancel" ),
			XmNrightOffset, 20,
			XmNleftAttachment, XmATTACH_NONE,
			XmNleftOffset, 0,
			XmNleftPosition, 65,
			XmNrightAttachment, XmATTACH_FORM,
			XmNtopAttachment, XmATTACH_NONE,
			XmNtopOffset, 0,
			XmNnavigationType, XmTAB_GROUP,
			XmNtopPosition, 80,
			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomOffset, 10,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( pushButton2, (char *) UxLogin_dialogContext );


	/* Creation of pushButton3 */
	pushButton3 = XtVaCreateManagedWidget( "pushButton3",
			xmPushButtonWidgetClass,
			login_dialog,
			XmNx, 128,
			XmNy, 164,
			XmNwidth, 52,
			XmNheight, 30,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftOffset, 0,
			XmNleftPosition, 30,
			XmNrightAttachment, XmATTACH_NONE,
			XmNrightPosition, 63,
			RES_CONVERT( XmNlabelString, "FW" ),
			XmNtopAttachment, XmATTACH_NONE,
			XmNtopOffset, 0,
			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomOffset, 10,
			XmNtopPosition, 80,
			XmNnavigationType, XmTAB_GROUP,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	XtAddCallback( pushButton3, XmNactivateCallback,
		(XtCallbackProc) activateCB_pushButton3,
		(XtPointer) UxLogin_dialogContext );

	UxPutContext( pushButton3, (char *) UxLogin_dialogContext );


	/* Creation of pushButton5 */
	pushButton5 = XtVaCreateManagedWidget( "pushButton5",
			xmPushButtonWidgetClass,
			login_dialog,
			XmNx, 232,
			XmNy, 162,
			XmNwidth, 52,
			XmNheight, 30,
			RES_CONVERT( XmNlabelString, "Anon" ),
			XmNnavigationType, XmTAB_GROUP,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftOffset, 0,
			XmNleftPosition, 57,
			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomOffset, 10,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	XtAddCallback( pushButton5, XmNactivateCallback,
		(XtCallbackProc) activateCB_pushButton5,
		(XtPointer) UxLogin_dialogContext );

	UxPutContext( pushButton5, (char *) UxLogin_dialogContext );


	/* Creation of textField3 */
	textField3 = XtVaCreateManagedWidget( "textField3",
			xmTextFieldWidgetClass,
			login_dialog,
			XmNx, 70,
			XmNy, 150,
			XmNwidth, 160,
			XmNheight, 40,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftOffset, 0,
			XmNleftPosition, 25,
			XmNrightAttachment, XmATTACH_FORM,
			XmNrightOffset, 20,
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopOffset, 0,
			XmNtopWidget, NULL,
			RES_CONVERT( XmNtranslations, transTable4 ),
			XmNtopPosition, 55,
			XmNbottomAttachment, XmATTACH_NONE,
			XmNbottomPosition, 75,
			XmNbottomOffset, 0,
			XmNbottomWidget, NULL,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( textField3, (char *) UxLogin_dialogContext );

	XtVaSetValues(login_dialog,
			XmNdefaultButton, pushButton1,
			XmNcancelButton, pushButton2,
			NULL );


	XtAddCallback( login_dialog, XmNdestroyCallback,
		(XtCallbackProc) UxDestroyContextCB,
		(XtPointer) UxLogin_dialogContext);


	return ( login_dialog );
}

/*******************************************************************************
       The following is the 'Interface function' which is the
       external entry point for creating this interface.
       This function should be called from your application or from
       a callback function.
*******************************************************************************/

Widget	create_login_dialog()
{
	Widget                  rtrn;
	_UxClogin_dialog        *UxContext;
	static int		_Uxinit = 0;

	UxLogin_dialogContext = UxContext =
		(_UxClogin_dialog *) UxNewContext( sizeof(_UxClogin_dialog), False );


	if ( ! _Uxinit )
	{
		static XtActionsRec	_Uxactions[] = {
			{ "load_nodes", (XtActionProc) action_load_nodes },
			{ "getpass", (XtActionProc) action_getpass }};

		XtAppAddActions( UxAppContext,
				_Uxactions,
				XtNumber(_Uxactions) );

		_UxIfClassId = UxNewInterfaceClassId();
		_Uxinit = 1;
	}

	rtrn = _Uxbuild_login_dialog();

	{
	    char filename[BUFSIZ];
	    sprintf( filename, "%s/.nodes", getenv( "HOME" ) );
	    if( special_argc == 2 )
	    {
	        MyUxPutText( textField3, special_argv[1] );
	        strcpy( node, special_argv[1] );
	    }
	    dynamic_popup( textField3, "nodes", "Nodes", filename );
	    return(rtrn);
	}
}

/*******************************************************************************
       END OF FILE
*******************************************************************************/

