
/*******************************************************************************
	help_msg.c

       Associated Header file: help_msg.h
*******************************************************************************/

#include <stdio.h>

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/MwmUtil.h>
#include <Xm/DialogS.h>
#include <Xm/MenuShell.h>
#endif /* MOTIF */

#include "UxXt.h"
#include <Xm/MessageB.h>

/*******************************************************************************
       Includes, Defines, and Global variables from the Declarations Editor:
*******************************************************************************/

void popup_help_msg();


static	int _UxIfClassId;
/*******************************************************************************
       The following header file defines the context structure.
*******************************************************************************/

#ifndef XKLOADDS
#define XKLOADDS
#endif /* XKLOADDS */

#define CONTEXT_MACRO_ACCESS 1
#include "help_msg.h"
#undef CONTEXT_MACRO_ACCESS


/*******************************************************************************
Auxiliary code from the Declarations Editor:
*******************************************************************************/

void popup_help_msg()
{
    UxPopupInterface( help_msg, no_grab );
}

/*******************************************************************************
       The following are callback functions.
*******************************************************************************/

/*******************************************************************************
       The 'build_' function creates all the widgets
       using the resource values specified in the Property Editor.
*******************************************************************************/

static Widget	_Uxbuild_help_msg()
{
	Widget		_UxParent;


	/* Creation of help_msg */
	_UxParent = XtVaCreatePopupShell( "help_msg_shell",
			xmDialogShellWidgetClass, UxTopLevel,
			XmNx, 138,
			XmNy, 150,
			XmNwidth, 481,
			XmNheight, 250,
			XmNshellUnitType, XmPIXELS,
			XmNtitle, "help_msg",
			NULL );

	help_msg = XtVaCreateWidget( "help_msg",
			xmMessageBoxWidgetClass,
			_UxParent,
			XmNunitType, XmPIXELS,
			XmNwidth, 481,
			XmNheight, 250,
			RES_CONVERT( XmNmessageString, "Ftpterm is a project to write a useful FTP\nclient with the VT widget used for FTP command input.\n\nBy Bruce Corwin\n\nCopyright (c) 1994-1996\nBruce M. Corwin" ),
			RES_CONVERT( XmNdialogTitle, "About Bterm" ),
			XmNdefaultButtonType, XmDIALOG_OK_BUTTON,
			RES_CONVERT( XmNhelpLabelString, "Help" ),
			XmNminimizeButtons, FALSE,
			NULL );
	UxPutContext( help_msg, (char *) UxHelp_msgContext );
	UxPutClassCode( help_msg, _UxIfClassId );

	XtVaSetValues(help_msg,
			RES_CONVERT( XmNsymbolPixmap, "terminal" ),
			NULL );


	XtAddCallback( help_msg, XmNdestroyCallback,
		(XtCallbackProc) UxDestroyContextCB,
		(XtPointer) UxHelp_msgContext);


	return ( help_msg );
}

/*******************************************************************************
       The following is the 'Interface function' which is the
       external entry point for creating this interface.
       This function should be called from your application or from
       a callback function.
*******************************************************************************/

Widget	create_help_msg( swidget _UxUxParent )
{
	Widget                  rtrn;
	_UxChelp_msg            *UxContext;
	static int		_Uxinit = 0;

	UxHelp_msgContext = UxContext =
		(_UxChelp_msg *) UxNewContext( sizeof(_UxChelp_msg), False );

	UxParent = _UxUxParent;

	if ( ! _Uxinit )
	{
		_UxIfClassId = UxNewInterfaceClassId();
		_Uxinit = 1;
	}

	rtrn = _Uxbuild_help_msg();

	return(rtrn);
}

/*******************************************************************************
       END OF FILE
*******************************************************************************/

