# Local additions to Autoconf macros.



## -------------------------------------------- ##
## See if realloc(NULL) works. If it doesn't,   ##
## Add realloc.o to LIBOBJS.                    ##
## -------------------------------------------- ##


AC_DEFUN(ck_REALLOC_NULL,
[AC_CACHE_CHECK([whether or not realloc(NULL) works], ac_cv_func_realloc_null_ok,
[AC_TRY_RUN([char* realloc(); int main() { exit ( realloc(0,1) ? 0 : 1); }],
   ac_cv_func_realloc_null_ok=yes,
   ac_cv_func_realloc_null_ok=no,
   ac_cv_func_realloc_null_ok=no)]),
if test "$ac_cv_func_realloc_null_ok" != yes; then
   LIBOBJS="$LIBOBJS realloc.o"
   AC_SUBST(LIBOBJS)dnl
fi
])



## -------------------------------------------- ##
## See if sprintf() returns an char*.  If it    ##
## doesn't, add sprintf.o to LIBOBJS.           ##
## -------------------------------------------- ##

AC_DEFUN(ck_SPRINTF_RETURNS_INT,
[AC_CACHE_CHECK([to see if sprintf() returns int], ac_cv_func_sprintf_returns_int,
[AC_TRY_RUN([char* sprintf(); int main() { char x[4]; exit ( sprintf(x,"ab") != sprintf(x,"c") ? 0 : 1 ); }],
   ac_cv_func_sprintf_returns_int=yes,
   ac_cv_func_sprintf_returns_int=no,
   ac_cv_func_sprintf_returns_int=no)])
if test "$ac_cv_func_sprintf_returns_int" = no; then
   LIBOBJS="$LIBOBJS sprintf.o"
   AC_SUBST(LIBOBJS)dnl
fi
])
