/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: BarGraph.c,v 1.1 95/02/02 11:04:15 leon Exp $ */

#include "BarGraphP.h"
#include <limits.h>




static XtResource 
resources[] = {
#define offset(field) XtOffset(KnGraphWidget, graph.field)
  {
      XmNitems, XmCItems, XtRPointer,
      sizeof(XtPointer), offset(items),
      XtRImmediate, (caddr_t)NULL
  },
  
  {
      XmNitemCount, XmCItemCount, XtRInt,
      sizeof(int), offset(itemCount),
      XtRImmediate, (caddr_t)0
  },
  
  {
      XmNmarginWidth, XmCMarginWidth, XtRDimension,
      sizeof(Dimension), offset(marginWidth),
      XtRImmediate, (caddr_t)50
  },
  
  {
      XmNmarginHeight, XmCMarginHeight, XtRDimension,
      sizeof(Dimension), offset(marginHeight),
      XtRImmediate, (caddr_t)10
  },
  
  {
      XmNspacing, XmCSpacing, XtRDimension,
      sizeof(Dimension), offset(spacing),
      XtRImmediate, (caddr_t)5
  },
#undef offset
};





static void
ClassPartInitializeProc(WidgetClass wc)
{

}


static int
GetMax(int *items, int num)
{
    Cardinal i;
    int res = INT_MIN;
    for(i = 0; i <num; i++) {
	if(items[i] > res) res = items[i];
    }
    return res;
}    


static int
GetMin(int *items, int num)
{
    Cardinal i;
    int res = INT_MAX;
    for(i = 0; i <num; i++) {
	if(items[i] < res) res = items[i];
    }
    return res;
}    


static void
BuildBarChartDrawing(Widget graph)
{
    KnGraphWidget gw = (KnGraphWidget) graph;
#define THIS gw->graph
    Cardinal i;
    Dimension w, h;		/* available space for drawing */
    Dimension bw;		/* bar width */
    Dimension inc;		/* increment */
    KnTag axes, labels;
    KnO kno, title;
    Position x;
    int maxval, minval;
    int dmax, dmin;
    char number[32];
    float ratio;
    int len;

    w = graph->core.width - THIS.marginWidth*2;
    h = graph->core.height - THIS.marginHeight*2;
    bw = (w - (THIS.itemCount)*THIS.spacing) / THIS.itemCount; /* bar width */
    THIS.layer = KnCreateLayer(graph);
    x = THIS.marginWidth + THIS.spacing;
    maxval = GetMax(THIS.items, THIS.itemCount);
    minval = GetMin(THIS.items, THIS.itemCount);

    /* compute top value */
    sprintf(number, "%d", maxval);
    len = strlen(number);
    dmax = ((number[0]-'0')+1) * ((len>1) ? (10*(len-1)) : 1);
    
    dmin = 0;
    ratio = h / (dmax-dmin);
    
    inc = bw + THIS.spacing;
    for(i = 0; i < THIS.itemCount; i++) {
	KnCreateFRect(graph, THIS.layer,
		    x, THIS.marginHeight+h-THIS.items[i]*ratio,
		    bw, THIS.items[i]*ratio);
	x += inc;
    }
    axes = KnCreateTag(graph, "axes");
    kno = KnCreateLine(graph, THIS.layer,
	       THIS.marginWidth, graph->core.height - THIS.marginHeight,
	       graph->core.width - THIS.spacing,
	       graph->core.height - THIS.marginHeight);
    KnSetTag(graph, kno, axes);
    kno = KnCreateLine(graph, THIS.layer,
	       THIS.marginWidth, THIS.marginHeight,
	       THIS.marginWidth,
	       graph->core.height - THIS.marginHeight);
    KnSetTag(graph, kno, axes);

    /* add some interesting labels */
    sprintf(number, "%d", dmax);
    labels = KnCreateTag(graph, "labels");
    title = KnCreateLabel(graph, THIS.layer, 20, 10, number);
    KnSetTag(graph, title, labels);
#undef THIS
    
}    


static void 
InitializeProc(Widget w, Widget neww, ArgList args, Cardinal *n)
{
    if(w->core.width != neww->core.width)
	neww->core.width = w->core.width;
    if(w->core.height != neww->core.height)
	neww->core.height = w->core.height;
    BuildBarChartDrawing(neww);
}







KnGraphClassRec knGraphClassRec = {
  { /* core fields */
      /* superclass		*/	(WidgetClass) &knvasClassRec,
    /* class_name		*/	"KnGraph",
    /* widget_size		*/	sizeof(KnGraphRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	ClassPartInitializeProc,
    /* class_inited		*/	FALSE,
    /* initialize		*/	InitializeProc,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	XtExposeCompressMaximal,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	XtInheritResize,
    /* expose			*/	XtInheritExpose,
    /* set_values		*/	NULL,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	XtInheritTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* composite fields */
    /* geometry_manager     */  XtInheritGeometryManager,
    /* change_managed       */  XtInheritChangeManaged,
    /* insert_child	    */  XtInheritInsertChild,
    /* delete_child	    */  XtInheritDeleteChild,
    /* extension	    */  NULL
    },
    {
    /* constraint_class fields */
	/* resources			*/ NULL,
	/* num_resources		*/ 0,
	/* constraint_size		*/ 0,
	/* initialize			*/ NULL,
	/* destroy			*/ NULL,
	/* set_values			*/ NULL,
	/* extension			*/ NULL
    },
    {
    /* manager_class fields */
	/* translations			*/  XtInheritTranslations,
	/* syn_resources		*/  NULL,
	/* num_syn_resources		*/  0,
	/* syn_constraint_resources	*/  NULL,
	/* num_syn_constraint_resources */  0,
	/* parent_process		*/  XmInheritParentProcess,
	/* extension			*/  NULL
    },
  { /* graph fields */
    /* empty			*/	0
  }
};

WidgetClass knGraphWidgetClass = (WidgetClass)&knGraphClassRec;

