/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: sizes.c,v 1.2.1.2 96/02/06 16:29:56 leon Exp $ */
/* Author: Jean-Michel.Leon@sophia.inria.fr */


/* do some validity checks about transformations */


#include <assert.h>
#include <stdio.h>
#include <Kn/Knvas.h>

static String 
fallbacks[] = {
"*geometry: 600x600",
"*shadowThickness: 1",
"*pixmapBuffering: false",
"*default.shadowType: SHADOW_OUT",
"*default.foreground: green3",
NULL
};

void CheckGeometry(Widget knvas, KnO kno, int x, int y, int w, int h)
{
    XRectangle box;
    /* check object's bounding box */
    KlSend_boundingbox(kno, knvas, &box);
    assert(box.x == x);
    assert(box.y == y);
    assert(box.width == w);
    assert(box.height == h);

    /* check that points are really inside the object */
    assert (KnContains(kno, knvas, (Int)x+(w/2), (Int)y+(h/2)));
    assert (KnContains(kno, knvas, x, y));
    assert (KnContains(kno, knvas, x, y + h));
    assert (KnContains(kno, knvas, x + w, y + h));
    assert (KnContains(kno, knvas, x + w, y));

    /* check that points are outside the object */
    assert(! KnContains(kno, knvas, x-1, x));
    assert(! KnContains(kno, knvas, x, y-1));
    assert(! KnContains(kno, knvas, x-1, y + h));
    assert(! KnContains(kno, knvas, x, y+h+1));
    assert(! KnContains(kno, knvas, x+w+1, y + h));
    assert(! KnContains(kno, knvas, x + w, y+h+1));
    assert(! KnContains(kno, knvas, x+w+1, x));
    assert(! KnContains(kno, knvas, x + w, y-1));
    assert(! KnContains(kno, knvas, 0, 0));
}


void
TestObject(KnO kno, Widget knvas, KnPosition x, KnPosition y)
{
    CheckGeometry(knvas, kno, x, y, 1, 1);
    KnResize(knvas, kno, 100.0, 100.0);
    CheckGeometry(knvas, kno, x, y, 100, 100);
    KnMove(knvas, kno, 50, 50);
    CheckGeometry(knvas, kno, 50, 50, 100, 100);
    KnResize(knvas, kno, 0.01, 0.01);
    CheckGeometry(knvas, kno, 50, 50, 1, 1);
    KnResize(knvas, kno, 100.0, 100.0);
    KnMove(knvas, kno, x, y);
    CheckGeometry(knvas, kno, x, y, 100, 100);
}

void
RunTests(Widget knvas, KnO layer)
{
    KnO kno;
    KnPosition x = 10, y = 10;
    
    /* test Rectangles */
    kno = KnCreateRect(knvas, layer, x, y, 1, 1);
    TestObject(kno, knvas, x, y);

    x += 100;
    /* test Filled Rectangles */
    kno = KnCreateFRect(knvas, layer, x, y, 1, 1);
    TestObject(kno, knvas, x, y);

    x += 100;
    /* test Circles */
    kno = KnCreateCircle(knvas, layer, x, y, 1, 1);
    TestObject(kno, knvas, x, y);

    x += 100;
    /* test Filled Circles */
    kno = KnCreateFCircle(knvas, layer, x, y, 1, 1);
    TestObject(kno, knvas, x, y);
    
    x += 100;
    /* test Lines */
    kno = KnCreateLine(knvas, layer, x, y, x+100, y);
}


int
main(int argc, char *argv[])
{
    KnO layer;
    XtAppContext context;
    Widget toplevel, knvas;

    toplevel = XtAppInitialize(&context, "TestSize", 0, 0,
			       &argc, argv, fallbacks, 0, 0);

    knvas = 
	XtVaCreateManagedWidget("test_rect", knvasWidgetClass, toplevel,
				NULL);

    layer = KnCreateLayer(knvas);

    XtRealizeWidget(toplevel);
    
    RunTests(knvas, layer);
    
    KnAppMainLoop(context);
}
