/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
static char rcsid[]="$Id: sample.c,v 1.6.1.8 94/11/09 21:25:47 leon Exp $";

#include <Kn/Knvas.h>
#include <Xm/PushB.h>


void Zoom(Widget knvas, XtPointer client, XEvent*ev, Boolean*cont)
{
    static int w = 0;
    static int h = 0;
    XAnyEvent *e = (XAnyEvent *)ev;
    if(e->type == MapNotify) {
	XMapEvent *me = (XMapEvent *)e;
	XWindowAttributes a;
	XGetWindowAttributes(me->display, me->window, &a);
	w = a.width;
	h = a.height;
	fprintf(stderr, "map %d %d\n", w, h);
	
    }
    if(e->type == ConfigureNotify) {
	XConfigureEvent *me = (XConfigureEvent *)e;
	if((me->width != w) || (me->height != h)) {
	    float rx, ry;
	    rx = (float)me->width / (float)w;
	    ry = (float)me->height / (float)h;
	    fprintf(stderr, "configure %d %d\n", w, h);
	    KnvasZoom(knvas, rx, ry);
	    KnvasUpdateDisplay(knvas);
	    w = me->width;
	    h = me->height;
	}
    }
    *cont = True;		/* continue to dispatch */
}


int
main(int argc, char *argv[])
{
    XtAppContext context;
    Widget toplevel, knvas;
    KnO layer, kno, rect;
    KnTag green, red;
    KnInteractor mi;

    toplevel = XtAppInitialize(&context, "One", 0, 0, &argc, argv, 0, 0, 0);

    knvas = KnCreateKnvas(toplevel, "one", NULL, 0);
    XtAddEventHandler(knvas, StructureNotifyMask, False, Zoom, 0);

    green = KnCreateTag(knvas, "green");
    red = KnCreateTag(knvas, "red");
    
    layer = KnCreateLayer(knvas);

    rect = KnCreateFRect(knvas, layer, 100, 100, 64, 64);
    mi = KnCreateMoveInteractor(knvas, "move1");
    KnSetInteractor(knvas, rect, mi);
    KnSetTag(knvas, rect, green);

    KnCreateFRect(knvas, layer, 150, 150, 64, 64);

    kno = KnCreateCircle(knvas, layer, 150, 250, 64, 64);
    KnSetInteractor(knvas, kno, mi);

    kno = KnCreateFCircle(knvas, layer, 250, 250, 64, 64);
    KnSetInteractor(knvas, kno, mi);
    
    XtManageChild(knvas);
    XtRealizeWidget(toplevel);
    XtAppMainLoop(context);
}
