/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
static char rcsid[]="$Id: sample.c,v 1.6.1.8 94/11/09 21:25:47 leon Exp $";

#include <Kn/Knvas.h>
#include <Xm/PushB.h>

KnO rect;

void
ToggleMapCB(Widget w, XtPointer client, XtPointer call)
{
    static int mapped = 1;
    Widget knvas = (Widget)client;
    
    if( mapped )
	{
	    mapped = 0;
	    KnUnmap( knvas, rect );
	    KnvasUpdateLayers( knvas );
	}
    else
	{
	    mapped = 1;
	    KnMap( knvas, rect );
	    KnvasUpdateDisplay( knvas );
	}
}
int
main(int argc, char *argv[])
{
    XtAppContext context;
    Widget toplevel, knvas, b;
    KnO layer, kno;
    KnTag green, red;
    KnInteractor mi;

    toplevel = XtAppInitialize(&context, "One", 0, 0, &argc, argv, 0, 0, 0);

    knvas = KnCreateKnvas(toplevel, "one", NULL, 0);

    b = XmCreatePushButton(knvas, "Toggle map", NULL, 0);
    XtManageChild(b);
    XtAddCallback(b, XmNactivateCallback, ToggleMapCB, knvas);
    
    green = KnCreateTag(knvas, "green");

    
    layer = KnCreateLayer(knvas);

    rect = KnCreateFRect(knvas, layer, 100, 100, 64, 64);
    mi = KnCreateMoveInteractor(knvas, "move1");
    KnSetInteractor(knvas, rect, mi);
    KnSetTag(knvas, rect, green);

    KnCreateFRect(knvas, layer, 150, 150, 64, 64);

    kno = KnCreateCircle(knvas, layer, 150, 250, 64, 64);
    KnSetInteractor(knvas, kno, mi);

    kno = KnCreateFCircle(knvas, layer, 250, 250, 64, 64);
    KnSetInteractor(knvas, kno, mi);
    
    XtManageChild(knvas);
    XtRealizeWidget(toplevel);

    XtAppMainLoop(context);
}
