/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: graph.c,v 1.2 96/01/04 12:37:26 leon Exp $ */


/* Demonstrate simple graph handling and interaction modifications */

#define SIZE 20
#define SIZE2 10

#include <Kn/Knvas.h>

KnO xhairrh, xhairlh, xhairlv, xhairrv;


void
BuggyCB(Widget knvas, XtPointer client, XtPointer call)
{
    KnPosition x, y, dx=0, dy=0;
    InteractorCallbackStruct *cs = (InteractorCallbackStruct *)call;

    KnGetPosition(knvas, cs->target, &x, &y);
    KnMove(knvas, xhairrh, y-20,  x);
    KnMove(knvas, xhairlh,  y, x-20);
    KnMove(knvas, xhairlv, x-20, y-20);
}

void
CheckMoveCB(Widget knvas, XtPointer client, XtPointer call)
{
    KnPosition x, y, dx=0, dy=0;
    InteractorCallbackStruct *cs = (InteractorCallbackStruct *)call;

	KnGetPosition(knvas, cs->target, &x, &y);
	if(x < 0) dx=-x;
	if(y < 0) dy=-y;
	if(dx || dy) {
	    KnTranslate(knvas, cs->target, dx, dy);
	}
}


int
main(int argc, char *argv[])
{
    XtAppContext context;
    Widget toplevel, knvas;
    KnO front, back, *rects, l;
    KnO *anchors;
    KnTag node1, node2, edge;
    KnInteractor mi;
    int num, i, j;

    if(argc < 2) {
	fprintf(stderr, "usage: graph <num nodes>\n");
	exit(1);
    }
    num = atoi(argv[1]);
    rects = (KnO*)XtMalloc(sizeof(KnO)* num);
    anchors = (KnO*)XtMalloc(sizeof(KnO)* num);

    
    toplevel = XtAppInitialize(&context, "Graph", 0, 0, &argc, argv, 0, 0, 0);

    knvas = KnCreateKnvas(toplevel, "grapher", NULL, 0);
    back = KnCreateLayer(knvas);
    front = KnCreateLayer(knvas);
    mi = KnCreateMoveInteractor(knvas, "move1");

    
    node1 = KnCreateTag(knvas, "node1");
    node2 = KnCreateTag(knvas, "node2");
    edge = KnCreateTag(knvas, "edge");
    for(i = 0; i < num; i++) {
	rects[i] =
	    KnCreateFRect(knvas, front, SIZE*i+SIZE, SIZE*i+SIZE, SIZE, SIZE);
	KnSetTag(knvas, rects[i], (i%2)?node1:node2);

	anchors[i] =
	    KnCreateAnchor(knvas, back, SIZE*i+SIZE+SIZE2, SIZE*i+SIZE+SIZE2, False);
	KnSetInteractor(knvas, rects[i], mi);
	KnAttach(knvas, rects[i], (KnAnchor)anchors[i]);
    }
    for(i = 0; i < num; i++) {
	for(j = i+1; j < num; j++) {
	    l = KnCreateLink(knvas, back, anchors[i], anchors[j]);
	    KnSetTag(knvas, l, edge);
	}
    }
    {
	/* test interactions on groups */
	KnO r;
	l = KnCreateGroup(knvas, front, 100, 100);
	r = KnCreateFRect(knvas, l, 0, 0, 100, 20);
	KnCreateLabel(knvas, l, 2, 2, "Hello world!");
	KnSetTag(knvas, r, node2);
	KnSetInteractor(knvas, l, mi);
    }
    {
	/* test interractions on anchors */
	KnO a1, a2;
	
	a1 = KnCreateAnchor(knvas, front, 50 , 50, False);
	a2 = KnCreateAnchor(knvas, front, 80 , 80, False);
	KnCreateLink(knvas, back, a1, a2);
	KnSetInteractor(knvas, a1, mi);
	KnSetInteractor(knvas, a2, mi);

	
    }
    {
	/* test a weird bug */
	 xhairrh = KnCreateAnchor(knvas, front, 300 , 300, False);
	 xhairlh = KnCreateAnchor(knvas, front, 310 , 310, False);
	 xhairlv = KnCreateAnchor(knvas, front, 320 , 320, False);
	 xhairrv = KnCreateAnchor(knvas, front, 330 , 330, False);
	 KnSetInteractor(knvas, xhairrv, mi);
	 KnCreateLink(knvas, back, xhairrv, xhairlv);
	 KnCreateLink(knvas, back, xhairrh, xhairlh);
	 KnAddCallback(knvas, xhairrv, XtNinteractorCallback, BuggyCB, 0);

    }
    XtAddCallback(knvas, XtNinteractorCallback, CheckMoveCB, 0);

    {
	KnO drawi = KnCreateDrawInteractor(knvas, KnMIDDLE);
	KnvasAddInteractor(knvas, drawi);
    }
    
    XtManageChild(knvas);
    XtRealizeWidget(toplevel);

    XtAppMainLoop(context);
}
