static char rcsid[]="$Id: elec.c,v 1.4 96/01/04 12:37:23 leon Exp $";
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/CascadeB.h>
#include <Xm/MainW.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#if (XtSpecificationRelease >= 5)
#include <X11/Xmu/Editres.h>
#endif
#include <stdio.h>
#include <Kn/Knvas.h>


/* use fallbacks so that demos will always have a nice look */
static String 
fallbacks[] = {
    "*visibleSelection: True",
    "*KnTag.shadowThickness: 8",
    "*geometry: 500x300+400+200",
    "*.background: grey",
    "*allowShellResize: True",
    "*toolsM.radioBehavior: True",
    "*toolsM.radioAlwaysOne: True",
    "*visibleWhenOff: True",
    "*indicatorSize: 12",
    "*selectColor: green",
    "*Knvas.translations: #override\n <Key>i: KnvasZoom(2, 2)\n <Key>o: KnvasZoom(0.5, 0.5)",
    "*file.labelString: File",
    "*file.mnemonic: F",
    "*open.sensitive: False",
    "*open.labelString: Open...",
    "*open.mnemonic: O",
    "*open.accelerator: Ctrl<Key>O",
    "*open.acceleratorText: ^O",
    "*save.labelString: Save...",
    "*save.sensitive: False",
    "*save.mnemonic: S",
    "*save.accelerator: Ctrl<Key>S",
    "*save.acceleratorText: ^S",
    "*quit.labelString: Quit...",
    "*quit.mnemonic: Q",
    "*quit.accelerator: Ctrl<Key>Q",
    "*quit.acceleratorText: ^Q",
    "*tools.labelString: Tools",
    "*tools.mnemonic: T",
    "*point.labelString: Point",
    "*point.mnemonic: P",
    "*point.accelerator: <Key>P",
    "*point.acceleratorText: p",
    "*or.labelString: Or",
    "*or.mnemonic: O",
    "*or.accelerator: <Key>O",
    "*or.acceleratorText: o",
    "*or.set: True",
    "*and.labelString: And",
    "*and.mnemonic: A",
    "*and.accelerator: <Key>A",
    "*and.acceleratorText: a",
    "*options.labelString: Options",
    "*options.mnemonic: O",
    "*buffering.labelString: Double Buffering",
    "*buffering.set: True",
    "*pixmapBuffering: True",
    "*view.labelString: View",
    "*view.mnemonic: V",
    "*zoomin.labelString: Zoom In",
    "*zoomin.mnemonic: I",
    "*zoomin.accelerator: Ctrl<Key>i",
    "*zoomin.acceleratorText: ^i",
    "*zoomout.labelString: Zoom Out",
    "*zoomout.mnemonic: O",
    "*zoomout.accelerator: Ctrl<Key>o",
    "*zoomout.acceleratorText: ^O",
    "*help.labelString: Help",
    "*help.mnemonic: H",
    "*index.labelString: Index",
    "*index.mnemonic: I",
    "*context.labelString: On context",
    "*context.mnemonic: O",
    "*version.labelString: Version",
    "*version.mnemonic: V",
    "*index.sensitive: false",
    "*context.sensitive: false",
    "*version.sensitive: false",
    "*fontList: lucidasans-bold-12",
    "*XmPushButton.highlightThickness: 0",
    "*tools.entryAlignment: ALIGNMENT_CENTER",
    "*tools.spacing: 0",
    "*tools.marginHeight: 2",
    "*tools.marginWidth: 2",
    "*toolsf.bottomAttachment: ATTACH_FORM",
    "*toolsf.topAttachment: ATTACH_FORM",
    "*toolsf.leftAttachment: ATTACH_FORM",
    "*toolsf.topOffset: 2",
    "*toolsf.bottomOffset: 2",
    "*toolsf.leftOffset: 2",
    "*toolsrc.entryAlignment: ALIGNMENT_CENTER",
    "*drawf.shadowType: SHADOW_IN",
    "*drawf.bottomAttachment: ATTACH_FORM",
    "*drawf.topAttachment: ATTACH_FORM",
    "*drawf.rightAttachment: ATTACH_FORM",
    "*drawf.topOffset: 2",
    "*drawf.bottomOffset: 2",
    "*drawf.rightOffset: 2",
    "*drawf.left: 2",
    "*draw.cursor: cross",
    "*toolsrc.XmPushButton.translations: #replace\n <Btn1Down>: Arm(), Activate()\n ",
    "*ex3.background: ivory",
    NULL
};


Widget toplevel, mainw, menubar, form, toolsrc, toolsf, drawf, draw;
Widget fileM, helpM, editM, toolsM, viewM, optM, file, help;

#define TOOL_POINT 0
#define TOOL_OR 1
#define TOOL_AND 2

Widget tools[3];
Widget toolsmi[3];
int tool;

KnO layer1, layer2;
KnInteractor movei, drawi;

static void
DrawCB(Widget knvas, XtPointer client, XtPointer call)
{
    static KnO source = NULL;
    InteractorCallbackStruct *cs = (InteractorCallbackStruct *)call;
    if(KnCR_PICK == cs->reason) {
	if(cs->target)
	    source = cs->target;
	return;
    }
    if(KnCR_DROP == cs->reason) {
	if(source) {
	    KnO kno;
	    if(NULL == cs->target) return;
	    if(cs->target != source) {
		if(! KlIsOfType(source, KnAnchorClass)) {
		    fprintf(stderr, "source not an anchor\n");
		    return;
		}
		if(! KlIsOfType(cs->target, KnAnchorClass)) {
		    fprintf(stderr, "target not an anchor\n");
		    return;
		}
		kno = 
		    KnCreateLink(knvas, layer1, source, cs->target);
		KnClear(knvas, kno);
		source = NULL;
	    }
	}
	else {
	    KnO kno;
	    switch(tool) {
	    case TOOL_OR:
		kno = KnCreateIcon(knvas, layer2, "or", cs->tox, cs->toy);
		KnSetInteractor(knvas, kno, movei);
		break;
	    case TOOL_AND:
		kno = KnCreateIcon(knvas, layer2, "and", cs->tox, cs->toy);
		KnSetInteractor(knvas, kno, movei);
		break;
	    default:
		kno = KnCreateAnchor(knvas, layer2, cs->tox, cs->toy, True);
		KnSetInteractor(knvas, kno, movei);
	    }
	    KnClear(knvas, kno);
	    source = NULL;
	}
    }
}

void
BufferingCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmToggleButtonCallbackStruct *cs
	= (XmToggleButtonCallbackStruct *)call_data;
    XtVaSetValues(draw, XtNpixmapBuffering, cs->set, NULL);
}
void
UseGhostsCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmToggleButtonCallbackStruct *cs
	= (XmToggleButtonCallbackStruct *)call_data;
    movei->useGhosts = cs->set;
}

void
ZoomCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    if(client_data)
	KnvasZoom(draw, 2.0, 2.0);
    else
	KnvasZoom(draw, 0.5, 0.5);
}

void
ChangeToolCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    static Widget  toolw = (Widget)NULL;
    static Widget  toolmiw = (Widget)NULL;

    tool = (int)client_data;

    if(toolw) 
	XtCallActionProc(toolw, "Disarm", NULL, NULL, NULL);

    if(toolmiw)
	XmToggleButtonSetState(toolmiw, False, False);

    toolw = tools[tool];
    toolmiw = toolsmi[tool];
    XtCallActionProc(toolw, "Arm", NULL, NULL, NULL);
    if(toolmiw != w) {
	/* action comes from tool bar */
	XmToggleButtonSetState(toolmiw, True, False);
    }
}



static void
PixmapizeButton(Widget button, char *name)
{
    Pixel color, armcolor;
    PCachePixmap pixmap, armpixmap;
    XpmColorSymbol colors, armcolors;
    PCacheAttributesStruct values;
    
    armcolors.name = colors.name = NULL;
    armcolors.value = colors.value = "none";
    values.valuemask = PCACHE_SYM_COLORS;
    values.nsymcolors = 1;
    
    XtVaGetValues(button,
		  XmNbackground, &color,
		  XmNarmColor, &armcolor,
		  NULL);
    colors.pixel = color;
    values.symcolors = &colors;
    pixmap = PCacheGetPixmap(name, XtScreen(button), &values);
    armcolors.pixel = armcolor;
    values.symcolors = &armcolors;
    armpixmap = PCacheGetPixmap(name, XtScreen(button), &values);
    XtVaSetValues(button,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, pixmap->pixmap,
		  XmNarmPixmap, armpixmap->pixmap,
		  NULL);
}


void
main(int argc, char* argv[])
{
    XtAppContext app_context;
    Widget tmp;
    Arg args[16];
    int n = 0;
    Colormap colormap;
    Display *dpy;


    toplevel = XtAppInitialize(&app_context, "KElec", 
			       NULL, 0,
			       &argc, argv, fallbacks, 0, 0);
    dpy = XtDisplay(toplevel);

#if (XtSpecificationRelease >= 5)
    XtAddEventHandler(toplevel, 0, True, _XEditResCheckMessages, NULL);
#endif
    mainw = XmCreateMainWindow(toplevel, "mainw", args, n);

    menubar = XmCreateMenuBar(mainw, "menubar", 0, 0);
    form = XmCreateForm(mainw, "form", 0, 0);
    toolsf = XmCreateFrame(form, "toolsf", 0, 0);
    XtManageChild(toolsf);
    toolsrc = XmCreateRowColumn(toolsf, "toolsrc", 0, 0);

    XtManageChild(tmp=XmCreatePushButton(toolsrc, "point", 0, 0));
    PixmapizeButton(tmp, "anchor2");
    tools[TOOL_POINT] = tmp;
    XtAddCallback(tmp, XmNactivateCallback, ChangeToolCB, 
		  (XtPointer)TOOL_POINT);

    XtManageChild(tmp=XmCreatePushButton(toolsrc, "or", 0, 0));
    tools[TOOL_OR] = tmp;
    PixmapizeButton(tmp, "or");
    XtAddCallback(tmp, XmNactivateCallback, ChangeToolCB, 
		  (XtPointer)TOOL_OR);

    XtManageChild(tmp=XmCreatePushButton(toolsrc, "and", 0, 0));
    tools[TOOL_AND] = tmp;
    PixmapizeButton(tmp, "and");
    XtAddCallback(tmp, XmNactivateCallback, ChangeToolCB, 
		  (XtPointer)TOOL_AND);

    XtManageChild(toolsrc);
    fileM = XmCreatePulldownMenu(menubar, "fileM", 0, 0);
    helpM = XmCreatePulldownMenu(menubar, "helpM", 0, 0);
    toolsM = XmCreatePulldownMenu(menubar, "toolsM", 0, 0);
    optM = XmCreatePulldownMenu(menubar, "optM", 0, 0);
    viewM = XmCreatePulldownMenu(menubar, "viewM", 0, 0);
    
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, fileM); n++;
    XtManageChild(XmCreateCascadeButton(menubar, "file", args, n));
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, toolsM); n++;
    XtManageChild(XmCreateCascadeButton(menubar, "tools", args, n));
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, optM); n++;
    XtManageChild(XmCreateCascadeButton(menubar, "options", args, n));
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, viewM); n++;
    XtManageChild(XmCreateCascadeButton(menubar, "view", args, n));
    
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, helpM); n++;
    XtManageChild(tmp=XmCreateCascadeButton(menubar, "help", args, n));
    XtVaSetValues(menubar, 
		  XmNmenuHelpWidget, tmp,
		  NULL);

    /* File menu items */
    XtManageChild(tmp=XmCreatePushButton(fileM, "open", 0, 0));

    XtManageChild(tmp=XmCreatePushButton(fileM, "save", 0, 0));

    XtManageChild(tmp=XmCreateSeparator(fileM, "s1", 0, 0));
    XtManageChild(tmp=XmCreatePushButton(fileM, "quit", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, (XtCallbackProc)exit, 0);


    /* Tools menu items */
    XtManageChild(tmp=XmCreateToggleButtonGadget(toolsM, "point", 0, 0));
    toolsmi[TOOL_POINT] = tmp;
    XtAddCallback(tmp, XmNvalueChangedCallback, ChangeToolCB, 
		  (XtPointer)TOOL_POINT);
    XtManageChild(tmp=XmCreateToggleButtonGadget(toolsM, "or", 0, 0));
    toolsmi[TOOL_OR] = tmp;
    XtAddCallback(tmp, XmNvalueChangedCallback, ChangeToolCB, 
		  (XtPointer)TOOL_OR);
    XtManageChild(tmp=XmCreateToggleButtonGadget(toolsM, "and", 0, 0));
    toolsmi[TOOL_AND] = tmp;
    XtAddCallback(tmp, XmNvalueChangedCallback, ChangeToolCB, 
		  (XtPointer)TOOL_AND);


    /* Options menu items */
    XtManageChild(tmp=XmCreateToggleButtonGadget(optM, "buffering", 0, 0));
    XtAddCallback(tmp, XmNvalueChangedCallback, BufferingCB, 0);
    /*
    XtManageChild(tmp=XmCreateToggleButtonGadget(optM, "useghosts", 0, 0));
    XtAddCallback(tmp, XmNvalueChangedCallback, UseGhostsCB, 0);
    */

    /* View menu items */
    XtManageChild(tmp=XmCreatePushButtonGadget(viewM, "zoomin", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, ZoomCB, (XtPointer)True);
    XtManageChild(tmp=XmCreatePushButtonGadget(viewM, "zoomout", 0, 0));
    XtAddCallback(tmp, XmNactivateCallback, ZoomCB, False);

    /* Help menu items */
    XtManageChild(tmp=XmCreatePushButton(helpM, "index", 0, 0));
    XtManageChild(tmp=XmCreatePushButton(helpM, "context", 0, 0));
    XtManageChild(tmp=XmCreateSeparator(helpM, "context", 0, 0));
    XtManageChild(tmp=XmCreatePushButton(helpM, "version", 0, 0));

    drawf = XmCreateFrame(form, "drawf", 0, 0);
    XtVaSetValues(drawf,
		  XmNleftAttachment, XmATTACH_WIDGET,
		  XmNleftWidget, toolsf,
		  NULL, NULL);
    draw = 
	XtVaCreateManagedWidget("ex3", knvasWidgetClass, drawf,
				NULL);
    XtAddCallback(draw, XtNknvasCallback, DrawCB, 0);
    layer1 = KnCreateLayer(draw);
    layer2 = KnCreateLayer(draw);
    movei = KnCreateMoveInteractor(draw, "move");
    /* the draw interactor is EXPERIMENTAL */
    drawi = KnCreateDrawInteractor(draw, KnMIDDLE);
    KnvasAddInteractor(draw, drawi);
    
    XtManageChild(drawf);

    XtManageChild(menubar);
    XtManageChild(mainw);
    XtManageChild(form);

    XtRealizeWidget(toplevel);
    XtCallCallbacks(toolsmi[TOOL_OR], XmNvalueChangedCallback, 0);
    KnAppMainLoop(app_context);
}
