/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
static char rcsid[]="$Id: destroy.c,v 1.1 95/03/14 16:41:47 leon Exp $";


/* tests Knvas Destruction */


#include <Kn/Knvas.h>
#include <stdlib.h>


void
DestroyCB(Widget wid, XtPointer client, XtPointer call);

void
ExitCB(Widget wid, XtPointer client, XtPointer call)
{
    XtDestroyWidget(wid);
    KlZrtGc(0);
    exit(0);
}


void BuildScene(Widget toplevel)
{
    static int n = 1;
    char label[16];
    Widget knvas;
    KnO rect, layer, lquit, kno;
    KnTag green, red;
    KnInteractor mi, ri;
    

    knvas = KnCreateKnvas(toplevel, "one", NULL, 0);

    green = KnCreateTag(knvas, "green");

    
    layer = KnCreateLayer(knvas);

    rect = KnCreateFRect(knvas, layer, 100, 100, 64, 64);
    mi = KnCreateMoveInteractor(knvas, "move1");
    ri = KnCreateMoveInteractor(knvas, "resize1");
    KnSetInteractor(knvas, rect, mi);
    KnSetTag(knvas, rect, green);
    KnAddCallback(knvas, rect, XtNinteractorCallback, DestroyCB, 0);

    sprintf(label, "knvas %d", n++);
    KnCreateLabel(knvas, layer, 150, 120, label);
    KnCreateFRect(knvas, layer, 150, 150, 64, 64);

    lquit = KnCreateLabel(knvas, layer, 50, 20, "EXIT");
    KnSetInteractor(knvas, lquit, mi);
    KnAddCallback(knvas, lquit, XtNinteractorCallback, ExitCB, 0);

    

    kno = KnCreateIcon(knvas, layer, "king", 200, 200);
    KnSetInteractor(knvas, kno, mi);


    kno = KnCreateCircle(knvas, layer, 200, 400, 50, 50);
    KnSetInteractor(knvas, kno, mi);



    kno = KnCreateFCircle(knvas, layer, 200, 300, 50, 50);
    KnSetInteractor(knvas, kno, ri);

    {
	KnO a1, a2;
	a1 = KnCreateAnchor(knvas, layer, 100, 200, True);
	a2 = KnCreateAnchor(knvas, layer, 300, 300, True);
	kno = KnCreateLink(knvas, layer, a1, a2);
	KnSetInteractor(knvas, kno, mi);
    }

    
    XtManageChild(knvas);
}



void
DestroyCB(Widget wid, XtPointer client, XtPointer call)
{
    XtDestroyWidget(wid);
    BuildScene(XtParent(wid));
}





int
main(int argc, char *argv[])
{
    XtAppContext context;
    Widget toplevel;

    toplevel = XtAppInitialize(&context, "KSample", 0, 0, &argc,
			       argv, 0, 0, 0);

    BuildScene(toplevel);

    XtRealizeWidget(toplevel);

    KnAppMainLoop(context);
}
