/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: deep.c,v 1.1 95/03/14 16:55:08 leon Exp $ */




#include <Kn/Knvas.h>



KnTag blue, red;


void
pickCallback(Widget wid, XtPointer client, XtPointer call)
{
    KnTag tag;
    InteractorCallbackStruct *cs = (InteractorCallbackStruct *)call;
    
    if(KnCR_PICK == cs->reason) {
	tag = KnGetTag(wid, cs->target);
	if(tag == blue) {
	    KnSetTag(wid, cs->target, red);
	}
	else {
	    KnSetTag(wid, cs->target, blue);
	}
    }
}


void
makeSubGraphics(Widget knvas, int maxdepth, int number,
		KnO parent, int depth)
{
#define OSIZE 15

    Position y = depth * OSIZE;
    int i;
    char buf[BUFSIZ];
    KnO rect, group;

    buf[0] = '\0';
    group = KnCreateGroup(knvas, parent, 0, 0);
    for (i = 0; i < number; i++) {
	Position x = i * OSIZE;

#ifdef RECT
	rect = KnCreateFRect(knvas, group, x, y, OSIZE, OSIZE);
#else
	sprintf(buf, "%d", i);
	rect = KnCreateLabel(knvas, group, x, y, buf);
#endif
/*	KnSetInteractor(knvas, rect, click);  */
	if (depth % 2 ^ i % 2)
	    KnSetTag(knvas, rect, red);
	else
	    KnSetTag(knvas, rect, blue);
    }
    if (depth < maxdepth)
	makeSubGraphics(knvas, maxdepth, number, group, depth + 1);
}

void
makeGraphics(Widget knvas, KnO layer, int maxdepth, int number)
{
    makeSubGraphics(knvas, maxdepth - 1, number, layer, 0);
}



void
moveCallback(Widget knvas, XtPointer client, XtPointer call)
{
    KnLayer layer = (KnLayer)client;
    int i;

    for(i = 0; i < layer->children->size; i++) {
	KnTranslate(knvas, (KnO)layer->children->list[i], 0, OSIZE);
    }
}


void
PickOrMoveCB(Widget knvas, XtPointer client, XtPointer call)
{
    InteractorCallbackStruct *cs = (InteractorCallbackStruct *)call;

    if(cs->interactor && (cs->interactor->button == 2)) {
	moveCallback(knvas, client, call);
    }
    else
	pickCallback(knvas, client, call);
    
}

static char translations[] = "\
<Key>q: quit()\n\
";

void
quit(Widget w, XEvent *event, String *params, Cardinal *num)
{
    exit(0);
}


static XtActionsRec
actions[] = {
    "quit",quit,
};



int
main(int argc, char *argv[])
{
    XtAppContext context;
    Widget toplevel, knvas;
    KnO rect, layer;
    KnInteractor click, move;


    if(argc != 3) {
	fprintf(stderr, "deep <height> <width>\n");
	exit(1);
    }

    toplevel = XtAppInitialize(&context, "Flat", 0, 0, &argc, argv, 0, 0, 0);
    XtAppAddActions(context, actions, XtNumber(actions));
    
    knvas = KnCreateKnvas(toplevel, "flat", NULL, 0);

    blue = KnCreateTag(knvas, "blue");
    red = KnCreateTag(knvas, "red");
    click = KnCreateSelectInteractor(knvas, "pick");
    move = KnCreateSelectInteractor(knvas, "move");

    KnvasAddInteractor(knvas, click);
    KnvasAddInteractor(knvas, move);

    layer = KnCreateLayer(knvas);

    makeGraphics(knvas, layer, atoi(argv[1]), atoi(argv[2]));

    
    XtAddCallback(knvas, XtNinteractorCallback, PickOrMoveCB, layer);
    
    XtManageChild(knvas);
    XtRealizeWidget(toplevel);

    XtAppMainLoop(context);
}
