/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
static char rcsid[]="$Id: cchess.c,v 1.9 95/09/25 15:41:22 leon Exp $";
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <stdio.h>
#include <stdlib.h>
#include <Kn/Knvas.h>


/* use fallbacks so that demos will always have a nice look */
static String 
fallbacks[] = {
    "*visibleSelection: True",
    "*white.shadowThickness: 8",
    "*black.shadowThickness: 8",
    "*geometry: 640x640",
    "*background: red",
    "*pixmapBuffering: True",
    "*white.symColors: team=cornsilk",
    "*white.foreground: linen",
    "*black.symColors: team=gray32",
    "*black.foreground: gray62",
    "*brect.foreground: gray62",
    "*wrect.foreground: linen",
NULL
};


Display *dpys[2];
Widget toplevels[2], knvases[2];

static KnInteractor moveI;
static KnTag blacks, whites, tags, brect, wrect;


#define min(a, b) (((a)<(b))?(a):(b))
#define max(a, b) (((a)>(b))?(a):(b))


#define WHITE (1<<0)
#define BLACK (1<<1)
#define KNIGHT (1<<2)
#define BISHOP (1<<3)
#define QUEEN (1<<4)
#define KING (1<<5)
#define PAWN (1<<6)
#define ROOK (1<<7)

typedef unsigned int Piece;
static Piece chessboard[8][8];
static KnO iconboard[8][8];
int player = WHITE;               /* current player */


typedef struct _PieceDescStruct {
    KnO icon;
    Piece id;
    char *name;   /* name of the pixmap file */
    int lookslike; /* if name is NULL, we should duplicate this pixmap */
    int h, v;
} PieceDescStruct;

static PieceDescStruct
blackpieces[] = {
    {0, ROOK, "rook", 0, 0, 0},
    {0, KNIGHT, "knight", 0, 1, 0},
    {0, BISHOP, "bishop", 0, 2, 0},
    {0, QUEEN, "queen", 0,3, 0},
    {0, KING, "king", 0, 4, 0},
    {0, BISHOP, 0, 2, 5, 0},
    {0, KNIGHT, 0, 1, 6, 0},
    {0, ROOK, 0, 0, 7, 0},
    {0, PAWN, "pawn", 0, 0, 1},
    {0, PAWN, 0, 8, 1, 1},
    {0, PAWN, 0, 8, 2, 1},
    {0, PAWN, 0, 8, 3, 1},
    {0, PAWN, 0, 8, 4, 1},
    {0, PAWN, 0, 8, 5, 1},
    {0, PAWN, 0, 8, 6, 1},
    {0, PAWN, 0, 8, 7, 1},
};

static PieceDescStruct
whitepieces[] = {
    {0, ROOK, "rook", 0, 0, 7},
    {0, KNIGHT, "knight", 0, 1, 7},
    {0, BISHOP, "bishop", 0, 2, 7},
    {0, QUEEN, "queen", 0,3, 7},
    {0, KING, "king", 0, 4, 7},
    {0, BISHOP, 0, 2, 5, 7},
    {0, KNIGHT, 0, 1, 6, 7},
    {0, ROOK, 0, 0, 7, 7},
    {0, PAWN, "pawn", 0, 0, 6},
    {0, PAWN, 0, 8, 1, 6},
    {0, PAWN, 0, 8, 2, 6},
    {0, PAWN, 0, 8, 3, 6},
    {0, PAWN, 0, 8, 4, 6},
    {0, PAWN, 0, 8, 5, 6},
    {0, PAWN, 0, 8, 6, 6},
    {0, PAWN, 0, 8, 7, 6},
};


static int oh, ov, dh, dv;

Boolean
FreeMove()
{
    Boolean res = True;
    int i, j;
    if(oh == dh) {
	/* vertical move */
	for(i = min(ov, dv)+1; i < max(ov, dv); i++) {
	    if(chessboard[oh][i] != 0) return False;
	}
	return True;
    }
    if(ov == dv) {
	/* horizontal move */
	for(i = min(oh, dh)+1; i < max(oh, dh); i++) {
	    if(chessboard[i][ov] != 0) return False;
	}
	return True;
    }
    /* diagonal move */
    for(i = oh + ((dh>oh)?1:-1), j = ov + ((dv>ov)?1:-1);
	i != dh; i += ((dh>oh)?1:-1), j += ((dv>ov)?1:-1)) {
	if(chessboard[i][j] != 0) return False;
    }
    return True;
    
}


Boolean
LegalMove()
{
    /* is (oh, ov) to (dh, dv) a legal chess move ? */
    Piece p;

    /* be sure we stay inside the chess board */
    if((dh <0) || (dv < 0) || (dh > 7) || (dv > 7)) {
	return False;
    }
    p = chessboard[oh][ov];

    if(p & KING) 
	return ((abs(dh-oh) + abs(dv-ov)) == 1);

    if(p & KNIGHT)
	return ((abs(dh-oh) + abs(dv-ov)) == 3);

    if(p & BISHOP)
	return FreeMove() && (abs(dh-oh) == abs(dv-ov));

    if(p & ROOK)
	return FreeMove() && ((dh-oh) ? ((dv-ov)==0) : ((dv-ov)!=0));

    if(p & QUEEN) {
	if(!FreeMove()) return False;
	if(oh == dh) return (ov != dv);
	if(ov == dv) return (oh != dh);
	return (abs(dh-oh) == abs(dv-ov));
    }

    if(p & PAWN) {
	if(chessboard[oh][ov] & BLACK) {
	    if((ov == 1) && (dv == 3)) 
		/* first move */
		return (dh == oh) && FreeMove();
	    if(oh != dh) 
		/* take */
		return ((abs(dh-oh) == 1) &&  (dv-ov == 1) 
		    && chessboard[dh][dv] & WHITE);
	    return ((dv-ov) == 1) && (chessboard[dh][dv] == 0);
	}
	else {
	    if((ov == 6) && (dv == 4)) 
		/* first move */
		return (dh == oh) && FreeMove();
	    if(oh != dh) 
		/* take */
		return ((abs(dh-oh) == 1) &&  (dv-ov == -1) 
		    && chessboard[dh][dv] & BLACK);
	    return ((dv-ov) == -1) && (chessboard[dh][dv] == 0);
	    
	}
    }

    return True;
}

void
PickCB(Widget w, XtPointer client, XtPointer call)
{
    InteractorCallbackStruct *cs = (InteractorCallbackStruct *)call;

    oh = cs->tox / 80;
    ov = cs->toy / 80;
    if(!(chessboard[oh][ov] & player)) {
	/* cannot move other player's pieces */
	cs->accept = False;
    }
}


void
PlayCB(Widget w, XtPointer client, XtPointer call)
{
    InteractorCallbackStruct *cs = (InteractorCallbackStruct *)call;
    int odpy = (w == knvases[0]) ? 1 : 0;

    /* we must unselect a played object */
    cs->select = False;

    dh = cs->tox / 80;
    dv = cs->toy / 80;

    if((oh == dh) && (ov == dv)) {
	/* cancelled action, drop back */
	cs->tox = oh * 80 + 8;
	cs->toy = ov * 80 + 8;
	return;
    }
    if((!(chessboard[dh][dv] & player) || (!chessboard[oh][ov]))){ 
	if(LegalMove()) {
	    /* center Piece */
	    cs->tox = dh * 80 + 8;
	    cs->toy = dv * 80 + 8;

	    if(chessboard[dh][dv]) {
		/* take: remove piece */
		KnUnmap(w, (KnO)iconboard[dh][dv]);
	    }
            /* update chessboard */
	    chessboard[dh][dv] = chessboard[oh][ov];
	    iconboard[dh][dv] = iconboard[oh][ov];
	    chessboard[oh][ov] = 0;
	    iconboard[oh][ov] = 0;

	    /* set turn */
	    player = (player == WHITE) ? BLACK : WHITE;
	    XtSetSensitive(w, False);
	    XtSetSensitive(knvases[odpy], True);
	}
	else {
	    /* ilegal move */
	    cs->tox = oh * 80 + 8;
	    cs->toy = ov * 80 + 8;
	    return;
	}
    }
    else {
	/* ilegal move */
	    cs->tox = oh * 80 + 8;
	    cs->toy = ov * 80 + 8;
	    return;
    }
}



void
PickAndPlayCB(Widget w, XtPointer client, XtPointer call)
{
    InteractorCallbackStruct *cs = (InteractorCallbackStruct *)call;
    if(KnCR_PICK == cs->reason) {
	PickCB(w, client, call);
    }
    if(KnCR_DROP == cs->reason) {
	PlayCB(w, client, call);
    }
}



void
BuildIconBoards(KnO layer, int tn, PieceDescStruct *team)
{
    int p;
    for(p = 0; p < 16; p++) {
	if(team[p].name) {
	    team[p].icon = 
		KnCreateIcon(knvases[0], layer, team[p].name, 0, 0);
	    KnSetInteractor(knvases[0], team[p].icon, moveI);
	    KnAddCallback(knvases[0],team[p].icon, 
			     XtNinteractorCallback, PickAndPlayCB, 0);
	}
	else {
	    /* WARNING: WE SHOULD NOT RELY ON OBJECT'S COPY !!! */
	    team[p].icon = (KnO)KlSend_copy(team[team[p].lookslike].icon);
	    KnAddCallback(knvases[0],team[p].icon, 
			     XtNinteractorCallback, PickAndPlayCB, 0);   
	    KnGroupAdd((KnGroup)layer, team[p].icon);
	}
	chessboard[team[p].h][team[p].v] = tn | team[p].id;
	team[p].icon->x =  team[p].h*80 + 8;
	team[p].icon->y =  team[p].v*80 + 8;
	iconboard[team[p].h][team[p].v] = team[p].icon;
    }
}




int
main(int argc, char *argv[])
{    
    XtAppContext app_context;
    int h, v, p, i;
    KnO r;
    KnO layer;

    char fullname[256];

    
    if(argc != 3) {
	fprintf(stderr, "Usage: cchess <dpy1> <dpy2>\n");
	exit(1);
    }

    XtToolkitInitialize();
    app_context = XtCreateApplicationContext();
    XtAppSetFallbackResources(app_context, fallbacks);
    for(i = 0; i <2; i++) {
	char name[8];
	dpys[i] = 
	    XtOpenDisplay(app_context, argv[i+1], argv[0],
			  "KChess", 0, 0, &argc, argv);
	if(NULL == dpys[i]) {
	    fprintf(stderr, "Cannot open display '%s'\n", argv[i+1]);
	    exit(1);
	}
	sprintf(name, "cchess%d", i);
	toplevels[i] = 
	    XtAppCreateShell(name, "KChess", applicationShellWidgetClass,
			     dpys[i], 0, 0);
	knvases[i] = 
	    XtVaCreateManagedWidget("knvas", knvasWidgetClass, toplevels[i],
				    NULL);

    }

    XtRealizeWidget(toplevels[0]);
    XtRealizeWidget(toplevels[1]);

    blacks = KnCreateTag(knvases[0], "black");
    whites = KnCreateTag(knvases[0], "white");
    brect = KnCreateTag(knvases[0], "brect");
    wrect = KnCreateTag(knvases[0], "wrect");
    /* hack for multi-display */
    KnCreateTag(knvases[1], "black");
    KnCreateTag(knvases[1], "white");
    KnCreateTag(knvases[1], "brect");
    KnCreateTag(knvases[1], "wrect");

    moveI = KnCreateMoveInteractor(knvases[0], "move");
    layer = KnCreateLayer(knvases[0]);
    KnvasShareLayer(knvases[1], (KnLayer)layer);
    for(h = 0; h < 8; h++ ){
	for(v = 0; v < 8; v++) {
	    r = KnCreateFRect(knvases[0], layer, h*80, v*80, 80, 80);
	    KnSetTag(knvases[0], r, ((h+v)%2) ? brect : wrect);
	}
    }
    KnvasSetDefaultTag(knvases[0], whites);
    BuildIconBoards(layer, WHITE, whitepieces);
    KnvasSetDefaultTag(knvases[0], blacks);
    BuildIconBoards(layer, BLACK, blackpieces);

    /* player 0 starts */
    KnvasFlipH(knvases[1], 0, 0, 0);
    XtSetSensitive(knvases[1], False);

    XtAppMainLoop(app_context);
}
