/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
static char rcsid[]="$Id: anim.c,v 1.7 96/01/04 12:37:18 leon Exp $";
#include <stdio.h>
#include <Kn/Knvas.h>


static String 
fallbacks[] = {
    "*pixmapBuffering: True",
    "*geometry: 630x630",
    "*background: grey",
    "*green.foreground: green",
    "*red.foreground: red",
    "*shadowThickness: 2",
    NULL
};


#define OSIZE 30
#define CSIZE 400
#define MAX 8
#define MOVE 2
XtAppContext app_context;
Widget toplevel, knvas;
KnTag green, red;
KnO arcs[MAX];
KnO rects[MAX];
int cmove[MAX];
int rmove[MAX];
int delay = 1;
int count = 2000;


void
Anim(XtPointer client, XtIntervalId *id)
{
    int i;
    KnO c;
    
    if(count == 0) exit();
    
    for(i = 0; i <MAX; i++) {
	c = arcs[i];
	if((c->y + OSIZE <= CSIZE) &&
	   (c->y >= 0)){
	    KnTranslate(knvas, c, 0, cmove[i]);
	}
	else {
	    cmove[i] = -cmove[i];
	    if(c->y < 0)
		KnTranslate(knvas, c, 0, -c->y);
	    else
		KnTranslate(knvas, c, 0, c->y - CSIZE);
	}
	
    }
    for(i = 0; i <MAX; i++) {
	c = rects[i];
	if((c->x + OSIZE <= CSIZE) &&
	   (c->x >= 0)){
	    KnTranslate(knvas, c, rmove[i], 0);
	}
	else {
	    rmove[i] = -rmove[i];
	    if(c->x < 0)
		KnTranslate(knvas, c, -c->x, 0);
	    else
		KnTranslate(knvas, c, c->x - CSIZE, 0);
	}
    }
    KnvasUpdateDisplay(knvas);
    XtAppAddTimeOut(app_context, delay, Anim, 0);
    count--;
}


int
main(int argc, char *argv[])
{
    int i;
    char fullname[256];
    KnO layer;
    
    toplevel = XtAppInitialize(&app_context, "KAnim", 0, 0,
			       &argc, argv, fallbacks, 0, 0);
    knvas = KnCreateKnvas(toplevel, "essai", 0, 0);
    XtManageChild(knvas);
    layer = KnCreateLayer(knvas);

    XtRealizeWidget(toplevel);
    green = KnCreateTag(knvas, "green");
    red = KnCreateTag(knvas, "red");
    KnvasSetDefaultTag(knvas, green);
    for(i = 0; i < MAX; i++) {
	arcs[i] = (KnO)KnCreateFRect(knvas, layer, 10+50*i, 1, 30,30);
	KnSetTag(knvas, arcs[i], green);
	cmove[i] = i+1;
	rects[i] = (KnO)KnCreateFCircle(knvas, layer, 1, 10+50*i, 30,30);
	KnSetTag(knvas, rects[i], red);
	rmove[i] = 2*i+1;
    }
    if(argc > 1) {
	count = atoi(argv[1]);
    }

    XtAppAddTimeOut(app_context, delay, Anim, 0);
    XtAppMainLoop(app_context);
}
