/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: select.c,v 1.3 95/09/25 14:56:49 leon Exp $ */


#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include "misc.h"
#include "interactor.h"
#include "hash.h"
#include "knoP.h"


extern Transformer
GetGlobalTransformer(Widget w, KnO s);

extern void
UnselectAll(Widget w);

char 
selectBehavior[] = "\
 <Btn%dDown>: Select(%s)\n\
 <Btn%dMotion>: SelectDrag(%s)\n\
 <Btn%dUp>: SelectDrop(%s)\n\
"; 






void
SelectProc(Widget w, XEvent *event, String *params, Cardinal *num)
{
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    InteractorCallbackStruct cs;
    Boolean selvisible;    
    Transformer t;
    KnPosition tox, toy;
    KnInteractor mi;


    if(NULL == THIS.target) {
	/* only when interactor is set on knvas */
	UnselectAll(w);
	return;
    }

    THIS.dispatched = True;
    /* grab events until drop */
    THIS.grab = THIS.target;
    if(1 == *num) {
	mi = KnHashtableFind(interactorTable, params[0]);
    }
    else {
	XtAppWarningMsg(XtWidgetToApplicationContext(w),
			invalidParameterCount,
			actionParameters,
			KnvasWarning,
			"Action 'SelectProc' requires 1 parameter",
			NULL, NULL);
	return;
    }
	
    selvisible = mi->visibleSelection;
    cs.e = event;
    cs.interactor = mi;
    cs.target = THIS.target;
    cs.accept = True;
    cs.reason = KnCR_PICK;
    t = GetGlobalTransformer(w, THIS.target);
    TransformerInvTransform(t, event->xbutton.x,  event->xbutton.y, 
			    &tox, &toy);
    XtFree((void*)t);
    cs.tox = tox;
    cs.toy = toy;
    if(! (event->xbutton.state & ShiftMask)) {
	/* Shift not pressed, unselect all widgets */
	UnselectAll(w);
    }
    if(mi->callbackPolicy & KnCALLBACK_ON_PICK) {
	KnCallCallbacks(w, THIS.target, XtNinteractorCallback, (XtPointer)&cs);
	XtCallCallbacks(w, XtNinteractorCallback, (XtPointer)&cs);
    }
    if(! (event->xbutton.state & ShiftMask)) {
	/* Shift not pressed, unselect all widgets */
	UnselectAll(w);
    }
    if(cs.accept) {
	if(! (THIS.target->flags & KnSELECTED_FLAG)) {
	    /* if we were unselected, select us */
	    KnSelect(w, THIS.target, selvisible);
	    KlListAppend(THIS.sobjs, THIS.target);
	}
	else {
	    /* maybe, if this is multiple selection, we are already selected,
	       unselect us */
	    KnUnselect(w, THIS.target);
	    KlListDeleteObj(THIS.sobjs, THIS.target);
	}
    }
    KnvasUpdateLayers(w);
    if(mi->varyCursor) {
	XDefineCursor(XtDisplay(w), XtWindow(w),
		      THIS.cursors[KnCENTER_CURSOR]);
	XFlush(XtDisplay(w));
    }
#undef THIS
}




 void
SelectDragProc(Widget w, XEvent *event, String *params, Cardinal *num)
{
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    InteractorCallbackStruct cs;
    KnInteractor mi;
    Cardinal i;
    KnO kno;

    if(NULL == THIS.target) return;
    THIS.dispatched = True;
    
    if(1 == *num) {
	mi = KnHashtableFind(interactorTable, params[0]);
    }
    else {
	XtAppWarningMsg(XtWidgetToApplicationContext(w),
			invalidParameterCount,
			actionParameters,
			KnvasWarning,
			"Action 'SelectDragProc' requires 1 parameter",
			NULL, NULL);
	return;
    }
    
    cs.e = event;
    cs.interactor = mi;
    cs.target = THIS.target;
    cs.reason = KnCR_DRAG;
    if(0 == THIS.sobjs->size) 
	/* Move has no effect if there is no selected obj */
	return;
    
    for(i = 0; i < THIS.sobjs->size; i++) {	
	kno = (KnO)THIS.sobjs->list[i];
	cs.target = kno;
	if(mi->callbackPolicy & KnCALLBACK_ON_DRAG) {
	    KnCallCallbacks(w, kno, XtNinteractorCallback, (XtPointer)&cs);
	}
    }
    XtCallCallbacks(w, XtNinteractorCallback, (XtPointer)&cs);
    KnvasUpdateLayers(w);
#undef THIS
}




 void
SelectDropProc(Widget w, XEvent *event, String *params, Cardinal *num)
{
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    Cardinal i;    
    InteractorCallbackStruct cs;
    KnO kno;
    KnInteractor mi;
    
    if(NULL == THIS.target) return;
    THIS.grab = NULL;		/* release grab */
    THIS.dispatched = True;
    
    if(1 == *num) {
	mi = KnHashtableFind(interactorTable, params[0]);
    }
    else {
	XtAppWarningMsg(XtWidgetToApplicationContext(w),
			invalidParameterCount,
			actionParameters,
			KnvasWarning,
			"Action 'SelectDropProc' requires 1 parameter",
			NULL, NULL);
	return;
    }
    cs.e = event;
    cs.interactor = mi;
    cs.target = THIS.target;
    cs.reason = KnCR_DROP;
    cs.select = False;
    
    if(mi->callbackPolicy & KnCALLBACK_ON_DROP) {
	for(i = 0; i < THIS.sobjs->size; i++) {
	    cs.select = True;
	    kno = (KnO)THIS.sobjs->list[i];
	    cs.target = kno;
	    KnCallCallbacks(w, kno, XtNinteractorCallback, (XtPointer)&cs);
	}
	XtCallCallbacks(w, XtNinteractorCallback, (XtPointer)&cs);
    }
    UnselectAll(w);
    KnvasUpdateLayers(w);
    if(mi->varyCursor) {
	XUndefineCursor(XtDisplay(w), XtWindow(w));
    }
#undef THIS
}



