/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: select-move.h,v 1.8 95/07/28 15:21:41 leon Exp $ */
#ifndef __SELECT_MOVE_h
#define __SELECT_MOVE_h

#include <X11/Intrinsic.h>
#include <Kn/interactor.h>



#ifdef __cplusplus
extern "C" {
#endif


/* A select behavior
   
 * This behavior allows to select an object with the left mouse button. The
 * selection may be multiple if you press the <Shift> modifier. This behavior
 * uses the standard interactor's resources defined on the KnInteractor class.

 * TRANSLATIONS:  Set of translations for selectBehavior:
. <Btn%dDown>: Select()
 
 * USE: class writing */
extern char selectBehavior[];




/* A move behavior
   
 * This behavior allows to move an object with any mouse button. The move may
 * be multiple if you press the <Shift> modifier. This behavior
 * uses the standard interactor's resources defined on the KnInteractor class.

 * TRANSLATIONS:  Set of translations for selectBehavior:
. <Btn%dDown>: Select()
. <Btn%dMotion>: Drag()
. <Btn%dUp>: Dropp()
 
 * USE: class writing
 */
extern char moveBehavior[];


void
SelectProc(Widget w, XEvent *event, String *params, Cardinal *num);



void
SelectDragProc(Widget w, XEvent *event, String *params, Cardinal *num);
void
SelectDropProc(Widget w, XEvent *event, String *params, Cardinal *num);

void
MoveDragProc(Widget w, XEvent *event, String *params, Cardinal *num);
void
MoveDropProc(Widget w, XEvent *event, String *params, Cardinal *num);





#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif


#endif /* __SELECT_MOVE_h */
