/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: resize.h,v 1.6 95/03/24 15:34:35 leon Exp $ */
#ifndef __RESIZE_h
#define __RESIZE_h

#include <X11/Intrinsic.h>
#include <Kn/interactor.h>


#ifdef __cplusplus
extern "C" {
#endif



/* A complete resize behavior
   
 * The resizeBehavior is a translation table that define a complete behavior
 * for resizing objects with the mouse. The middle button is used to resize
 * objects. pressing with the middle button will first select the object, then
 * you can drag it moving the mouse and drop it by releasing the button. Resize
 * effect depends on where you catch the object: if you catch its top left
 * corner, you be able to grow it to the top left directions and shrink it to
 * the bottom directions. Clicking on the 4 different parts may so lead to 4
 * different resize. This behavior
 * uses the standard interactor's resources defined on the KnInteractor class.

 * TRANSLATIONS: This is the set of translations used by the Resize interactor:
- <Btn%dDown>: Select(off)
- <Btn%dMotion>: ResizeDrag()
- <Btn%dUp>: ResizeDrop()
 
 * USE: class writing
 */
extern char resizeBehavior[];




void
ResizeDragProc(Widget w, XEvent *event, String *params, Cardinal *num);
void
ResizeDropProc(Widget w, XEvent *event, String *params, Cardinal *num);



#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif

#endif /* __RESIZE_h */
