/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: resize.c,v 1.12 96/01/04 11:47:08 leon Exp $ */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "misc.h"
#include "interactor.h"
#include "knoP.h"



#define P_MOVE    0
#define P_LEFT      (1<<0)
#define P_RIGHT     (1<<1)
#define P_TOP       (1<<2)
#define P_BOTTOM    (1<<3)
#define P_LEFT_TOP     P_LEFT  | P_TOP
#define P_LEFT_BOTTOM  P_LEFT  | P_BOTTOM
#define P_RIGHT_TOP    P_RIGHT | P_TOP
#define P_RIGHT_BOTTOM P_RIGHT | P_BOTTOM



char 
resizeBehavior[] = "\
 <Btn%dDown>: Select(%s)\n\
 <Btn%dMotion>: ResizeDrag(%s)\n\
 <Btn%dUp>: ResizeDrop(%s)\n\
";  



extern Transformer
GetGlobalTransformer(Widget w, KnO s);


static enum InteractionCursor
GetResizeCursor(int kom)
{
    switch(kom) {
    case P_LEFT: return KnLEFT_CURSOR;
    case P_RIGHT: return KnRIGHT_CURSOR;
    case P_TOP: return KnTOP_CURSOR;
    case P_BOTTOM: return KnBOTTOM_CURSOR;
    case P_LEFT_TOP: return KnTOP_LEFT_CURSOR;
    case P_LEFT_BOTTOM: return KnBOTTOM_LEFT_CURSOR;
    case P_RIGHT_TOP: return KnTOP_RIGHT_CURSOR;
    case P_RIGHT_BOTTOM: return KnBOTTOM_RIGHT_CURSOR;
    }
    return KnCENTER_CURSOR;
}    



static int
KindOfMove(KnPosition cx, KnPosition cy, KnPosition rfx, KnPosition rfy)
{
    int move = 0;
    move |= (rfx < cx) ? P_LEFT: P_RIGHT;
    move |= (rfy < cy) ? P_TOP: P_BOTTOM;
    return move;
}


 void
ResizeDragProc(Widget w, XEvent *event, String *params, Cardinal *num)
{
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    InteractorCallbackStruct cs;
    KnInteractor ri;

    if(NULL == THIS.target) return;
    THIS.dispatched = True;
    
    if(1 == *num) {
	ri = KnHashtableFind(interactorTable, params[0]);
    }
    else {
	XtAppWarningMsg(XtWidgetToApplicationContext(w),
			invalidParameterCount,
			actionParameters,
			KnvasWarning,
			"Action 'ResizeDragProc' requires 1 parameter",
			NULL, NULL);
	return;
    }
    
    cs.e = event;
    cs.interactor = ri;
    cs.target = THIS.target;
    cs.reason = KnCR_DRAG;
    if(0 == THIS.sobjs->size) 
	/* Resize has no effect if there is no selected obj */
	return;
    if(NULL == THIS.gt) {
	/* there is no kno grabbing the event, start Resize */
	Cardinal i;
	KnO old;
	KnPosition rfx, rfy, cx, cy;
	THIS.gt = (Transformer *)XtMalloc(sizeof(Transformer) * 
					  THIS.sobjs->size);
	/* create the grabbing object list */
	for(i = 0; i < THIS.sobjs->size; i++) {	
	    old = (KnO)THIS.sobjs->list[i];
	    THIS.gt[i] = GetGlobalTransformer(w, old);
	    if(ri->useGhosts) {
		/* in ghost mode, we make the objects disappear */
		KnUnmap(w, old);
	    }
	}
	old = (KnO)THIS.sobjs->list[0];
	THIS.firstx = THIS.lastx = event->xbutton.x;
	THIS.firsty = THIS.lasty = event->xbutton.y;
	if(ri->useGhosts) {
	    /* first, we must commit any changes (our unmaps, for example) */
	    KnvasUpdateLayers(w);
	    /* then as we are starting to draw ghosts, we grab the
               server. disable this in Debug mode */
#ifndef Debug
	    XGrabServer(XtDisplay(w));
#endif
	    for(i = 0; i < THIS.sobjs->size; i++) {
		KnDrawBoundingGhost(w, (KnO)THIS.sobjs->list[i]);
	    }
	}
	TransformerInvTransform(THIS.gt[0], THIS.firstx, THIS.firsty,
				&rfx, &rfy);
	KlSend_center(old, &cx, &cy);
	if(old->t)
	    TransformerTransform(old->t, cx, cy, &cx, &cy);
	THIS.kindOfMove = KindOfMove(cx, cy, rfx, rfy);
    }
    {
	/* continue resize */
	Cardinal i;
	KnO kno;
	KnPosition bx, by, lx, ly, dx, dy;
	KnPosition rbx, rby, rlx, rly, rdx, rdy;

	bx = event->xbutton.x;
	by = event->xbutton.y;
	lx = THIS.lastx;
	ly = THIS.lasty;
	for(i = 0; i < THIS.sobjs->size; i++) {
	    dx = dy = rdx = rdy = 0;
	    kno = (KnO)THIS.sobjs->list[i];
	    TransformerInvTransform(THIS.gt[i], bx, by, &rbx, &rby);
	    TransformerInvTransform(THIS.gt[i], lx, ly, &rlx, &rly);
	    if(ri->useGhosts) {
		KnDrawBoundingGhost(w, kno);
	    }
	    if(! ri->constraints || strchr(ri->constraints, 'h')) {
		dx = bx-lx;
		rdx = rbx-rlx;
	    }
	    if(! ri->constraints || strchr(ri->constraints, 'v')) {
		dy = by-ly;
		rdy = rby-rly;
	    }
	    if(THIS.kindOfMove & P_LEFT) {
		dx = -dx;
		rdx = -rdx;
	    }
	    if(THIS.kindOfMove & P_TOP) {
		dy = -dy;
		rdy = -rdy;
	    }
	    if(THIS.kindOfMove & P_LEFT) {
		if(ri->useGhosts) {
		    KlSend_translate(kno, -rdx, 0);
		}
		else {
		    KnTranslate(w, kno, -rdx, 0);
		}
	    }
	    if(THIS.kindOfMove & P_TOP) {
		if(ri->useGhosts) {
		    KlSend_translate(kno, 0, -rdy);
		}
		else {
		    KnTranslate(w, kno, 0, -rdy);
		}
		
	    }
	    {
		/* compute scale factors and resize*/
		float sx, sy;
		XRectangle box;
		KlSend_boundingbox(kno, w, &box);

		sx = ((float)box.width + (float)dx) / (float)box.width;
		sy = ((float)box.height + (float)dy) / (float)box.height;
		/* do not allow "reverse resize" */
		if(((Int)(box.width + dx) > (Int)1) &&
		   ((Int)(box.height + dy) > (Int)1)) {
		    if(ri->useGhosts) {
			KlSend_resize(kno, &sx, &sy);
		    }
		    else {
			KnResize(w, kno, sx, sy);
		    }
		}
		cs.target = kno;
		KnCallCallbacks(w, kno, XtNinteractorCallback, (XtPointer)&cs);
		XtCallCallbacks(w, XtNinteractorCallback, (XtPointer)&cs);
		if(ri->useGhosts) {
		    KnDrawBoundingGhost(w, kno);
		}
	    }
	}
	THIS.lastx = event->xbutton.x;
	THIS.lasty = event->xbutton.y;
	KnvasUpdateLayers(w);
    }
    if(ri->varyCursor) {
	XDefineCursor(XtDisplay(w), XtWindow(w),
		      THIS.cursors[GetResizeCursor(THIS.kindOfMove)]);
    }
#undef THIS
}




void
ResizeDropProc(Widget w, XEvent *event, String *params, Cardinal *num)
{
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    Cardinal i;    
    InteractorCallbackStruct cs;
    KnO kno;
    KnPosition bx, by, lx, ly, rbx, rby, rlx, rly;
    KnInteractor ri;

    if(NULL == THIS.target) return;
    THIS.dispatched = True;
    THIS.grab = NULL;		/* release select grab */
    if(1 == *num) {
	ri = KnHashtableFind(interactorTable, params[0]);
    }
    else {
	XtAppWarningMsg(XtWidgetToApplicationContext(w),
			invalidParameterCount,
			actionParameters,
			KnvasWarning,
			"Action 'ResizeDragProc' requires 1 parameter",
			NULL, NULL);
	return;
    }
    bx = event->xbutton.x;
    by = event->xbutton.y;
    lx = THIS.lastx;
    ly = THIS.lasty;
    cs.e = event;
    cs.interactor = ri;
    cs.target = THIS.target;
    cs.reason = KnCR_DROP;
    cs.select = False;
    
    for(i = 0; i < THIS.sobjs->size; i++) {
	KlSend_clear((KnO)THIS.sobjs->list[i], w);
    }
    for(i = 0; i < THIS.sobjs->size; i++) {
	cs.select = False;
	kno = (KnO)THIS.sobjs->list[i];
	cs.accept = True;

	if(ri->useGhosts) {
	    /* in ghost mode, we must clear the ghosts and map back the
	       objects */
	    KnDrawBoundingGhost(w, kno);
	    KnMap(w, kno);
	}
	cs.target = kno;
	KnCallCallbacks(w, kno, XtNinteractorCallback, (XtPointer)&cs);
	XtCallCallbacks(w, XtNinteractorCallback, (XtPointer)&cs);
	if(cs.accept) {
	    KnTranslate(w, kno, 0, 0);
	}
	else {
	    /* drop back to initial position */
	    KnTranslate(w, kno, 0, 0);
	}
	if(NULL != THIS.gt)
	    XtFree((void *)THIS.gt[i]);
    }
    if(!cs.select) {
	for(i = 0; i < THIS.sobjs->size; i++){
	    KnUnselect(w, (KnO)THIS.sobjs->list[i]);
	}
	KlDecRef(THIS.sobjs);
	THIS.sobjs = KlListNMake(0);
	KlIncRef(THIS.sobjs);
    }
#ifndef Debug
    /* when we are not in debug mode, we must ungrab the server */
    if(mi->useGhosts) {
	XUngrabServer(XtDisplay(w));
    }
#endif
    KnvasUpdateLayers(w);
    if(THIS.gt)
	XtFree((void *)THIS.gt);
    THIS.gt = NULL;
    XUndefineCursor(XtDisplay(w), XtWindow(w));
#undef THIS
}

