/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: region.c,v 1.4 95/09/25 14:56:35 leon Exp $ */


#include "region.h"
#include <stdio.h>


KnRegion
KnCreateRegion()
{
    KnRegion r;
    r = (KnRegion)XtNew(KnRegionRec);
    r->inited = False;
    return r;
}


void
KnDestroyRegion(KnRegion region)
{
    region->inited = False;
    XtFree((char *)region); 
}


void
KnUnionRectWithRegion(XRectangle *rect, KnRegion src, KnRegion dest)
{
    if(src && src->inited) {
	KnRegionRec r;
	register KnPosition x1, x2, y1, y2;
	
	r = *src;
	
	x1 = rect->x;
	x2 = rect->x + rect->width;
	y1 = rect->y;
	y2 = rect->y + rect->height;
	
	if(x1 < r.x1 ) {
	    r.x1 = x1;
	}
	if(y1 < r.y1) {
	    r.y1 = y1;
	}
	if(x2 > r.x2 ) {
	    r.x2 = x2;
	}
	if(y2 > r.y2) {
	    r.y2 = y2;
	}
	*dest = r;
    }
    else {
	dest->x1 = rect->x;
	dest->y1 = rect->y;
	dest->x2 = rect->x + rect->width;
	dest->y2 = rect->y + rect->height;
    }
    dest->inited = True;
}






Boolean
KnRectInRegion(KnRegion r, KnPosition x1, KnPosition y1, KnDimension w, KnDimension h)
{
    return ((x1 <= r->x2) &&
	    (x1+(KnPosition)w >= r->x1) &&
	    (y1 <= r->y2) &&
	    (y1+(KnPosition)h >= r->y1));
}



void
KnOffsetRegion(KnRegion r, int dx, int dy)
{
    r->x1 += dx;
    r->x2 += dx;
    r->y1 += dy;
    r->y2 += dy;
}    



Boolean
KnEmptyRegion(KnRegion region)
{
    return ((! region->inited) ||
	    ((region->x1 == region->x1) &&
	    (region->y1 == region->y2)));
}


void
KnClipBox(KnRegion r, XRectangle *box)
{
    box->x = r->x1;
    box->y = r->y1;
    box->width = r->x2 - r->x1;
    box->height = r->y2 - r->y1;
}    


void
KnSetRegion(Display *dpy, GC gc, KnRegion r)
{
    XRectangle box;

    KnClipBox(r, &box);
    XSetClipRectangles(dpy, gc, 0, 0, &box, 1, Unsorted);
}    

