/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: rect.h,v 1.6 95/09/25 14:55:09 leon Exp $ */
#ifndef __KN_RECT_H
#define __KN_RECT_H

#include <X11/Intrinsic.h>
#include <Kn/kno.h>



#ifdef __cplusplus
extern "C" {
#endif


extern void KnRectImport();
extern void KnRectClassInitialize();

#define KnRectPart\
    KnOPart;\
     KnDimension width;\
     KnDimension height

#define KnFRectPart\
    KnRectPart

typedef struct KnRectStruct {
    KnRectPart;
} *KnRect;

typedef struct KnFRectStruct {
    KnFRectPart;
} *KnFRect;

/* The Rectangle Class
   
 * INHERITS: KnO
 
 * OVERRIDES:

- KnOSelDraw
- KnOSelClear
- KnOSelContains
- KnOSelBoundingBox
- KnOSelCenter
- KnOSelSize
 
 * FIELDS: new fields defined in the KnRect class are:
- width: the rectangle's width
- height: the rectangle's height

 * DESCRIPTION

 * Define a rectangular object whose top left corner is (x, y) and size is
 * (width, height). The rectangle may be rotated, translated, zoomed, using the
 * standard KnO methods. The object is drawn as a rectangle, using lineWidth
 * and foreground from its tag.

 * USE: class writing
 */
extern KlType KnRectClass;



/* The Filled Rectangle Class
   
 * INHERITS: KnRect
 
 * OVERRIDES:
- KnSelDraw

 * FIELDS: no new field defined

 * DESCRIPTION

 * Define a rectangular object whose top left corner is (x, y) and size is
 * (width, height). The rectanle may be rotated, translated, zoomed, using the
 * standard KnO methods. The object is drawn as a filled rectangle, using
 * lineWidth and foreground from its tag. It may be drawn with relief, setting
 * the shadowThickness tag's resource.

 * USE: class writing */
extern KlType KnFRectClass;


/* Builds a new KnRect Object
   
 * This is KnRect class constructor. It builds a new KnRect object, that will
 * be drawn as a rectangle, whose left corner coordinates are (x,y) and size is
 * width x height. Position and size are given in the parent's coodinates
 * system. The newly created object get it's parent tag and has no default
 * behavior.

 * USE: application programming.
 
 * returns: The newly created KnRect
 */
KnO
KnCreateRect(Widget knvas,	/* ignored. required to be consitent with other
				   constructors */
	   KnO parent,		/* the object's parent */
	   KnPosition x,		/* x coordinate of top left corner */
	   KnPosition y,		/* y coodinate of top left corner */
	   KnDimension width,	/* rectangle's width */
	   KnDimension height);	/* rectangle's height */




/* Builds a new KnFRect Object

 * This is KnFRect class constructor. It builds a new KnFRect object, that will
 * be drawn as a filled rectangle, whose left corner coordinates are (x,y) and
 * size is width x height. Position and size are given in the parent's
 * coodinates system. The newly created object get it's parent tag and has no
 * default behavior.

 * USE: application programming.
 
 * returns: The newly created KnFRect.
 */
KnO
KnCreateFRect(Widget knvas,	/* ignored. required for consistency */
	    KnO parent,		/* the object's parent */
	    KnPosition x,		/* x coordinate of top left corner */
	    KnPosition y,		/* y coodinate of top left corner */
	    KnDimension width,	/* rectangle's width */
	    KnDimension height);	/* rectangle's height */



/* KnRect Initializer

 * Initialize the KnRect fields according to the parameters. This must be
 * called by any KnRect sub-class. This will call the KnO Initializer before
 * initializing the specific KnRect fields. The new KnRect fields are:

-  rect->width = width;
-  rect->height = height;

 * USE: class writing.
 
 */
void
KnRectInit(KnRect rect,		/* the graphical object */
	   Widget knvas,	/* ignored. required for consistency */
	   KnO parent,		/* the object's parent */
	   KnPosition x,		/* x coordinate of top left corner */
	   KnPosition y,		/* y coodinate of top left corner */
	   KnDimension width,	/* rectangle's width */
	   KnDimension height);	/* rectangle's height */



/* KnFRect Initializer
   
 * Initialize the KnFRect fields according to the parameters. This must be
 * called by any KnFRect sub-class. This will cal the KnRect Initializer. There
 * is no specific KnFRect field.

 * USE: class writing.
 
 */
void
KnFRectInit(KnFRect rect,	/* the graphical object */
	    Widget knvas,	/* ignored. required for consistency */
	    KnO parent,		/* the object's parent */
	    KnPosition x,		/* x coordinate of top left corner */
	    KnPosition y,		/* y coodinate of top left corner */
	    KnDimension width,	/* rectangle's width */
	    KnDimension height);	/* rectangle's height */


#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif



#endif /* __KN_RECT_H */
