/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: poly.h,v 1.1 95/04/11 17:30:24 leon Exp $ */


#ifndef __POLY_H
#define __POLY_H

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Kn/kno.h>


#ifdef __cplusplus
extern "C" {
#endif

    
extern KlType KnPolyClass;
extern KlType KnPolylineClass;
extern KlType KnPolygonClass;



extern void KnPolyImport();
extern void KnPolyClassInitialize();



#define KnPolyPart\
    KnOPart;\
    XPoint *points;\
    int npoints


    
typedef struct KnPolyStruct {
    KnPolyPart;
} *KnPoly;


    
typedef struct KnPolylineStruct {
    KnPolyPart;
} *KnPolyline;


    
typedef struct KnPolygonStruct {
    KnPolyPart;
} *KnPolygon;






KnO
KnCreatePolyline(Widget knvas,	/* ignored. required to be consitent with other
				   constructors */
		 KnO parent,	/* the object's parent */
	       
		 XPoint points[],
		 int npoints);




KnO
KnCreatePolygon(Widget knvas,	/* ignored. required to be consitent with other
				   constructors */
		 KnO parent,	/* the object's parent */
	       
		 XPoint points[],
		 int npoints);




void
KnPolyInit(KnPoly obj,	/* the graphical object */
	   Widget knvas,	/* ignored. required for consistency */
	   KnO parent,	/* the object's parent */
	   XPoint points[],
	   int npoints);


#ifdef __cplusplus
} /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /* __POLY_H */
