/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: pcache.h,v 1.8 95/09/25 14:55:06 leon Exp $ */
#ifndef __PCACHE_H
#define __PCACHE_H

#include <X11/Intrinsic.h>
#include <X11/xpm.h>
/* an application global pixmap cache */

#define KnIntDim Dimension
#define KnIntPos Position

#ifdef __cplusplus
extern "C" {
#endif

#define PCACHE_SYM_COLORS (1<<0)
#define PCACHE_WIDTH  (1<<1)
#define PCACHE_HEIGHT  (1<<2)
#define PCACHE_SIZE (PCACHE_WIDTH|PCACHE_HEIGHT)

struct _PCacheFileStruct;
struct _PCacheImageStruct;
struct _PCachePixmapStruct;

typedef struct _PCacheAttributesStruct {
    unsigned valuemask;
    XpmColorSymbol *symcolors;
    Cardinal nsymcolors;
    KnIntDim width;
    KnIntDim height;
    KnIntDim o_width;
    KnIntDim o_height;
    XpmExtension *extensions;
    unsigned int nextensions;
} PCacheAttributesStruct, *PCacheAttributes;


typedef struct _PCachePixmapStruct {
    Pixmap pixmap;
    Pixmap mask;
    KnIntDim width;
    KnIntDim height;
    struct _PCachePixmapStruct *next;    
} PCachePixmapStruct, *PCachePixmap;


/* Pixmap Cache Access
   
 * will return the pixmap built from name, for the specified screen, and with
 * the specified size. If the pixmap was already in the cache, then its ref
 * count is incremented and nothing is done, else we search for it in the
 * hierarchy to minimize construction efforts. For example, if the file has
 * already been loaded for another screen, we do not read it once. A Pixmap
 * will be declared equal if it is on the same screen, has the same 'values'
 * and the same 'width' and 'height'. It will be automaticaly rescaled from its
 * initial size to match the required 'width' 'height' parameters.

 * PCachePixmap
 
- Dimension width;
- Dimension height;
- Pixmap pixmap;
- Pixmap mask;

 * PCacheValues

-    unsigned flags;
-    XpmColorSymbol *scolors;
-    Cardinal nsc;

 * USE: class writing
 
 * returns: a pointer on a PCachePixmapStruct, or NULL */
PCachePixmap
PCacheGetPixmap(String name,	/* pixmap name */
		Screen *screen,	/* screen where to draw the pixmap */
		PCacheAttributes values); /* discriminant values for search */




/* Pixmap Cache Preload

 * Will load the specified pixmap file if needed, returning informations about
 * it, so that classes may know some usefull pixmap informations. The pixmap
 * file name will be build by calling PCacheLocatePixmapFile.
 
 * PCacheInfos
 
-    Dimension width;
-    Dimension height;

 * PCacheValues
 
-    unsigned flags;
-    XpmColorSymbol *scolors;
-    Cardinal nsc;

 * USE: class writing
 
 * returns: pointer on a static PCacheInfosStruct */
Boolean
PCachePreload(String name,	/* pixmap name */
	      Screen *screen,	/* screen used to retrieve colors */
	      PCacheAttributes values); /* discriminant values */


/* Locate a pixmap file from pixmap name.
   
 * This function uses XtResolvePathname to try to locate the file whose name is
 * "<name>.xpm". The functions first searche in the current directory, then in
 * the "./bitmaps" directory. If the file is not found, it searches the file
 * trough the standard locations solved by XtResolvePathname (using
 * XFILESEARCHPATH). IF the file is not found, it searches with
 * XtResolvePathname using XUSERFILESEARCHPATH. In both cases, the %T indicator
 * will be reaplaced with 'bitmaps'.
 
 * returns: the complete file name on succes, NULL on failure.  It is the
 * responsibility of the caller to free the returned allocated memory.*/
char *
PCacheLocatePixmapFile(Display *dpy, /* display where to draw */
		       char *name); /* pixmap name */



#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif

    
#endif /* __PCACHE_H */
