/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: move.c,v 1.6 96/01/04 11:47:27 leon Exp $ */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include "misc.h"
#include "interactor.h"
#include "hash.h"
#include "utils.h"
#include "knoP.h"



char 
moveBehavior[] = "\
 <Btn%dDown>: Select(%s)\n\
 <Btn%dMotion>: MoveDrag(%s)\n\
 <Btn%dUp>: MoveDrop(%s)\n\
";  



Transformer
GetGlobalTransformer(Widget w, KnO s)
{
    KnO p;
    KnvasWidget cw = (KnvasWidget)w;
    Transformer t;
    t = TransformerMake();
    p = s->parent;
    while(p) {
	if(p->t)
	    TransformerPremultiply(t, p->t);
	p = p->parent;
    }
    if(cw->knvas.t)
	TransformerPremultiply(t, cw->knvas.t);
    return t;
}


void
UnselectAll(Widget w)
{
    KnvasWidget cw = (KnvasWidget)w;
    Cardinal i;
    if(cw->knvas.sobjs->size > 0) {
	for(i = 0; i < cw->knvas.sobjs->size; i++){
	    KnUnselect(w, (KnO)cw->knvas.sobjs->list[i]);
	}
	/* destroys the old list and builds a new one */
	KlDecRef(cw->knvas.sobjs);
	cw->knvas.sobjs = KlListNMake(0);
	KlIncRef(cw->knvas.sobjs);
    }
}




 void
MoveDragProc(Widget w, XEvent *event, String *params, Cardinal *num)
{
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    InteractorCallbackStruct cs;
    KnInteractor mi;

    if(NULL == THIS.target) return;
    THIS.dispatched = True;
    
    if(1 == *num) {
	mi = KnHashtableFind(interactorTable, params[0]);
    }
    else {
	XtAppWarningMsg(XtWidgetToApplicationContext(w),
			invalidParameterCount,
			actionParameters,
			KnvasWarning,
			"Action 'MoveDragProc' requires 1 parameter",
			NULL, NULL);
	return;
    }
    
    cs.e = event;
    cs.interactor = mi;
    cs.target = THIS.target;
    cs.reason = KnCR_DRAG;
    if(0 == THIS.sobjs->size) 
	/* Move has no effect if there is no selected obj */
	return;
    if(NULL == THIS.gt) {
	/* there is no transformer list, start move */
	Cardinal i;
	KnO old;
	THIS.gt = (Transformer *)XtMalloc(sizeof(Transformer) * 
					  THIS.sobjs->size);
	/* trigger the callback for any selected object */
	for(i = 0; i < THIS.sobjs->size; i++) {	
	    old = (KnO)THIS.sobjs->list[i];
	    THIS.gt[i] = GetGlobalTransformer(w, old);
	    if(mi->useGhosts) {
		/* in ghost mode, we make the objects disappear */
		KnUnmap(w, old);
	    }
	}
	THIS.firstx = THIS.lastx = event->xbutton.x;
	THIS.firsty = THIS.lasty = event->xbutton.y;
	if(mi->useGhosts) {
	    /* first, we must commit any changes (our unmaps, for example) */
	    KnvasUpdateLayers(w);
	    /* then as we are starting to draw ghosts, we grab the
               server. disable this in Debug mode */
#ifndef Debug
	    XGrabServer(XtDisplay(w));
#endif
	    for(i = 0; i < THIS.sobjs->size; i++) {
		KnDrawBoundingGhost(w, (KnO)THIS.sobjs->list[i]);
	    }
	}
    }
    {
	/* continue move */
	Cardinal i;
	KnO kno;
	KnPosition bx, by, lx, ly;
	KnPosition rbx, rby, rlx, rly;
	KnPosition dx = 0, dy = 0;

	bx = event->xbutton.x;
	by = event->xbutton.y;
	lx = THIS.lastx;
	ly = THIS.lasty;
	for(i = 0; i < THIS.sobjs->size; i++) {
	    dx = dy = 0;
	    kno = (KnO)THIS.sobjs->list[i];
	    TransformerInvTransform(THIS.gt[i], bx, by, &rbx, &rby);
	    TransformerInvTransform(THIS.gt[i], lx, ly, &rlx, &rly);
	    if(! mi->constraints || strchr(mi->constraints, 'h'))
		dx = rbx-rlx;
	    if(! mi->constraints || strchr(mi->constraints, 'v'))
		dy = rby-rly;
	    if(mi->useGhosts) {
		/* in shadow mode, we draw only bounding boxes */
		KnDrawBoundingGhost(w, kno);
		KlSend_translate(kno, dx, dy);
		KnDrawBoundingGhost(w, kno);
	    }
	    else {
		KnTranslate(w, kno, dx, dy);
	    }
	    if(mi->callbackPolicy & KnCALLBACK_ON_DRAG) {
	        cs.target=kno;
		KnCallCallbacks(w, kno, XtNinteractorCallback, (XtPointer)&cs);
		XtCallCallbacks(w, XtNinteractorCallback, (XtPointer)&cs);
	    }
	}
	THIS.lastx = event->xbutton.x;
	THIS.lasty = event->xbutton.y;
    }
    KnvasUpdateLayers(w);
#undef THIS
}




 void
MoveDropProc(Widget w, XEvent *event, String *params, Cardinal *num)
{
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    Cardinal i;    
    InteractorCallbackStruct cs;
    KnO initial, kno;
    KnPosition bx, by, lx, ly;
    KnPosition x, y;
    KnInteractor mi;
    
    if(NULL == THIS.target) return;
    THIS.grab = NULL;		/* release grab */
    THIS.dispatched = True;
    
    if(1 == *num) {
	mi = KnHashtableFind(interactorTable, params[0]);
    }
    else {
	XtAppWarningMsg(XtWidgetToApplicationContext(w),
			invalidParameterCount,
			actionParameters,
			KnvasWarning,
			"Action 'MoveDropProc' requires 1 parameter",
			NULL, NULL);
	return;
    }
    bx = event->xbutton.x;
    by = event->xbutton.y;
    lx = THIS.lastx;
    ly = THIS.lasty;
    cs.e = event;
    cs.interactor = mi;
    cs.target = THIS.target;
    cs.reason = KnCR_DROP;
    cs.select = True;
    for(i = 0; i < THIS.sobjs->size; i++) {
	KlSend_clear((KnO)THIS.sobjs->list[i], w);
    }
    for(i = 0; i < THIS.sobjs->size; i++) {
	cs.select = True;
	kno = (KnO)THIS.sobjs->list[i];
	initial = (KnO)THIS.sobjs->list[i];
	cs.accept = True; 

	/* the drop coordinates are the moved obj location */
	KlSend_position(kno, &x, &y);
	cs.tox = x;
	cs.toy = y;
	if(mi->useGhosts) {
	    /* in ghost mode, we must clear the ghosts and map back the
	       objects */
	    KnDrawBoundingGhost(w, kno);
	    KnMap(w, kno);
	}
	if(mi->callbackPolicy & KnCALLBACK_ON_DROP) {
	    cs.target = kno;
	    KnCallCallbacks(w, kno, XtNinteractorCallback, (XtPointer)&cs);
	    XtCallCallbacks(w, XtNinteractorCallback, (XtPointer)&cs);
	}
	if(cs.accept) {
	    KnMove(w, kno, cs.tox, cs.toy);
	    KlSend_clear(kno,w );
	}
	else {
	    /* drop back to initial position */
	    KnTranslate(w, kno,
			    initial->x - kno->x,
			    initial->y - kno->y);
	    KlSend_clear(kno,w );
	}
	if(NULL != THIS.gt) {
	    XtFree((void *)THIS.gt[i]);
	}
    }
    if(!cs.select) {
	for(i = 0; i < THIS.sobjs->size; i++){
	    KnUnselect(w, (KnO)THIS.sobjs->list[i]);
	}
	KlDecRef(THIS.sobjs);
	THIS.sobjs = KlListNMake(0);
	KlIncRef(THIS.sobjs);
    }
#ifndef Debug
    if(mi->useGhosts) {
	XUngrabServer(XtDisplay(w));
    }
#endif
    KnvasUpdateLayers(w);
    if(THIS.gt)
	XtFree((void *)THIS.gt);
    THIS.gt = NULL;
    if(mi->varyCursor) {
	XUndefineCursor(XtDisplay(w), XtWindow(w));
    }

#undef THIS
}



