/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: misc.c,v 1.5.2.1 96/03/27 16:30:41 leon Exp $ */


#include "misc.h"
#include "knoP.h"

void
StringToLower(register char  *source,
	      register char  *dest)
{
    register char ch;
    int i;

    for (i = 0; (ch = *source) != 0 && i < 999; source++, dest++, i++) {
    	if ('A' <= ch && ch <= 'Z')
	    *dest = ch - 'A' + 'a';
	else
	    *dest = ch;
    }
    *dest = 0;
}






static void
DrawUglySelectedBox(KnTag tag,  KnDrawingContext ct, XRectangle *box)
{
    KnvasWidget w = (KnvasWidget)ct->w;
    XSetClipMask(ct->dpy, w->knvas.selectgc, None);
    XDrawRectangle(ct->dpy, ct->win, w->knvas.selectgc, box->x, box->y,
		   box->width, box->height);
}    



static void
DrawFancySelectedBox(KnTag tag,  KnDrawingContext ct, XRectangle *box)
{
    KnvasWidget w = (KnvasWidget)ct->w;
    PCachePixmap tlc;

    tlc = PCacheGetPixmap("top_left_corner", XtScreen(w), NULL);
    XSetClipMask(ct->dpy, w->knvas.selectgc, tlc->mask);
    XSetClipOrigin(ct->dpy, w->knvas.selectgc, box->x, box->y);
    XCopyArea(ct->dpy, tlc->pixmap, ct->win, w->knvas.selectgc, 0, 0, 8, 8,
	      box->x,
	      box->y);

    tlc = PCacheGetPixmap("top_right_corner", XtScreen(w), NULL);
    XSetClipMask(ct->dpy, w->knvas.selectgc, tlc->mask);
    XSetClipOrigin(ct->dpy, w->knvas.selectgc, box->x+box->width-8, box->y);
    XCopyArea(ct->dpy, tlc->pixmap, ct->win, w->knvas.selectgc, 0, 0, 8, 8,
	      box->x+box->width-8,
	      box->y);

    tlc = PCacheGetPixmap("bottom_left_corner", XtScreen(w), NULL);
    XSetClipMask(ct->dpy, w->knvas.selectgc, tlc->mask);
    XSetClipOrigin(ct->dpy, w->knvas.selectgc, box->x, box->y+box->height-8);
    XCopyArea(ct->dpy, tlc->pixmap, ct->win, w->knvas.selectgc,
	      0, 0, 8, 8,
	      box->x,
	      box->y+box->height-8);

    tlc = PCacheGetPixmap("bottom_right_corner", XtScreen(w), NULL);
    XSetClipMask(ct->dpy, w->knvas.selectgc, tlc->mask);
    XSetClipOrigin(ct->dpy, w->knvas.selectgc,
		   box->x+box->width-8, box->y+box->height-8);
    XCopyArea(ct->dpy, tlc->pixmap, ct->win, w->knvas.selectgc,
	      0, 0, 8, 8,
	      box->x+box->width-8,
	      box->y+box->height-8);

    
} 

void
KnDrawSelectedBox(KnTag kntag,  KnDrawingContext ct, XRectangle *box)
{
    TagObject tag = (TagObject)kntag;
    if(KnSELECTION_UNVISIBLE == tag->tag.selectionLook) return;
    if((KnSELECTION_FANCY == tag->tag.selectionLook) &&
       (box->width>=16) && (box->height>=16))
	DrawFancySelectedBox((KnTag)tag, ct, box);
    else
	DrawUglySelectedBox((KnTag)tag, ct, box);
}



KlO
KlListDeletePos(KlList list, unsigned int i)
{
    KlO *p, *end;

    if (i < list->size) {
        KlDecRef(list->list[i]);
        list->size--;
        p = list->list + i;
        end = list->list + list->size;
        while (p < end) {
            *p = *(p+1);
            p++;
        }
    }
    return (KlO) list;
}




void
KlListDeleteObj(KlList list, KlO o)
{
    Int i;

    for (i = 0; i < list->size; i ++) {
	if(list->list[i] == o) {
	    KlListDeletePos(list, i);
	    break;
	}
    }
}



void
KlListDeleteNonKlO(KlList list, KlO o)
{
    Int i;

    for (i = 0; i < list->size; i ++) {
	if(list->list[i] == o) {
	    list->list[i] = NULL;
	    KlListDeletePos(list, i);
	    break;
	}
    }
}



KlO
KlListAppendNonKlO(KlList list, KlO obj)
{
    list->size++;
    list->list = (KlO *) Realloc(list->list, KLSO * list->size);
    list->list[list->size - 1] = obj;
    return (KlO) list;
}
