/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: line.h,v 1.7 95/09/25 14:55:03 leon Exp $ */
#ifndef __KN_LINE_H
#define __KN_LINE_H

#include <Kn/kno.h>


#ifdef __cplusplus
extern "C" {
#endif



extern void KnLineImport();
extern void KnLineClassInitialize();

#define KnLinePart\
    KnOPart;\
    KnPosition width;\
    KnPosition height


typedef struct KnLineStruct {
    KnLinePart;
} *KnLine;





/* The Line Class
   
 * INHERITS: KnO
 
 * OVERRIDES:

- KnOSelDraw
- KnOSelClear
- KnOSelContains
- KnOSelSize
 
 * FIELDS: new fields defined in the KnRect class are:
 
- width: the line's width
- height: the line's height

 * DESCRIPTION

 * Define a line object whose top left corner is (x, y) and size is (width,
 * height). The line may be rotated, translated, zoomed, using the standard KnO
 * methods. The object is drawn as a line, using lineWidth and foreground from
 * its tag. When the line is vertical or horizontal, it may be drawn with
 * relief, setting the shadowThicknes tag's resource.

 * WARNING: The target point must be defined as relative to the origin point

 * USE: class writing
 */
extern KlType KnLineClass;


/* Builds a new KnLine object.
   
 * This is the KnLine class constructor. It builds a new KnLine object that
 * will be drawn as a line, whose source point coodinates are (x, y) and
 * target's point coordinates are (tox, toy). Positions are given in the
 * parent's coordinates system. The newly created object gets its parent's tag
 * and has no default behavior.

 * USE: application programming.
 
 * returns: The newly created KnLine.
 */
KnO
KnCreateLine(Widget knvas,	/* ignored. required for consistency */
	   KnO  parent,		/* the object's parent */
	   KnPosition x,		/* x coordinate of source point */
	   KnPosition y,		/* y coodinate of source point */
	   KnPosition tox,	/* x coordinate of target point */
	   KnPosition toy);	/* y coodinate of target point */



/* KnLine Initializer
   
 * Initialize the KnLine fields, according to the parameters. This must be
 * called by any KnLine sub-class. This will call the KnO initializer before
 * initializing the KnLine specific fields. The KnLine specific fields are:

-  l->width = tox - x;
-  l->height = toy - y;

 * WARNING: line fields are width, height, so that the target point is relative
 * to the origin point (x, y). Keeping only tox and toy in the KnLine object
 * make us lose benefice of transformations.

 * USE: class writing
 
 * returns: */
void
KnLineInit(KnLine l,		/* the KnLine object */
	   Widget knvas,	/* the knvas widget */
	   KnO parent,		/* the object's parent */
	   KnPosition x,		/* x coordinate of source point */
	   KnPosition y,		/* y coodinate of source point */
	   KnPosition tox,	/* x coordinate of target point */
	   KnPosition toy);	/* y coodinate of target point */


#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif


#endif /* __KN_LINE_H */
