/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: label.c,v 1.9 96/01/04 11:47:21 leon Exp $ */
#include "label.h"
#include "TagP.h"
#include "knstring.h"

#ifdef LOOK3D
#include <Xm/Xm.h>
#endif /* LOOK3D */



/* type desc */
KlType KnLabelClass;




/* init class fields and call super class Init proc */
void
KnLabelInit(KnLabel l, Widget knvas, KnO parent, KnPosition x, KnPosition y,
	    char *s)
{
    KnOInit((KnO)l, knvas, parent, x, y);
    l->s = XtNewString(s);
    l->len = strlen(s);
}


void
KnLabelCopyFields(KnLabel new, KnLabel old)
{
    KnOCopyFields((KnO)new, (KnO)old);
    new->s = XtNewString(old->s);
}


void
KnLabelFree(KnLabel l)
{
    XtFree(l->s);
    KnOFree((KnO)l);
}


/* allocates storage space for a new label
 * 
 * returns: the newly created KnO
 */
KnO
KnCreateLabel(Widget knvas, KnO parent, KnPosition x, KnPosition y, 
	    char *s)
{
    KnLabel label;
    label =  (KnLabel)KlOMake(KnLabelClass);
    KnLabelInit(label, knvas, parent, x, y, s);
    return (KnO)label;
}


void
KnLabelDraw(KnLabel label, KnDrawingContext ct, Transformer tf) 

{
    Transformer t;    
    XPoint points[2];
    XRectangle box;
    TagObject tag;
    int width, height, shw = 0;

    tag = (TagObject)KnGetTag(ct->w, (KnO)label);
    width = XTextWidth(tag->tag.font, label->s, label->len);
    height = tag->tag.font->ascent + tag->tag.font->descent;
    t = tf;
    points[0].x = label->x;
    points[0].y = label->y;
    points[1].x = label->x + width;
    points[1].y = label->y + height;
    if(t) {
	
	TransformerTransformPointList(t, points, 2, points);
    }
    GetBoundingBox(points, 2, &box);
#ifdef LOOK3D
    shw = tag->tag.shadowThickness;
#endif    
    
    if(KnRectInRegion(ct->clip, box.x, box.y, 
		     box.width+shw, box.height+shw)) {
#ifdef LOOK3D
	if(tag->tag.shadowThickness) {
	    GC top_gc, bottom_gc;
	    KnDimension top_thick = 1, bottom_thick = 1;
	    if(XmSHADOW_OUT == tag->tag.shadowType) {
		top_gc =  tag->tag.top_shadow_gc;
		bottom_gc = tag->tag.bottom_shadow_gc;
		bottom_thick = tag->tag.shadowThickness;
	    }
	    else {
		top_gc =  tag->tag.bottom_shadow_gc;
		bottom_gc = tag->tag.top_shadow_gc;
		top_thick = tag->tag.shadowThickness;
	    }
	    
	    KnSetRegion(ct->dpy, top_gc, ct->clip);
	    KnSetRegion(ct->dpy, bottom_gc, ct->clip);
	    /* draw the top shadow */
	    KnStringDraw(ct->dpy, ct->win, top_gc,
			points[0].x-top_thick,
			points[0].y - top_thick,
			label->s, t, ct,  &box, tag);
	    /* draw the bottom shadow */
	    KnStringDraw(ct->dpy, ct->win, bottom_gc,
			points[0].x+bottom_thick,
		    points[0].y + bottom_thick,
			label->s,  t, ct,  &box, tag);
	}
#endif /* LOOK3D */
	KnStringDraw(ct->dpy, ct->win, tag->tag.gc,
		    points[0].x, points[0].y,
		    label->s, t, ct, &box, tag);
    }
    if(DrawSelection(label))
	KnDrawSelectedBox(tag, ct, &box);
}

void
KnLabelBoundingBox(KnLabel label, Widget view, XRectangle *box)
{
    XPoint points[2];
    TagObject tag;
    int width;

    tag = (TagObject)KnGetTag(view, (KnO)label);
    width = XTextWidth(tag->tag.font, label->s, label->len);

    points[0].x = label->x;
    points[0].y = label->y;
    points[1].x = label->x + width;
    points[1].y = label->y + tag->tag.font->ascent + tag->tag.font->descent;

    KnTransformPointList(view, label, points, 2);
    GetBoundingBox(points, 2, box);
}

void
KnLabelClear(KnLabel label, Widget w)
{
    XPoint points[2];
    TagObject tag;
    int width;

    tag = (TagObject)KnGetTag(w, (KnO)label);
    width = XTextWidth(tag->tag.font, label->s, label->len);

    points[0].x = label->x;
    points[0].y = label->y;
    points[1].x = label->x + width;
    points[1].y = label->y + tag->tag.font->ascent + tag->tag.font->descent;

#ifdef LOOK3D
    if(tag->tag.shadowThickness) {
	XRectangle extra;
	extra.x = extra.y = tag->tag.shadowThickness;
	extra.width = extra.height = 2*tag->tag.shadowThickness;
	KlSend_clearbox(label, points, 2, &extra);
	return;
    }
#endif /* LOOK3D */
    KlSend_clearbox(label, points, 2, NULL);
}



KnO
KnLabelContains(KnLabel label, Widget w, Int x, Int y)
{
    Boolean res;
    KnPosition rx = x, ry = y;
    TagObject tag;
    int width;

    tag = (TagObject)KnGetTag(w, (KnO)label);
    width = XTextWidth(tag->tag.font, label->s, label->len);

    if(label->t) {
	TransformerInvTransform(label->t, x, y, &rx, &ry);
    }

    res = (rx >= label->x) && (rx <= label->x + width) &&
	(ry >= label->y) && (ry <= label->y + tag->tag.font->ascent
			     + tag->tag.font->descent);
    return res ? (KnO)label : NULL;
}


/* declare new   selectors
 */
void
KnLabelImport()
{
	
}



/* class initializations for KnLabel objects
 * 
 * returns: 
 */
void
KnLabelClassInitialize()
{
     /* declare  type */
    KlDeclareSubType(&KnLabelClass, "KnLabel", KnOClass, sizeof(struct KnLabelStruct));

    /* declare methods */
    KlDeclareMethod(KnLabelClass, KlSelFree, KnLabelFree);
    KlDeclareMethod(KnLabelClass, KnOSelCopyFields, KnLabelCopyFields);
    KlDeclareMethod(KnLabelClass, KnOSelDraw, KnLabelDraw);
    KlDeclareMethod(KnLabelClass, KnOSelClear, KnLabelClear);
    KlDeclareMethod(KnLabelClass, KnOSelContains, KnLabelContains);
    KlDeclareMethod(KnLabelClass, KnOSelBoundingBox, KnLabelBoundingBox);

}
