/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: knstring.h,v 1.4 95/09/28 11:58:29 leon Exp $ */
#ifndef __KNSTRING_H
#define __KNSTRING_H

#include <X11/Intrinsic.h>
#include <Kn/TagP.h>
#include <Kn/transformer.h>
#include <Kn/kno.h>

#ifdef __cplusplus
extern "C" {
#endif


/* The KnString type is introduced for forward compatibility, because KnLAbel
   could maybe used XmString instead of 'char *' */
typedef char *KnString;




KnDimension
KnStringWidth(KnString s, KnTag tag);


KnDimension
KnStringHeight(KnString s, KnTag tag);


void
KnStringDraw(Display *dpy, Drawable dest, GC gc,
	     KnPosition x, KnPosition y,
	     KnString str, Transformer t, KnDrawingContext ct,
	     XRectangle *box, TagObject kntag);




#ifdef __cplusplus
} /* Close scope of 'extern "C"' declaration which encloses file. */
#endif




#endif /* __KNSTRING_H */
/* DON'T ADD ANYTHING AFTER THIS #endif */
