/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: knstring.c,v 1.4 95/09/28 11:58:35 leon Exp $ */


#include <string.h>
#include "knstring.h"
#include "TagP.h"
#include "KnvasP.h"

/* consider that 2 floats are equal if difference is less than this */
#define DEFAULT_TOLERANCE 0.05


KnDimension
KnStringWidth(char *s, KnTag kntag)
{
    TagObject t = (TagObject)kntag;
    return XTextWidth(t->tag.font, s, strlen(s));
}





KnDimension
KnStringHeight(char *s, KnTag kntag)
{
    KnDimension height;
    TagObject t = (TagObject)kntag;
    height = t->tag.font->ascent + t->tag.font->descent;
#ifdef LOOK3D
    if(t->tag.shadowThickness) {
	height += t->tag.shadowThickness;
    }
#endif /* LOOK3D */
    return height;
}


extern XImage *
ScaleMaskImage(Screen *screen, XImage *src, double scale_x, double scale_y);


void
CreateMaskgc1(KnvasWidget kw)
{
    XtGCMask value_mask;
    XGCValues values;
    value_mask = GCFunction | GCBackground | GCForeground;
    values.background = 0xFFFFFFFFL;
    values.foreground = 0L;
    values.function = GXcopy;
    kw->knvas.maskgc1 = XtAllocateGC((Widget)kw, 1, value_mask, &values,
				      None, ~value_mask);
}


/* If the current transformer is unscaled or if it is scaled than a total
 * factor (sx * sy) > 1, use the standard draw, else scale the string.
 */
void
KnStringDraw(Display *dpy, Drawable dest, GC gc, KnPosition x,
	     KnPosition y, KnString str, Transformer t, KnDrawingContext ct,
	     XRectangle *box, TagObject tag)
{
    KnvasWidget kw = (KnvasWidget)ct->w;
#define THIS kw->knvas
    if(t && (TransformerScaled(t, DEFAULT_TOLERANCE))
	&& ((t->mat00 * t->mat11) < 1)) {
	Pixmap tmpix, mask;
	XImage *unscaled, *scaled;
	unsigned int width, height, sw, sh;
	width = KnStringWidth(str, (KnTag)tag);
	height = KnStringHeight(str, (KnTag)tag);
	
	sw = width * t->mat00;	/* scaled width */
	sh = height * t->mat11;	/* scaled height */
	if((sh < 5) || sw == 0) {
	    /* do not draw unreadable strings */
	    return;
	}
	tmpix = 
	    XCreatePixmap(dpy, dest, width, height, 1);
	mask = XCreatePixmap(dpy, dest, sw, sh, 1);
	if(None == THIS.maskgc1) {
	    CreateMaskgc1(kw);
	}
	/* clear the string pixmap */
	XSetForeground(dpy, THIS.maskgc1, 0L);
	XFillRectangle(dpy, tmpix, THIS.maskgc1, 0, 0, width, height);
	/* and draw the string, restore it after drawing */
	XSetForeground(dpy, THIS.maskgc1, 1L);
	XDrawString(dpy, tmpix,  THIS.maskgc1, 0, tag->tag.font->ascent,
		    str, strlen(str));
	/* get the image and scale it */
	unscaled =
	    XGetImage(dpy, tmpix, 0, 0, width, height, AllPlanes, ZPixmap);
	scaled = ScaleMaskImage(DefaultScreenOfDisplay(dpy),
				unscaled, t->mat00, t->mat11);
	/* then draw the scaled string in the mask */
	XPutImage(dpy, mask, THIS.maskgc1, scaled, 0, 0, 0, 0, sw, sh);
	

	/* Joe Rumsey's technique for clipmasks : first XCopyPlane set to 0 the
	    bits that will be drawn, leaving untouched the outer mask. The
	    second XCopyPlane makes an OR of the drawn bits with 0 and leaves
	    untouched the outer mask. This gives a redraw speedup between 25
	    and 50% (maybe more according to Joe). */
	XCopyPlane(dpy, mask, dest, THIS.maskgc, 0, 0, sw, sh, x, y, 1);
	XSetFunction(dpy, tag->tag.gc, GXor);
	XSetBackground(dpy, tag->tag.gc, 0L);
	XCopyPlane(dpy, mask, dest,  tag->tag.gc, 0, 0, sw, sh, x, y, 1);
	XSetFunction(dpy, tag->tag.gc, GXcopy);
	XSetBackground(dpy, tag->tag.gc, tag->tag.background);

	XDestroyImage(scaled);
	XDestroyImage(unscaled);
	XFreePixmap(dpy, tmpix);
	XFreePixmap(dpy, mask);
    }
    else {
	/* unscaled */
	XDrawString(dpy, dest, tag->tag.gc, x,
		    y+tag->tag.font->ascent, str, strlen(str));
    }
}
