/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: kno.h,v 1.11 95/09/28 11:57:31 leon Exp $ */
#ifndef __KN_O_H
#define __KN_O_H


#include <X11/Intrinsic.h>

#include <Kn/region.h>

#ifdef ISM
#include "wool.h"
#include "wl_list.h"
#else
#include <KlLib.h>
#endif /* ISM */
#include <Kn/Tag.h>
#include <Kn/transformer.h>
#include <Kn/interactor.h>


#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned Selector;
typedef unsigned Trait;

typedef struct _KnDrawingContextStruct {
    Display *dpy;
    Widget w;
    Drawable win;
    KnRegion clip;    
} KnDrawingContextStruct, *KnDrawingContext;




extern Selector KnOSelBoundingBox;
extern Selector KnOSelCenter;
extern Selector KnOSelClear;
extern Selector KnOSelClearBox;
extern Selector KnOSelCopyFields;
extern Selector KnOSelContains;
extern Selector KnOSelDestroy;
extern Selector KnOSelDispatch;
extern Selector KnOSelDraw;
extern Selector KnOSelDrawSelection;
extern Selector KnOSelMove;
extern Selector KnOSelPosition;
extern Selector KnOSelResize;
extern Selector KnOSelRotate;
extern Selector KnOSelSelect;
extern Selector KnOSelSize;
extern Selector KnOSelTranslate;
extern Selector KnOSelUnselect;


extern Trait KnOTrait_kno;


#define KlSend_draw(o, ct, box)\
    KlSend(KnOSelDraw, o, (o, ct, box))
#define KlSend_drawselection(o, dpy, win, box, tag)\
    KlSend(KnOSelDrawSelection, o, (o, dpy, win, box, tag))
#define KlSend_clear(o, w) KlSend(KnOSelClear, o, (o, w))
#define KlSend_destroy(o) KlSend(KnOSelDestroy, o, (o))
#define KlSend_clearbox(o, ul, br, extra) KlSend(KnOSelClearBox, o, (o, ul, br, extra))
#define KlSend_boundingbox(o, v, b) KlSend(KnOSelBoundingBox, o, (o, v, b))
#define KlSend_center(o, x, y) KlSend(KnOSelCenter, o, (o, x, y))
#define KlSend_select(o, w) KlSend(KnOSelSelect, o, (o, w))
#define KlSend_unselect(o, w) KlSend(KnOSelUnselect, o, (o, w))
#define KlSend_rotate(o, x, y, a) KlSend(KnOSelRotate, o, (o, x, y, a))
#define KlSend_translate(o, dx, dy) KlSend(KnOSelTranslate, o, (o, dx, dy))
#define KlSend_move(o, tox, toy) KlSend(KnOSelMove, o, (o, tox, toy))
#define KlSend_resize(o, sx, sy) KlSend(KnOSelResize, o, (o, sx, sy))
#define KlSend_contains(o, w, x, y) KlSend(KnOSelContains, o, (o, w, x, y))
#define KlSend_dispatch(o, w, e, x, y) KlSend(KnOSelDispatch, o, (o, w, e, x, y))
#define KlSend_position(o, x, y) KlSend(KnOSelPosition, o, (o, x, y))
#define KlSend_size(o, w, h) KlSend(KnOSelSize, o, (o, w, h))

extern void KnOImport();
extern void KnOClassInitialize();


enum _KnFlag {
    KnSELECTED_FLAG = (1<<0),
    KnSHOW_SELECTION_FLAG = (1<<1),
    KnCLEARED_FLAG = (1<<2),
    KnMAPPED_FLAG = (1<<3),
    KnSENSITIVE_FLAG = (1<<4)
};

#define DrawSelection(obj)\
    ((obj->flags & KnSELECTED_FLAG)&&(obj->flags & KnSHOW_SELECTION_FLAG))

#define KnIsSensitive(obj)\
	(((KnO)obj)->flags & KnSENSITIVE_FLAG)

#define KnIsSelected(obj)\
	(((KnO)obj)->flags & KnSELECTED_FLAG)

#define KnIsMapped(obj)\
	(((KnO)obj)->flags & KnMAPPED_FLAG)

#define KnIsUnmapped(obj)\
	(!(((KnO)obj)->flags & KnMAPPED_FLAG))

struct KnOStruct;
typedef struct KnOStruct *KnO;



#define KnOPart\
    KlKLONE_HEADER;\
    unsigned char flags;\
    KnTagId tid;\
    KnInteractor interactor;\
    Transformer t;\
    XtCallbackList interactorCallback;\
    KnO parent;\
    KlList anchors;\
    KnPosition x;\
    KnPosition y


struct KnOStruct {
    KnOPart;
};



/* The KnO abstract class
   
 * This is the base class for all the graphical object classes. This class
 * must not be instancied, though it would run, it would produce no graphical
 * effect. Class fields are:

- flags: contains object current status (selection,...)
- tid: object's tid. To implement multi display, an object does not reference
directly, a tag, but a tag id. When he need the tag (for a draw ) operation,
the kno must ask for the corresponding tag to the view where he wants to draw.
- interactor: the object's interactor
- t: transformer describing the object's appearance (rotate, scale)
- x, y: object's reference point
- interactorCallback: callback that will be called by any interactor
- parent: the parent object
- anchors: a (possibly NULL) list of anchor points

 * METHODS
 * Here is the list of the selectors defined by the KnO class and whose method
 * is defined for class KnO.

- KnOSelClearBox
- KnOSelRotate
- KnOSelTranslate
- KnOSelMove
- KnOSelResize
- KnOSelDispatch
- KnOSelSelect
- KnOSelUnselect
- KnOSelDrawSelection

 * PVM
 
 * Here is the list of the PURE VIRTUAL METHODS defined for class KnO (i.e
 * selectors are defined on KnO, but methods are not, so these methods MUST BE
 * written for any KnO subclass.

- KnOSelDraw
- KnOSelClear
- KnOSelBoundingBox
- KnOSelCenter
- KnOSelContains

 * returns:
 */
extern KlType KnOClass;



/* KnO Initializer
   
 * Initialize the KnO fields according to the parameters. This must be called
 * by any KnO sub-class. Object's parent (parent) will be notified of its new
 * child. The new KnO fields are:
 * 
-    kno->parent = parent;
-    kno->interactor = NULL;
-    kno->flags = KnSENSITIVE_FLAG;
-    kno->interactorCallback = NULL;
-    kno->t = NULL;
-    kno->x = x;
-    kno->y = y;
-    kno->tid  = parent->tid; 
-    kno->anchors = NULL
    
 returns: */
void
KnOInit(KnO  kno,		/* the kno object */
	Widget knvas,		/* a knvas widget */
	KnO parent,		/* object's parent */
	KnPosition x,		/* x reference coordinate */
	KnPosition y);		/* y reference coordinate */


void
KnOFree(KnO kno);

void
GetBoundingBox(XPoint points[], Cardinal n, XRectangle *box);



void
KnOClearAnchors(KnO obj, Widget w);

void
KnOTranslateAnchors(KnO kno, Int dx, Int dy);


#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif


#endif /* __KN_O_H */
