/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: init.c,v 1.7 95/07/28 15:21:50 leon Exp $ */

/* functions called by klone at Init time */
#include <X11/Intrinsic.h>
#include <Kn/kno.h>



#ifndef ultrix
#define IMPORT_MODULE(name)\
name##Import()
#define USE_MODULE(name)\
name##ClassInitialize()
#else /* ultrix */ 
#define IMPORT_MODULE(name)\
name/**/Import()
#define USE_MODULE(name)\
name/**/ClassInitialize()
#endif /* ultrix */ 

    
/* init of selectors */
void
KnOModuleImport()
{
    IMPORT_MODULE(KnO);

    IMPORT_MODULE(KnRect);
    IMPORT_MODULE(KnGroup);
    IMPORT_MODULE(KnLayer);
    IMPORT_MODULE(KnInteractor);
    IMPORT_MODULE(KnLine);
    IMPORT_MODULE(KnArc);
    IMPORT_MODULE(KnIcon);
    IMPORT_MODULE(KnLabel);
    IMPORT_MODULE(KnLink);
    IMPORT_MODULE(KnAnchor);
    IMPORT_MODULE(KnPoly);
    
}

/* init of types */
void
KnOModuleInit()
{ 
    USE_MODULE(KnO);

    USE_MODULE(KnRect);
    USE_MODULE(KnGroup);
    USE_MODULE(KnLayer);
    USE_MODULE(KnInteractor);
    USE_MODULE(KnLine);
    USE_MODULE(KnArc);
    USE_MODULE(KnIcon);
    USE_MODULE(KnLabel);
    USE_MODULE(KnLink);
    USE_MODULE(KnAnchor);
    USE_MODULE(KnPoly);
}


/* klone level inits */
void
KnOModuleKloneInit()
{
    
}

void
KnInitialize(Boolean do_kl_init)
{
    static int initialized = 0;
    if(initialized) return;
    
    KlDeclareExtension("KnObjects", KnOModuleImport, KnOModuleInit, 0);

    if(do_kl_init) {
	KlTextExtension = ".kl";
	KlInit();
    }
    initialized = 1;
}
