/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: icon.h,v 1.8 95/09/25 14:54:58 leon Exp $ */
#ifndef __KN_ICON_H
#define __KN_ICON_H


#include <Kn/rect.h>
#include <Kn/pcache.h>


#ifdef __cplusplus
extern "C" {
#endif


extern void KnIconImport();
extern void KnIconClassInitialize();

#define KnIconPart\
    KnRectPart;\
    char *name




typedef struct KnIconStruct {
    KnIconPart;
} *KnIcon;


/* The Icon Class
   
 * INHERITS: KnRect
 
 * OVERRIDES:

- KnOSelDraw
- KnOSelFree
 
 * FIELDS: new fields defined in the KnIcon class are:
 
- name: the icon's name


 * DESCRIPTION

 * The KnIcon class uses the XPM library to build and draw color icons. It uses
 * an application global cache to retreive and share pixmaps between two
 * KnIcons, so that if 2 (or more) KnIcon use the same pixmap, it will be built
 * only once in the X server. The symColors tag's resource defines a set of
 * symbolic colors that are used to draw the pixmap. See the XPM manual for
 * more details on symbolic colors overriding.

 * WARNING: a KnIcon may not be rotated.

 * USE: class writing
 */
extern KlType KnIconClass;




/* Builds a new KnIcon object
   
 * This is the KnIcon class constructor. It builds a new KnIcon object that
 * will be drawn as a pixmap. The pixmap is drawn so that (x,y) will be its top
 * left corner coordinates. The name parameter is used to retrieve the icon
 * file (see KnIconInit). The newly created object get it's parent tag and has
 * no default behavior.

 * USE: application programming.
 
 * returns: The newly created KnIcon */
KnO
KnCreateIcon(Widget knvas,	/* used to retrieve screen */
	   KnO parent,		/* the object's parent */
	   char *name,		/* pixmap's name */
	   KnPosition x,		/* top left corner x coordinate */
	   KnPosition y);		/* top left corner y coordinate */





/* KnIcon Initializer
   
 * Initialize the KnIcon specific fields. This should be called by any KnIcon
 * sub-class. This will initializes the specific KnIcon fields and then call
 * the KnRect Initializer. This will build the pixmap file name by searching
 * the file named <name>.xpm through the XFILESEARCHPATH and
 * XUSERFILESEARCHPATH paths and preload the found file in the global pixmap
 * cache, to get the picmap size. Then, it calls the KnRect Initializer with
 * this size.

 * USE: class writing
 
 * returns: */
void
KnIconInit(KnIcon icon,		/* the graphical object */
	   Widget knvas,	/* used to retrieve screen */
	   KnO parent,		/* the object's parent */
	   char *name,		/* pixmap's name */
	   KnPosition x,		/* top left corner x coordinate */
	   KnPosition y);		/* top left corner y coordinate */




#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif


#endif /* __KN_ICON_H */
